/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.management.model.J2EEDeployedObjectMdl;
import com.sun.enterprise.management.util.J2EEModuleCallBack;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;

public class J2EEApplicationMdl
extends J2EEDeployedObjectMdl {
    private static String MANAGED_OBJECT_TYPE = "J2EEApplication";
    private String appName = null;
    private boolean hasWebServices = false;
    private String[] endpointAddresses = null;

    public J2EEApplicationMdl(J2EEModuleCallBack module, Application app) {
        super(module);
        this.appName = module.getParentName();
        if (app == null) {
            return;
        }
        Set webServices = app.getWebServiceDescriptors();
        if (webServices.size() > 0) {
            this.hasWebServices = true;
            Vector<String> endpointList = new Vector<String>();
            Iterator itr = webServices.iterator();
            while (itr.hasNext()) {
                WebService webService = (WebService)itr.next();
                Iterator endpoints = webService.getWebServicesDescriptor().getEndpoints().iterator();
                while (endpoints.hasNext()) {
                    WebServiceEndpoint wse = (WebServiceEndpoint)endpoints.next();
                    endpointList.add(wse.getEndpointAddressUri());
                }
            }
            this.endpointAddresses = new String[endpointList.size()];
            endpointList.copyInto(this.endpointAddresses);
        }
    }

    public String[] getmodules() {
        Set appMods = this.findNames("j2eeType=EJBModule,J2EEServer=" + this.getJ2EEServer() + ",J2EEApplication=" + this.appName);
        appMods.addAll(this.findNames("j2eeType=WebModule,J2EEServer=" + this.getJ2EEServer() + ",J2EEApplication=" + this.appName));
        appMods.addAll(this.findNames("j2eeType=ResourceAdapterModule,J2EEServer=" + this.getJ2EEServer() + ",J2EEApplication=" + this.appName));
        appMods.addAll(this.findNames("j2eeType=AppClientModule,J2EEServer=" + this.getJ2EEServer() + ",J2EEApplication=" + this.appName));
        Iterator it = appMods.iterator();
        String[] mods = new String[appMods.size()];
        int i = 0;
        while (it.hasNext()) {
            mods[i++] = ((ObjectName)it.next()).toString();
        }
        return mods;
    }

    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }

    public String getobjectName() {
        Set s = this.findNames("j2eeType=" + this.getj2eeType() + ",name=" + this.appName + ",J2EEServer=" + this.getJ2EEServer());
        Object[] objs = s.toArray();
        if (objs.length > 0) {
            String name = ((ObjectName)objs[0]).toString();
            return name;
        }
        return null;
    }

    public boolean gethasWebServices() {
        return this.hasWebServices;
    }

    public String[] getendpointAddresses() {
        return this.endpointAddresses;
    }
}

