/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.io.ApplicationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceFactory;
import com.sun.enterprise.loader.ClassLoaderUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public class EJBClassPathUtils {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private static final String MANIFEST_ENTRY = "META-INF" + File.separator + "MANIFEST.MF";
    private static final String WAR_CLASSES_DIR = "WEB-INF" + File.separator + "classes";
    private static final String WAR_LIB_DIR = "WEB-INF" + File.separator + "lib";

    public static String[] getEjbClasspath(String appName, String serverId) {
        AppsManager apps = null;
        try {
            apps = InstanceFactory.createAppsManager(serverId);
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "ejb.config_excp", ce);
        }
        return EJBClassPathUtils.getEjbClasspath(appName, apps);
    }

    public static String[] getEjbClasspath(String appName, AppsManager apps) {
        String[] paths = null;
        List classpath = EJBClassPathUtils.getEjbClasspathList(appName, apps);
        if (classpath.size() > 0) {
            paths = new String[classpath.size()];
            paths = classpath.toArray(paths);
        }
        return paths;
    }

    public static List getEjbClasspathList(String appName, AppsManager apps) {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            String appRoot = apps.getLocation(appName);
            Application application = apps.getRegisteredDescriptor(appName);
            List ejbPath = application == null ? EJBClassPathUtils.getApplicationClassPath(appRoot, appName) : EJBClassPathUtils.getApplicationClassPath(application, appRoot);
            if (ejbPath.size() > 0) {
                classpath.addAll(ejbPath);
            }
            classpath.add(apps.getStubLocation(appName));
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ejb.classpath", e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[EJBClassPathUtils] EJB Class Path for [" + appName + "] is ...\n" + ((Object)classpath).toString());
        }
        return classpath;
    }

    public static String[] getEjbModuleClasspath(String moduleName, EjbModulesManager moduleMgr) {
        String[] paths = null;
        List classpath = EJBClassPathUtils.getEjbModuleClasspathList(moduleName, moduleMgr);
        if (classpath.size() > 0) {
            paths = new String[classpath.size()];
            paths = classpath.toArray(paths);
        }
        return paths;
    }

    public static List getEjbModuleClasspathList(String moduleName, BaseManager moduleMgr) {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            String moduleRoot = moduleMgr.getLocation(moduleName);
            classpath.add(moduleRoot);
            classpath.add(moduleMgr.getStubLocation(moduleName));
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ejb.classpath", e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[EJBClassPathUtils] EJB Class Path for [" + moduleName + "] is ...\n" + ((Object)classpath).toString());
        }
        return classpath;
    }

    public static List getEjbModuleClasspathList(String moduleName, BaseManager moduleMgr, String moduleRoot) {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            classpath.add(moduleRoot);
            classpath.add(moduleMgr.getStubLocation(moduleName));
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ejb.classpath", e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[EJBClassPathUtils] EJB Class Path for [" + moduleName + "] is ...\n" + ((Object)classpath).toString());
        }
        return classpath;
    }

    public static List getAppClientModuleClasspathList(String moduleName, String moduleRoot) throws Exception {
        ArrayList<String> classpath = new ArrayList<String>();
        try {
            if (moduleRoot != null) {
                classpath.add(moduleRoot);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "appclient.classpath", e);
            throw e;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[EJBClassPathUtils] AppClient Class Path for [" + moduleName + "] is ...\n" + ((Object)classpath).toString());
        }
        return classpath;
    }

    public static String[] getEjbModuleClasspath(String moduleName, String serverId) {
        EjbModulesManager moduleMgr = null;
        try {
            moduleMgr = InstanceFactory.createEjbModuleManager(serverId);
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "ejb.config_excp", ce);
        }
        return EJBClassPathUtils.getEjbModuleClasspath(moduleName, moduleMgr);
    }

    public static List getApplicationClassPath(String appRoot, String appName) throws IOException, SAXParseException {
        ArrayList<String> classpath = new ArrayList<String>();
        FileArchive in = new FileArchive();
        in.open(appRoot);
        ApplicationDeploymentDescriptorFile addf = new ApplicationDeploymentDescriptorFile();
        addf.setXMLValidation(false);
        Application app = (Application)addf.read(null, in);
        Iterator modules = app.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)modules.next();
            if (!md.getModuleType().equals(ModuleType.EJB) && !md.getModuleType().equals(ModuleType.RAR)) continue;
            String moduleUri = md.getArchiveUri();
            String moduleRoot = appRoot + File.separator + FileUtils.makeFriendlyFilename(moduleUri);
            classpath.add(moduleRoot);
            Manifest mf = EJBClassPathUtils.getManifest(moduleRoot);
            List manifestClassPath = EJBClassPathUtils.getManifestClassPath(mf, appRoot);
            if (manifestClassPath.size() <= 0) continue;
            classpath.addAll(manifestClassPath);
        }
        return classpath;
    }

    public static List getApplicationClassPath(Application app, String appRoot) {
        ArrayList<String> classpath = new ArrayList<String>();
        Iterator modules = app.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)modules.next();
            String moduleUri = md.getArchiveUri();
            String moduleRoot = appRoot + File.separator + FileUtils.makeFriendlyFilename(moduleUri);
            classpath.add(moduleRoot);
            Manifest mf = md.getManifest();
            List manifestClassPath = EJBClassPathUtils.getManifestClassPath(mf, appRoot);
            if (manifestClassPath.size() <= 0) continue;
            classpath.addAll(manifestClassPath);
        }
        return classpath;
    }

    public static List getAppDeploymentClassPath(Application app, String appRoot, BaseManager apps) throws IOException, SAXParseException {
        ArrayList<String> classpath = new ArrayList<String>();
        String appName = app.getRegistrationName();
        classpath.add(apps.getStubLocation(appName));
        Iterator modules = app.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)modules.next();
            String moduleUri = md.getArchiveUri();
            String moduleRoot = appRoot + File.separator + FileUtils.makeFriendlyFilename(moduleUri);
            if (md.getModuleType().equals(ModuleType.WAR)) {
                List warClassPath = EJBClassPathUtils.getWarClassPath(appRoot, md);
                classpath.addAll(warClassPath);
                continue;
            }
            classpath.add(moduleRoot);
            Manifest mf = EJBClassPathUtils.getManifest(moduleRoot);
            List manifestClassPath = EJBClassPathUtils.getManifestClassPath(mf, appRoot);
            classpath.addAll(manifestClassPath);
        }
        return classpath;
    }

    public static List getWarClassPath(String appRoot, ModuleDescriptor webModuleDesc) throws IOException {
        String moduleUri = webModuleDesc.getArchiveUri();
        String moduleRoot = appRoot + File.separator + FileUtils.makeFriendlyFilename(moduleUri);
        return EJBClassPathUtils.getWarClassPath(moduleRoot, appRoot);
    }

    public static List getWarClassPath(String moduleRoot, String appRoot) throws IOException {
        ArrayList classPath = new ArrayList();
        Manifest mf = EJBClassPathUtils.getManifest(moduleRoot);
        List manifestClassPath = EJBClassPathUtils.getManifestClassPath(mf, appRoot);
        classPath.addAll(manifestClassPath);
        String classesDir = moduleRoot + File.separator + WAR_CLASSES_DIR;
        String libDir = moduleRoot + File.separator + WAR_LIB_DIR;
        List warClassPath = ClassLoaderUtils.getUrlList(new File[]{new File(classesDir)}, new File[]{new File(libDir)});
        classPath.addAll(warClassPath);
        return classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Manifest getManifest(String rootPath) {
        Manifest mf;
        InputStream in;
        block8: {
            in = null;
            mf = null;
            in = new FileInputStream(rootPath + File.separator + MANIFEST_ENTRY);
            if (in == null) break block8;
            mf = new Manifest(in);
        }
        Object var5_3 = null;
        if (in == null) return mf;
        try {
            in.close();
            return mf;
        }
        catch (IOException ioe) {}
        return mf;
        {
            catch (IOException iOException) {
                Object var5_4 = null;
                if (in == null) return mf;
                try {
                    in.close();
                    return mf;
                }
                catch (IOException ioe) {}
                return mf;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static List getManifestClassPath(Manifest manifest, String rootPath) {
        ArrayList<String> classPaths = new ArrayList<String>();
        if (manifest != null) {
            Attributes mainAttributes = manifest.getMainAttributes();
            Iterator<Object> itr = mainAttributes.keySet().iterator();
            while (itr.hasNext()) {
                Attributes.Name next = (Attributes.Name)itr.next();
                if (!next.equals(Attributes.Name.CLASS_PATH)) continue;
                String classpathString = (String)mainAttributes.get(next);
                StringTokenizer st = new StringTokenizer(classpathString, " ");
                while (st.hasMoreTokens()) {
                    String mc = st.nextToken();
                    classPaths.add(rootPath + File.separator + mc);
                }
            }
        }
        return classPaths;
    }
}

