/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.enterprise.loader.JasperAdapter;
import com.sun.enterprise.util.Print;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class EJBClassLoader
extends SecureClassLoader
implements JasperAdapter {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private List urlSet = Collections.synchronizedList(new ArrayList());
    private Map notFoundResources = new HashMap();
    private Map notFoundClasses = new HashMap();
    private boolean doneCalled = false;
    private String doneSnapshot;
    private Set streams = new HashSet();

    public EJBClassLoader() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ClassLoader: " + this + " is getting created.");
        }
    }

    public EJBClassLoader(ClassLoader parent) {
        super(parent);
    }

    public boolean isDone() {
        return this.doneCalled;
    }

    public void done() {
        if (this.doneCalled) {
            return;
        }
        this.doneSnapshot = "EJBClassLoader.done() called ON " + this.toString() + "\n AT " + new Date() + " \n BY :" + Print.printStackTraceToString();
        this.doneCalled = true;
        for (int i = 0; i < this.urlSet.size(); ++i) {
            URLEntry u = (URLEntry)this.urlSet.get(i);
            if (u.zip != null) {
                try {
                    u.zip.reallyClose();
                }
                catch (IOException ioe) {
                    String fmt = _logger.getResourceBundle().getString("loader.ejbclassloader_exc_closing_URLEntry");
                    _logger.log(Level.INFO, MessageFormat.format(fmt, u.source), ioe);
                }
            }
            if (u.table != null) {
                u.table.clear();
                u.table = null;
            }
            u = null;
        }
        this.closeOpenStreams();
        if (this.urlSet != null) {
            this.urlSet.clear();
        }
        if (this.notFoundResources != null) {
            this.notFoundResources.clear();
        }
        if (this.notFoundClasses != null) {
            this.notFoundClasses.clear();
        }
        this.urlSet = null;
        this.notFoundResources = null;
        this.notFoundClasses = null;
    }

    public synchronized void appendURL(File file) throws IOException {
        try {
            this.appendURL(file.toURI().toURL());
        }
        catch (MalformedURLException mue) {
            _logger.log(Level.SEVERE, "loader.ejbclassloader_bad_url_entry", file.toURI());
            _logger.log(Level.SEVERE, "loader.ejbclassloader_malformed_url", mue);
            IOException ioe = new IOException();
            ioe.initCause(mue);
            throw ioe;
        }
    }

    public synchronized void appendURL(URL url) {
        try {
            if (url == null) {
                _logger.log(Level.INFO, "loader.ejbclassloader_bad_url_entry", url);
                return;
            }
            URLEntry entry = new URLEntry(url);
            if (!this.urlSet.contains(entry)) {
                entry.init();
                this.urlSet.add(entry);
                if (entry.isJar) {
                    this.checkManifest(entry.zip, entry.file);
                }
            } else {
                _logger.log(Level.FINE, "[EJB-CL] Ignoring duplicate URL: " + url);
                if (entry.zip != null) {
                    try {
                        entry.zip.reallyClose();
                    }
                    catch (IOException ioe) {
                        String msg = _logger.getResourceBundle().getString("loader.ejbclassloader_exc_closing_dup_URLEntry");
                        _logger.log(Level.INFO, MessageFormat.format(msg, url), ioe);
                    }
                }
            }
            this.clearNotFoundCaches();
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, "loader.ejbclassloader_bad_url_entry", url);
            _logger.log(Level.SEVERE, "loader.ejbclassloader_malformed_url", ioe);
        }
    }

    public synchronized URL[] getURLs() {
        URL[] url = null;
        if (this.urlSet != null) {
            url = new URL[this.urlSet.size()];
            for (int i = 0; i < url.length; ++i) {
                url[i] = ((URLEntry)this.urlSet.get((int)i)).source;
            }
        } else {
            url = new URL[]{};
        }
        return url;
    }

    public String getClasspath() {
        StringBuffer strBuf = null;
        URL[] urls = this.getURLs();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].getProtocol().equals("file")) continue;
                if (strBuf == null) {
                    strBuf = new StringBuffer();
                }
                if (i > 0) {
                    strBuf.append(File.pathSeparator);
                }
                strBuf.append(urls[i].getFile());
            }
        }
        return strBuf != null ? strBuf.toString() : null;
    }

    public synchronized void refresh() throws IOException {
        this.clearNotFoundCaches();
        Iterator i = this.urlSet.iterator();
        while (i.hasNext()) {
            URLEntry entry = (URLEntry)i.next();
            entry.cacheItems();
        }
    }

    private void clearNotFoundCaches() {
        this.notFoundResources.clear();
        this.notFoundClasses.clear();
    }

    private URL findResource0(final URLEntry res, final String name) {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (res.isJar) {
                    try {
                        JarEntry jarEntry = res.zip.getJarEntry(name);
                        if (jarEntry != null) {
                            InternalURLStreamHandler handler = new InternalURLStreamHandler(res, name);
                            URI uri = new URI("jar", res.source + "!/" + name, null);
                            URL ret = new URL(uri.toURL(), "", handler);
                            handler.tieUrl(ret);
                            return ret;
                        }
                    }
                    catch (Throwable e) {
                        _logger.log(Level.FINE, "loader.excep_in_ejbclassloader", e);
                    }
                } else {
                    try {
                        File resourceFile = new File(res.file.getCanonicalPath() + File.separator + name);
                        if (resourceFile.exists()) {
                            return resourceFile.toURL();
                        }
                    }
                    catch (IOException e) {
                        _logger.log(Level.FINE, "loader.excep_in_ejbclassloader", e);
                    }
                }
                return null;
            }
        });
        return (URL)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL findResource(String name) {
        if (this.doneCalled) {
            String fmt = _logger.getResourceBundle().getString("loader.ejbclassloader_find_resource_after_done");
            _logger.log(Level.WARNING, MessageFormat.format(fmt, name, this.toString()), new Throwable());
            return null;
        }
        String nf = (String)this.notFoundResources.get(name);
        if (nf != null && nf.equals(name)) {
            return null;
        }
        int i = 0;
        while (i < this.urlSet.size()) {
            URLEntry u = (URLEntry)this.urlSet.get(i);
            if (!u.hasItem(name)) {
                ++i;
                continue;
            }
            URL url = this.findResource0(u, name);
            if (url != null) {
                return url;
            }
            ++i;
        }
        Map map = this.notFoundResources;
        synchronized (map) {
            this.notFoundResources.put(name, name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkManifest(JarFile jar, File file) throws IOException {
        if (jar == null || file == null) {
            return;
        }
        Manifest man = jar.getManifest();
        if (man == null) {
            return;
        }
        EJBClassLoader eJBClassLoader = this;
        synchronized (eJBClassLoader) {
            String cp = man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (cp == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(cp, " ");
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                File newFile = new File(file.getParentFile(), entry);
                try {
                    this.appendURL(newFile.toURL());
                }
                catch (MalformedURLException ex) {
                    _logger.log(Level.SEVERE, "loader.ejbclassloader_malformed_url", ex);
                }
            }
        }
    }

    private byte[] loadClassData0(final URLEntry res, final String entryName) {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                block10: {
                    try {
                        byte[] byArray;
                        block11: {
                            InputStream classStream = null;
                            if (res.isJar) {
                                ProtectedJarFile zip = res.zip;
                                ZipEntry entry = zip.getEntry(entryName);
                                if (entry != null) {
                                    classStream = zip.getInputStream(entry);
                                    byte[] classData = EJBClassLoader.this.getClassData(classStream);
                                    return classData;
                                }
                                break block10;
                            }
                            File classFile = new File(res.file, entryName.replace('/', File.separatorChar));
                            if (!classFile.exists()) break block10;
                            try {
                                byte[] classData;
                                classStream = new FileInputStream(classFile);
                                byArray = classData = EJBClassLoader.this.getClassData(classStream);
                                Object var6_9 = null;
                                if (classStream == null) break block11;
                            }
                            catch (Throwable throwable) {
                                Object var6_10 = null;
                                if (classStream != null) {
                                    try {
                                        classStream.close();
                                    }
                                    catch (IOException closeIOE) {
                                        _logger.log(Level.INFO, "loader.excep_in_ejbclassloader", closeIOE);
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                classStream.close();
                            }
                            catch (IOException closeIOE) {
                                _logger.log(Level.INFO, "loader.excep_in_ejbclassloader", closeIOE);
                            }
                        }
                        return byArray;
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.INFO, "loader.excep_in_ejbclassloader", ioe);
                    }
                }
                return null;
            }
        });
        return (byte[])result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.doneCalled) {
            String fmt = _logger.getResourceBundle().getString("loader.ejbclassloader_find_class_after_done");
            _logger.log(Level.WARNING, MessageFormat.format(fmt, name, this.toString()), new Throwable());
            throw new ClassNotFoundException(name);
        }
        String nf = (String)this.notFoundClasses.get(name);
        if (nf != null && nf.equals(name)) {
            throw new ClassNotFoundException(name);
        }
        String entryName = name.replace('.', '/') + ".class";
        int i = 0;
        while (i < this.urlSet.size()) {
            URLEntry u = (URLEntry)this.urlSet.get(i);
            if (!u.hasItem(entryName)) {
                ++i;
                continue;
            }
            byte[] result = null;
            result = this.loadClassData0(u, entryName);
            if (result != null) {
                String packageName;
                int lastPackageSep;
                if (PreprocessorUtil.isPreprocessorEnabled()) {
                    result = PreprocessorUtil.processClass(entryName, result);
                }
                if ((lastPackageSep = name.lastIndexOf(46)) != -1 && this.getPackage(packageName = name.substring(0, lastPackageSep)) == null) {
                    try {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                    catch (IllegalArgumentException iae) {
                        _logger.log(Level.FINE, "duplicate package definition attempt for " + packageName, iae);
                    }
                }
                Class<?> clz = this.defineClass(name, result, 0, result.length);
                return clz;
            }
            ++i;
        }
        Map map = this.notFoundClasses;
        synchronized (map) {
            this.notFoundClasses.put(name, name);
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getClassData(InputStream istream) throws IOException {
        BufferedInputStream bstream = new BufferedInputStream(istream);
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        try {
            while ((num = bstream.read(buf)) != -1) {
                bout.write(buf, 0, num);
            }
            Object var7_6 = null;
            if (bstream == null) return bout.toByteArray();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bstream == null) throw throwable;
            try {
                bstream.close();
                throw throwable;
            }
            catch (IOException closeIOE) {
                _logger.log(Level.INFO, "loader.excep_in_ejbclassloader", closeIOE);
            }
            throw throwable;
        }
        try {
            bstream.close();
            return bout.toByteArray();
        }
        catch (IOException closeIOE) {
            _logger.log(Level.INFO, "loader.excep_in_ejbclassloader", closeIOE);
        }
        return bout.toByteArray();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("EJBClassLoader : \n");
        if (this.doneCalled) {
            buffer.append("doneCalled = true\n");
            if (this.doneSnapshot != null) {
                buffer.append("doneSnapshot = " + this.doneSnapshot);
            }
        } else {
            buffer.append("urlSet = " + this.urlSet + "\n");
            buffer.append("doneCalled = false \n");
        }
        buffer.append(" Parent -> " + this.getParent() + "\n");
        return buffer.toString();
    }

    public InputStream getResourceAsStream(String name) {
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null && !(stream instanceof SentinelInputStream)) {
            stream = new SentinelInputStream(stream);
        }
        return stream;
    }

    private Set getStreams() {
        return this.streams;
    }

    private void closeOpenStreams() {
        if (this.streams != null) {
            SentinelInputStream[] toclose = this.streams.toArray(new SentinelInputStream[this.streams.size()]);
            for (int i = 0; i < toclose.length; ++i) {
                try {
                    toclose[i].closeWithWarning();
                    continue;
                }
                catch (IOException ioe) {
                    _logger.log(Level.WARNING, "loader.ejbclassloader_error_closing_stream", ioe);
                }
            }
            this.streams.clear();
            this.streams = null;
        }
    }

    protected class SentinelInputStream
    extends FilterInputStream {
        private boolean closed;
        private Throwable throwable;

        protected SentinelInputStream(InputStream in) {
            super(in);
            this.throwable = new Throwable();
            EJBClassLoader.this.getStreams().add(this);
        }

        protected void finalize() throws Throwable {
            if (!this.closed && this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.report();
            }
            super.finalize();
        }

        private void _close() throws IOException {
            this.closed = true;
            EJBClassLoader.this.getStreams().remove(this);
            super.close();
        }

        public void close() throws IOException {
            this._close();
        }

        private void closeWithWarning() throws IOException {
            this._close();
            this.report();
        }

        private void report() {
            _logger.log(Level.WARNING, "loader.ejbclassloader_finalize_before_close", this.throwable);
        }
    }

    protected static class URLEntry {
        URL source;
        File file;
        ProtectedJarFile zip;
        boolean isJar = false;
        Hashtable table = null;

        URLEntry(URL url) {
            this.source = url;
        }

        void init() throws IOException {
            try {
                this.file = new File(new URI(this.source.toString()));
            }
            catch (URISyntaxException use) {
                this.file = new File(this.source.getFile());
            }
            this.isJar = this.file.isFile();
            if (this.isJar) {
                this.zip = new ProtectedJarFile(this.file);
            }
            this.table = new Hashtable();
            this.cacheItems();
        }

        private void cacheItems() throws IOException {
            if (this.isJar) {
                Enumeration<JarEntry> e = this.zip.entries();
                while (e.hasMoreElements()) {
                    ZipEntry curEntry = e.nextElement();
                    this.table.put(curEntry.getName(), curEntry.getName());
                }
            } else if (this.file.exists()) {
                this.fillTable(this.file, this.table, "");
            }
        }

        private void fillTable(File f, Hashtable t, String parent) throws IOException {
            String localName = parent.equals("") ? "" : parent + "/";
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.processFile(children[i], t, localName);
            }
        }

        private void processFile(File fileToProcess, Hashtable t, String parentLocalName) throws IOException {
            String key = parentLocalName + fileToProcess.getName();
            if (fileToProcess.isFile()) {
                t.put(key, key);
            } else if (fileToProcess.isDirectory()) {
                this.fillTable(fileToProcess, t, key);
            }
        }

        boolean hasItem(String item) {
            File targetFile;
            if (this.table.size() == 0) {
                return true;
            }
            boolean result = false;
            String target = item;
            if (item.startsWith("./")) {
                target = item.substring(2, item.length());
            }
            if (!(result = this.table.containsKey(target)) && !this.isJar && (targetFile = this.privilegedCheckForFile(target)) != null) {
                try {
                    this.processFile(targetFile, this.table, "");
                    result = true;
                }
                catch (IOException ioe) {
                    String fmt = _logger.getResourceBundle().getString("loader.ejbclassloader_error_processing_file");
                    _logger.log(Level.SEVERE, MessageFormat.format(fmt, target, this.file.getAbsolutePath()), ioe);
                    return false;
                }
            }
            return result;
        }

        private File privilegedCheckForFile(String targetPath) {
            try {
                File result = (File)AccessController.doPrivileged(new PrivilegedExceptionAction(this, targetPath){
                    private final /* synthetic */ String val$targetPath;
                    private final /* synthetic */ URLEntry this$0;
                    {
                        this.this$0 = this$0;
                        this.val$targetPath = val$targetPath;
                    }

                    public Object run() throws Exception {
                        File targetFile = new File(this.this$0.file, this.val$targetPath);
                        if (!targetFile.exists()) {
                            targetFile = null;
                        }
                        return targetFile;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                String fmt = _logger.getResourceBundle().getString("loader.ejbclassloader_error_checking_existence");
                _logger.log(Level.SEVERE, MessageFormat.format(fmt, targetPath, this.file.getAbsolutePath()), pae.getCause());
                return null;
            }
        }

        public String toString() {
            return "URLEntry : " + this.source.toString();
        }

        public boolean equals(Object obj) {
            boolean tf = false;
            if (obj instanceof URLEntry && this.source.equals(((URLEntry)obj).source)) {
                tf = true;
            }
            return tf;
        }

        public int hashCode() {
            return this.source.hashCode();
        }
    }

    private static class ProtectedJarFile
    extends JarFile {
        public ProtectedJarFile(File file) throws IOException {
            super(file);
        }

        public void close() {
            _logger.log(Level.WARNING, "loader.ejbclassloader_bad_ProtectedJar_close", new Throwable());
        }

        public void reallyClose() throws IOException {
            super.close();
        }

        protected void finalize() throws IOException {
            this.reallyClose();
        }
    }

    private class InternalURLStreamHandler
    extends URLStreamHandler {
        private URL mURL;
        private URLEntry mRes;
        private String mName;

        public InternalURLStreamHandler(URLEntry res, String name) {
            this.mRes = res;
            this.mName = name;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            if (u != this.mURL) {
                throw new IOException("Cannot open a foreign URL; this.url=" + this.mURL + "; foreign.url=" + u);
            }
            return new InternalJarURLConnection(u, this.mRes, this.mName);
        }

        public void tieUrl(URL url) {
            this.mURL = url;
        }
    }

    private class InternalJarURLConnection
    extends JarURLConnection {
        private URL mURL;
        private URLEntry mRes;
        private String mName;

        public InternalJarURLConnection(URL url, URLEntry res, String name) throws MalformedURLException {
            super(url);
            this.mRes = res;
            this.mName = name;
        }

        public JarFile getJarFile() throws IOException {
            return this.mRes.zip;
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            ZipEntry entry = this.mRes.zip.getEntry(this.mName);
            return new SentinelInputStream(this.mRes.zip.getInputStream(entry));
        }
    }
}

