/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.InstanceDefinition;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.util.ExecException;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerManager {
    public static final String INSTALL_ROOT = System.getProperty("com.sun.aas.installRoot");
    public static final String INSTANCE_CFG_ROOT = System.getProperty("com.sun.aas.instanceRoot");
    public static final String DOC_DIR_NAME = "docroot";
    public static final String ADMINSERVER_ID = "admin-server";
    private static final ServerManager SHARED_INSTANCE = new ServerManager();
    private static Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");

    private ServerManager() {
    }

    public static ServerManager instance() {
        return SHARED_INSTANCE;
    }

    public boolean instanceExists(String instanceID) {
        return instanceID.equals("server");
    }

    public String[] getInstanceNames(boolean countAdmin) {
        return new String[]{"server"};
    }

    public int getNumInstances(boolean countAdmin) {
        return this.getInstanceNames(countAdmin).length;
    }

    public void createServerInstance(InstanceDefinition instance) throws IOException, ConfigException {
        throw new UnsupportedOperationException("createServerInstance - not in PE");
    }

    public void deleteServerInstance(String instanceName) throws ConfigException {
        throw new UnsupportedOperationException("deleteServerInstance - not in PE");
    }

    public void startServerInstance(InstanceDefinition instance) throws ConfigException, RuntimeException {
        this.startServerInstance(instance, null);
    }

    public void startServerInstance(InstanceDefinition instance, String[] passwords) throws ConfigException, RuntimeException {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        String[] startCommand = instance.getStartCommand();
        String[] inputLines = null;
        inputLines = passwords != null ? passwords : new String[]{};
        try {
            sLogger.log(Level.FINE, "general.exec_cmd", startCommand[0]);
            ProcessExecutor executor = new ProcessExecutor(startCommand, inputLines);
            executor.execute();
        }
        catch (ExecException ee) {
            sLogger.log(Level.WARNING, "general.exec_cmd", ee);
            throw new RuntimeException(Localizer.getValue(ExceptionType.SERVER_NO_START));
        }
        catch (Exception e) {
            throw new ConfigException(e.getMessage());
        }
    }

    public void stopServerInstance(InstanceDefinition instance) throws ConfigException {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        String[] stopCommand = instance.getStopCommand();
        try {
            sLogger.log(Level.FINE, "general.exec_cmd", stopCommand[0]);
            ProcessExecutor executor = new ProcessExecutor(stopCommand);
            executor.execute();
        }
        catch (Exception e) {
            throw new ConfigException(e.getMessage());
        }
    }

    public void restartServerInstance(InstanceDefinition instance) throws ConfigException {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        String[] restartCommand = instance.getRestartCommand();
        try {
            sLogger.log(Level.FINE, "general.exec_cmd", restartCommand[0]);
            ProcessExecutor executor = new ProcessExecutor(restartCommand);
            executor.execute();
        }
        catch (Exception e) {
            throw new ConfigException(e.getMessage());
        }
    }

    public String[] getSecurityTokensForInstance(InstanceDefinition instance) throws ConfigException, RuntimeException {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        String[] command = instance.getGetSecurityTokensCommand();
        Object inputLines = null;
        try {
            sLogger.log(Level.FINE, "general.gettokens_cmd", command[0]);
            ProcessExecutor executor = new ProcessExecutor(command);
            return executor.execute(true);
        }
        catch (ExecException ee) {
            throw new RuntimeException(Localizer.getValue(ExceptionType.NO_RECEIVE_TOKENS));
        }
        catch (Exception e) {
            throw new ConfigException(e.getMessage());
        }
    }

    public String getMimeTypesTemplateFilePath() {
        String libDirName = "lib";
        String installDirName = "install";
        String templateDirName = "templates";
        String mimeTemplateFileName = "mime.types.template";
        String[] fileNames = new String[]{INSTALL_ROOT, "lib", "install", "templates", "mime.types.template"};
        return StringUtils.makeFilePath((String[])fileNames, (boolean)false);
    }

    private int getFreePort(int defaultPort) {
        int port = NetUtils.getFreePort();
        if (port == 0) {
            sLogger.log(Level.SEVERE, "general.free_port_failed");
            return defaultPort;
        }
        Integer portInteger = new Integer(port);
        sLogger.log(Level.INFO, "general.free_port", portInteger);
        return port;
    }

    private boolean portTakenByHTTP(int port) {
        boolean portTaken = true;
        String portString = "" + port;
        String[] instances = this.getInstanceNames(true);
        try {
            for (int i = 0; i < instances.length; ++i) {
                String instanceName = instances[i];
                InstanceEnvironment inst = new InstanceEnvironment(instanceName);
                String backURL = inst.getConfigFilePath();
                ConfigContext context = ConfigFactory.createConfigContext(backURL);
                Config rootElement = ServerBeansFactory.getConfigBean(context);
                HttpService httpService = rootElement.getHttpService();
                HttpListener[] httpListeners = httpService.getHttpListener();
                for (int j = 0; j < httpListeners.length; ++j) {
                    String aPort = httpListeners[j].getPort();
                    aPort = aPort.trim();
                    sLogger.log(Level.FINE, "port = " + aPort);
                    if (!aPort.equals(portString)) continue;
                    sLogger.log(Level.WARNING, "general.port_occupied", instanceName);
                    return portTaken;
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "general.port_derivation_failed", e);
        }
        return false;
    }

    private boolean portTakenByORB(int port) {
        boolean portTaken = true;
        String portString = "" + port;
        String[] instances = this.getInstanceNames(true);
        try {
            for (int i = 0; i < instances.length; ++i) {
                String instanceName = instances[i];
                InstanceEnvironment inst = new InstanceEnvironment(instanceName);
                String backURL = inst.getConfigFilePath();
                ConfigContext context = ConfigFactory.createConfigContext(backURL);
                Config rootElement = ServerBeansFactory.getConfigBean(context);
                IiopService iiopService = rootElement.getIiopService();
                IiopListener[] iiopListeners = iiopService.getIiopListener();
                for (int j = 0; j < iiopListeners.length; ++j) {
                    String aPort = iiopListeners[j].getPort();
                    aPort = aPort.trim();
                    sLogger.log(Level.FINE, "port = " + aPort);
                    if (!aPort.equals(portString)) continue;
                    sLogger.log(Level.WARNING, "general.port_occupied", instanceName);
                    return portTaken;
                }
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "general.port_derivation_failed", e);
        }
        return false;
    }

    private boolean portTakenByJMS(int port) {
        boolean portTaken = true;
        String portString = "" + port;
        String[] instances = this.getInstanceNames(true);
        try {
            for (int i = 0; i < instances.length; ++i) {
                String instanceName = instances[i];
                InstanceEnvironment inst = new InstanceEnvironment(instanceName);
                String backURL = inst.getConfigFilePath();
                ConfigContext context = ConfigFactory.createConfigContext(backURL);
                JmsHost jmsHost = ServerBeansFactory.getJmsHostBean(context);
                String aPort = jmsHost.getPort();
                aPort = aPort.trim();
                sLogger.log(Level.FINE, "port = " + aPort);
                if (!aPort.equals(portString)) continue;
                sLogger.log(Level.WARNING, "general.port_occupied", instanceName);
                return portTaken;
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "general.port_derivation_failed", e);
        }
        return false;
    }

    public String getDomainName() {
        File domainRoot = new File(INSTANCE_CFG_ROOT);
        return domainRoot.getName();
    }

    public String getInstanceUser(InstanceEnvironment env) throws IOException {
        return System.getProperty("user.name");
    }
}

