/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.legacy.connection.Connection;
import com.sun.corba.ee.spi.legacy.interceptor.RequestInfoExt;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.ServerConnectionContext;
import com.sun.logging.LogDomains;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ServerConnectionInterceptor
extends LocalObject
implements ServerRequestInterceptor,
Comparable {
    private static Logger _logger = null;
    public static final String baseMsg = "ServerConnectionInterceptor";
    public int order;

    public ServerConnectionInterceptor(int order) {
        this.order = order;
    }

    public String name() {
        return baseMsg;
    }

    public void receive_request_service_contexts(ServerRequestInfo sri) {
        Connection c = ((RequestInfoExt)((Object)sri)).connection();
        SecurityMechanismSelector sms = new SecurityMechanismSelector();
        ServerConnectionContext scc = null;
        if (c != null) {
            Socket s = c.getSocket();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "RECEIVED request on connection: " + c);
                _logger.log(Level.FINE, "Socket =" + s);
            }
            scc = new ServerConnectionContext(s);
        } else {
            scc = new ServerConnectionContext();
        }
        SecurityMechanismSelector.setServerConnectionContext(scc);
    }

    public int compareTo(Object o) {
        int otherOrder = -1;
        if (o instanceof ServerConnectionInterceptor) {
            otherOrder = ((ServerConnectionInterceptor)o).order;
        }
        if (this.order < otherOrder) {
            return -1;
        }
        if (this.order == otherOrder) {
            return 0;
        }
        return 1;
    }

    public void destroy() {
    }

    public void receive_request(ServerRequestInfo sri) {
    }

    public void send_reply(ServerRequestInfo sri) {
        this.checkTransaction(sri);
    }

    public void send_exception(ServerRequestInfo sri) {
        this.checkTransaction(sri);
    }

    public void send_other(ServerRequestInfo sri) {
        this.checkTransaction(sri);
    }

    private void checkTransaction(ServerRequestInfo sri) {
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        if (tm != null) {
            tm.checkTransactionImport();
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
    }
}

