/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.extension.CopyObjectPolicy;
import com.sun.corba.ee.spi.extension.RequestPartitioningPolicy;
import com.sun.corba.ee.spi.extension.ServantCachingPolicy;
import com.sun.corba.ee.spi.extension.ZeroPortPolicy;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.ejb.Container;
import com.sun.enterprise.RemoteReferenceFactory;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.iiop.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.CSIv2Policy;
import com.sun.enterprise.iiop.OTSPolicy;
import com.sun.enterprise.iiop.POAProtocolMgr;
import com.sun.enterprise.util.S1ASThreadPoolManager;
import com.sun.enterprise.util.Utility;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.NoSuchObjectLocalException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.Delegate;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public final class POARemoteReferenceFactory
extends LocalObject
implements RemoteReferenceFactory,
ServantLocator {
    static final int PASS_BY_VALUE_ID = 0;
    static final int PASS_BY_REFERENCE_ID = 1;
    static final int OTS_POLICY_TYPE = 1398079611;
    static final int CSIv2_POLICY_TYPE = 1398079612;
    static final int REQUEST_DISPATCH_POLICY_TYPE = 1398079613;
    private static final boolean debug = false;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.corba");
    private static final int GET_TIE_EXCEPTION_CODE = 9999;
    private Container container;
    private EjbDescriptor ejbDescriptor;
    private org.omg.CORBA.ORB orb;
    private POAProtocolMgr protocolMgr;
    private PresentationManager presentationMgr;
    private POA poa;
    private String ejbObjectRepositoryId;
    private PresentationManager.StubFactory ejbObjectStubFactory;
    private String ejbHomeRepositoryId;
    private PresentationManager.StubFactory ejbHomeStubFactory;
    private Method flushClassMethod = null;
    static final int EJBID_OFFSET = 0;
    private static final int INSTANCEKEYLEN_OFFSET = 8;
    private static final int INSTANCEKEY_OFFSET = 12;

    POARemoteReferenceFactory(Container container, POAProtocolMgr protocolMgr, org.omg.CORBA.ORB orb) {
        this.protocolMgr = protocolMgr;
        this.orb = orb;
        ORB cfr_ignored_0 = (ORB)((java.lang.Object)orb);
        this.presentationMgr = ORB.getPresentationManager();
        this.container = container;
        this.ejbDescriptor = container.getEjbDescriptor();
        ClassLoader loader = container.getClassLoader();
        try {
            this.poa = this.createPOA();
            this.poa.set_servant_manager((ServantManager)this);
            this.poa.the_POAManager().activate();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.flushClassMethod = this.presentationMgr.getClass().getMethod("flushClass", Class.class);
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
    }

    private String getRepositoryId(Class c) throws Exception {
        PresentationManager.ClassData cData = this.presentationMgr.getClassData(c);
        String[] typeIds = cData.getTypeIds();
        return typeIds[0];
    }

    public void setRepositoryIds(Class homeIntf, Class remoteIntf) {
        ClassLoader appClassLoader = this.container.getClassLoader();
        ORB cfr_ignored_0 = (ORB)((java.lang.Object)this.orb);
        PresentationManager.StubFactoryFactory sff = ORB.getStubFactoryFactory();
        this.ejbHomeStubFactory = sff.createStubFactory(homeIntf.getName(), false, "", null, appClassLoader);
        String[] ejbHomeTypeIds = this.ejbHomeStubFactory.getTypeIds();
        this.ejbHomeRepositoryId = ejbHomeTypeIds[0];
        this.ejbObjectStubFactory = sff.createStubFactory(remoteIntf.getName(), false, "", null, appClassLoader);
        String[] ejbObjectTypeIds = this.ejbObjectStubFactory.getTypeIds();
        this.ejbObjectRepositoryId = ejbObjectTypeIds[0];
    }

    public void cleanupClass(Class clazz) {
        if (this.flushClassMethod != null) {
            try {
                this.flushClassMethod.invoke((java.lang.Object)this.presentationMgr, clazz);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "cleanupClass error", e);
            }
        }
    }

    private POA createPOA() throws Exception {
        Set iorDescSet;
        CSIV2TaggedComponentInfo ctc;
        POA rootPOA = (POA)this.orb.resolve_initial_references("RootPOA");
        ArrayList<java.lang.Object> policies = new ArrayList<java.lang.Object>();
        policies.add(rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT));
        policies.add(rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER));
        policies.add(rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN));
        policies.add((java.lang.Object)ServantCachingPolicy.getPolicy());
        policies.add((java.lang.Object)new OTSPolicy());
        policies.add((java.lang.Object)new CSIv2Policy(this.ejbDescriptor));
        IASEjbExtraDescriptors extraDesc = this.ejbDescriptor.getIASEjbExtraDescriptors();
        String threadPoolName = extraDesc.getUseThreadPoolId();
        int threadPoolNumericID = 0;
        boolean usePassByReference = extraDesc.getPassByReference();
        if (usePassByReference) {
            policies.add((java.lang.Object)new CopyObjectPolicy(1));
        }
        if (threadPoolName != null) {
            ThreadPoolManager threadPoolManager = S1ASThreadPoolManager.getThreadPoolManager();
            try {
                threadPoolNumericID = threadPoolManager.getThreadPoolNumericId(threadPoolName);
                policies.add((java.lang.Object)new RequestPartitioningPolicy(threadPoolNumericID));
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Not using threadpool-request-partitioning...", ex);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            String jndiName = this.ejbDescriptor.getJndiName();
            logger.log(Level.FINE, "Using Thread-Pool: [" + threadPoolName + " ==> " + threadPoolNumericID + "] for jndi name: " + jndiName);
            logger.log(Level.FINE, "Pass by reference: [" + usePassByReference + "] for jndi name: " + usePassByReference);
        }
        if ((ctc = new CSIV2TaggedComponentInfo(this.orb)).allMechanismsRequireSSL(iorDescSet = this.ejbDescriptor.getIORConfigurationDescriptors())) {
            policies.add((java.lang.Object)ZeroPortPolicy.getPolicy());
        }
        Policy[] policy = policies.toArray(new Policy[0]);
        String poaName = Long.toString(this.ejbDescriptor.getUniqueId());
        POA poa = rootPOA.create_POA(poaName, null, policy);
        return poa;
    }

    public EJBObject createRemoteReference(byte[] instanceKey) {
        return (EJBObject)this.createRef(instanceKey, false);
    }

    public EJBHome createHomeReference(byte[] homeKey) {
        return (EJBHome)this.createRef(homeKey, true);
    }

    private Remote createRef(byte[] instanceKey, boolean home) {
        PresentationManager.StubFactory stubFactory;
        String repositoryId;
        if (home) {
            repositoryId = this.ejbHomeRepositoryId;
            stubFactory = this.ejbHomeStubFactory;
        } else {
            repositoryId = this.ejbObjectRepositoryId;
            stubFactory = this.ejbObjectStubFactory;
        }
        try {
            Object ref = this._createRef(instanceKey, repositoryId);
            Object stub = stubFactory.makeStub();
            Delegate delegate = StubAdapter.getDelegate(ref);
            StubAdapter.setDelegate(stub, delegate);
            return (Remote)stub;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "iiop.createreference_exception", e.toString());
            throw new RuntimeException("Unable to create reference ", e);
        }
    }

    private Object _createRef(byte[] instanceKey, String repositoryId) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("\t\tIn POARemoteReferenceFactory.createRef, repositoryId = " + repositoryId);
        }
        byte[] ejbKey = this.createEJBKey(this.ejbDescriptor.getUniqueId(), instanceKey);
        Object obj = this.poa.create_reference_with_id(ejbKey, repositoryId);
        return obj;
    }

    private byte[] createEJBKey(long ejbId, byte[] instanceKey) {
        byte[] ejbkey = new byte[12 + instanceKey.length];
        Utility.longToBytes(ejbId, ejbkey, 0);
        Utility.intToBytes(instanceKey.length, ejbkey, 8);
        System.arraycopy(instanceKey, 0, ejbkey, 12, instanceKey.length);
        return ejbkey;
    }

    public void destroyReference(Remote remoteRef, Remote remoteObj) {
        try {
            Util.unexportObject(remoteObj);
        }
        catch (RuntimeException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Servant preinvoke(byte[] ejbKey, POA adapter, String operation, CookieHolder cookieHolder) throws ForwardRequest {
        int keyLen = Utility.bytesToInt(ejbKey, 8);
        byte[] instanceKey = new byte[keyLen];
        System.arraycopy(ejbKey, 12, instanceKey, 0, keyLen);
        Servant servant = null;
        try {
            while (servant == null) {
                Remote targetObj = this.container.getTargetObject(instanceKey);
                if (targetObj == null) continue;
                Tie tie = this.presentationMgr.getTie();
                tie.setTarget(targetObj);
                servant = (Servant)tie;
            }
        }
        catch (NoSuchObjectLocalException e) {
            logger.log(Level.SEVERE, "iiop.gettie_exception", e);
            throw new OBJECT_NOT_EXIST(9999, CompletionStatus.COMPLETED_NO);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "iiop.runtime_exception", e);
            throw e;
        }
        return servant;
    }

    public void postinvoke(byte[] ejbKey, POA adapter, String operation, java.lang.Object cookie, Servant servant) {
        Remote target = null;
        if (servant != null) {
            target = ((Tie)servant).getTarget();
        }
        this.container.releaseTargetObject(target);
    }

    public void destroy() {
        try {
            this.poa.destroy(false, false);
            this.poa = null;
            this.container = null;
            this.ejbDescriptor = null;
            this.orb = null;
            this.protocolMgr = null;
        }
        catch (Throwable th) {
            logger.log(Level.SEVERE, "Exception during POARemoteRefFactory::destroy()", th);
        }
    }

    public boolean hasSameContainerID(Object obj) throws Exception {
        boolean result = false;
        try {
            IOR ior = IORFactories.getIOR(obj);
            Iterator iter = ior.iterator();
            byte[] oid = null;
            if (iter.hasNext()) {
                TaggedProfile profile = (TaggedProfile)iter.next();
                ObjectKey objKey = profile.getObjectKey();
                oid = objKey.getId().getId();
            }
            if (oid != null && oid.length > 12) {
                long cid = Utility.bytesToLong(oid, 0);
                int keyLen = Utility.bytesToInt(oid, 8);
                if (oid.length == keyLen + 12) {
                    boolean bl = result = cid == this.ejbDescriptor.getUniqueId();
                }
                if (logger.isLoggable(Level.FINE)) {
                    StringBuffer sbuf = new StringBuffer();
                    sbuf.append("hasSameContainerID() result: ").append(result).append("; because ==> oid.length: ").append(oid.length).append("; instance-key-length: ").append(keyLen).append("; expected oid.length: ").append(keyLen).append("+").append(12).append("; myContainrID: ").append(this.ejbDescriptor.getUniqueId()).append("; obj.containerID: ").append(cid);
                    logger.log(Level.FINE, sbuf.toString());
                }
            } else if (logger.isLoggable(Level.FINE)) {
                if (oid == null) {
                    logger.log(Level.FINE, "hasSameContainerID() failed because oid=null");
                } else {
                    logger.log(Level.FINE, "hasSameContainerID() failed because oid.length= " + oid.length + "; but INSTANCE_KEY_OFFSET= " + 12);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Exception while checking for same containerID", ex);
            throw ex;
        }
        return result;
    }
}

