/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import com.sun.corba.ee.spi.monitoring.MonitoringFactories;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.OrbConnectionManagerStats;
import com.sun.enterprise.admin.monitor.stats.ThreadPoolStats;
import com.sun.enterprise.iiop.OrbConnectionManagerStatsImpl;
import com.sun.enterprise.iiop.ThreadPoolStatsImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;

public class ORBMonitoring {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    ORB orb;
    private MonitoringRegistry registry;
    private MonitoredObject root;

    public ORBMonitoring(ORB orb) {
        this.orb = orb;
        this.registry = ApplicationServer.getServerContext().getMonitoringRegistry();
        this.registerOrbStatistics();
    }

    public void registerOrbStatistics() {
        this.root = ((com.sun.corba.ee.spi.orb.ORB)((Object)this.orb)).getMonitoringManager().getRootMonitoredObject();
        this.registerThreadPoolStats();
        this.registerORBConnectionStats();
    }

    /*
     * WARNING - void declaration
     */
    private void registerThreadPoolStats() {
        void var1_6;
        try {
            MonitoredObject root = MonitoringFactories.getMonitoringManagerFactory().createMonitoringManager("orb", null).getRootMonitoredObject();
            MonitoredObject rootThreadPoolNode = root.getChild("threadpool");
            Iterator threadPoolsIterator = rootThreadPoolNode.getChildren().iterator();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Unexpected exception caught when accessing ThreadPool Stats:", ex);
            return;
        }
        while (var1_6.hasNext()) {
            MonitoredObject threadPool = (MonitoredObject)var1_6.next();
            try {
                ThreadPoolStatsImpl threadPoolStats = new ThreadPoolStatsImpl(threadPool);
                this.registry.registerThreadPoolStats((ThreadPoolStats)threadPoolStats, "orb.threadpool." + threadPool.getName(), null);
            }
            catch (MonitoringRegistrationException mex) {
                _logger.log(Level.WARNING, "Unable to register ThreadPoolStats due to following exception ", mex);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "Unexpected exception caught when registring ThreadPoolStats", ex);
            }
        }
    }

    private void registerORBConnectionStats() {
        try {
            OrbConnectionManagerStatsImpl connectionManagerStats;
            MonitoredObject rootConnectionNode = this.root.getChild("Connections");
            MonitoredObject rootOutboundConnections = rootConnectionNode.getChild("Outbound");
            MonitoredObject rootInboundConnections = rootConnectionNode.getChild("Inbound");
            if (rootOutboundConnections != null) {
                Iterator outboundConnectionListIterator = rootOutboundConnections.getChildren().iterator();
                while (outboundConnectionListIterator.hasNext()) {
                    MonitoredObject outboundConnection = (MonitoredObject)outboundConnectionListIterator.next();
                    try {
                        connectionManagerStats = new OrbConnectionManagerStatsImpl(outboundConnection);
                        this.registry.registerOrbConnectionManagerStats((OrbConnectionManagerStats)connectionManagerStats, "orb.Connections.Outbound." + outboundConnection.getName(), null);
                    }
                    catch (MonitoringRegistrationException mex) {
                        _logger.log(Level.WARNING, "Unable to register Outbound ORB Connections - ", mex);
                    }
                    catch (Exception ex) {
                        _logger.log(Level.WARNING, "Unexpected exception caught when registering Outbound ORB Connections", ex);
                    }
                }
            }
            if (rootInboundConnections != null) {
                Iterator inboundConnectionListIterator = rootInboundConnections.getChildren().iterator();
                while (inboundConnectionListIterator.hasNext()) {
                    MonitoredObject inboundConnection = (MonitoredObject)inboundConnectionListIterator.next();
                    try {
                        connectionManagerStats = new OrbConnectionManagerStatsImpl(inboundConnection);
                        this.registry.registerOrbConnectionManagerStats((OrbConnectionManagerStats)connectionManagerStats, "orb.Connections.Inbound." + inboundConnection.getName(), null);
                    }
                    catch (MonitoringRegistrationException mex) {
                        _logger.log(Level.WARNING, "Unable to register Inbound ORB Connections - ", mex);
                    }
                    catch (Exception ex) {
                        _logger.log(Level.WARNING, "Unexpected exception caught when registering Inbound ORB Connections", ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Unexpected exception caught when accessing ORB Connection Stats:", ex);
            return;
        }
    }
}

