/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.ejb.Container;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class UserTransactionImpl
implements UserTransaction,
Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    private static StringManager sm = StringManager.getManager(UserTransactionImpl.class);
    private static final boolean debug = false;
    private transient J2EETransactionManager transactionManager;
    private transient InvocationManager invocationManager;
    private transient boolean initialized;
    private transient UserTransaction userTx;
    private int transactionTimeout;
    private boolean checkEjbAccess;

    public UserTransactionImpl() {
        this(true);
    }

    public UserTransactionImpl(boolean doEjbAccessChecks) {
        this.init();
        this.checkEjbAccess = doEjbAccessChecks;
    }

    private void init() {
        this.initialized = true;
        Switch theSwitch = Switch.getSwitch();
        this.transactionManager = theSwitch.getTransactionManager();
        this.invocationManager = theSwitch.getInvocationManager();
        if (this.transactionManager == null) {
            this.userTx = new com.sun.jts.jta.UserTransactionImpl();
        }
    }

    private void checkUserTransactionMethodAccess(ComponentInvocation inv) throws IllegalStateException, SystemException {
        if (inv.getInvocationType() == 1 && this.checkEjbAccess) {
            Container ejbContainer = (Container)inv.container;
            if (!ejbContainer.userTransactionMethodsAllowed(inv)) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.operation_not_allowed"));
            }
        } else if (inv.getInvocationType() == 2) {
            throw new SystemException(sm.getString("enterprise_distributedtx.usertransaction_not_supported"));
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.begin();
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            throw new InvocationException();
        }
        this.checkUserTransactionMethodAccess(inv);
        if (this.transactionTimeout > 0) {
            this.transactionManager.begin(this.transactionTimeout);
        } else {
            this.transactionManager.begin();
        }
        try {
            if (inv.getInvocationType() == 1) {
                ((Container)inv.container).doAfterBegin(inv);
            }
            inv.setTransaction(this.transactionManager.getTransaction());
            this.transactionManager.enlistComponentResources();
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_begin", ex);
            throw new SystemException();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.commit();
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            throw new InvocationException();
        }
        this.checkUserTransactionMethodAccess(inv);
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.commit();
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_commit", ex);
            throw new SystemException();
        }
        finally {
            inv.setTransaction(null);
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.rollback();
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            throw new InvocationException();
        }
        this.checkUserTransactionMethodAccess(inv);
        try {
            this.transactionManager.delistComponentResources(false);
            this.transactionManager.rollback();
        }
        catch (RemoteException ex) {
            _logger.log(Level.SEVERE, "enterprise_distributedtx.excep_in_utx_rollback", ex);
            throw new SystemException();
        }
        finally {
            inv.setTransaction(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setRollbackOnly();
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            throw new InvocationException();
        }
        this.checkUserTransactionMethodAccess(inv);
        this.transactionManager.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            return this.userTx.getStatus();
        }
        return this.transactionManager.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (!this.initialized) {
            this.init();
        }
        if (this.userTx != null) {
            this.userTx.setTransactionTimeout(seconds);
            return;
        }
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        if (inv == null) {
            throw new InvocationException();
        }
        this.checkUserTransactionMethodAccess(inv);
        if (seconds < 0) {
            seconds = 0;
        }
        this.transactionTimeout = seconds;
    }
}

