/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.RWLock;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;

public final class J2EETransactionManagerOpt
extends J2EETransactionManagerImpl {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    private static StringManager sm = StringManager.getManager(J2EETransactionManagerOpt.class);
    private ThreadLocal transactions = new ThreadLocal();
    private ThreadLocal localCallCounter = new ThreadLocal();
    private Hashtable globalTransactions = new Hashtable();
    private static RWLock freezeLock = new RWLock();

    public void clearThreadTx() {
        this.transactions.set(null);
    }

    public boolean enlistResource(Transaction tran, ResourceHandle h) throws RollbackException, IllegalStateException, SystemException {
        if (!h.isTransactional()) {
            return true;
        }
        if (!(tran instanceof J2EETransaction)) {
            return super.enlistResource(tran, h);
        }
        J2EETransaction tx = (J2EETransaction)tran;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "\n\nIn J2EETransactionManagerOpt.enlistResource, h=" + h + " h.xares=" + h.getXAResource() + " h.alloc=" + h.getResourceAllocator() + " tx=" + tx);
        }
        if (tx.getNonXAResource() != null && (!this.useLAO || this.useLAO && !h.supportsXA())) {
            boolean isSameRM = false;
            try {
                isSameRM = h.getXAResource().isSameRM(tx.getNonXAResource().getXAResource());
            }
            catch (XAException xex) {
                throw new SystemException(sm.getString("enterprise_distributedtx.samerm_excep", xex));
            }
            catch (Exception ex) {
                throw new SystemException(sm.getString("enterprise_distributedtx.samerm_excep", ex));
            }
            if (!isSameRM) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.already_has_nonxa"));
            }
        }
        if (h.supportsXA()) {
            if (tx.isLocalTx()) {
                this.startJTSTx(tx);
                if (this.useLAO && tx.getNonXAResource() != null && tx.getLAOResource() == null) {
                    tx.setLAOResource(tx.getNonXAResource());
                    super.enlistLAOResource(tx, tx.getNonXAResource());
                }
            }
            return super.enlistResource(tx, h);
        }
        if (tx.isImportedTransaction()) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.nonxa_usein_jts"));
        }
        if (tx.getNonXAResource() == null) {
            tx.setNonXAResource(h);
        }
        if (tx.isLocalTx()) {
            try {
                h.getXAResource().start(tx.getLocalXid(), 0);
            }
            catch (XAException ex) {
                throw new RuntimeException(sm.getString("enterprise_distributedtx.xaresource_start_excep"), ex);
            }
            this.poolmgr.resourceEnlisted(tx, h);
            return true;
        }
        if (this.useLAO) {
            return super.enlistResource(tx, h);
        }
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.nonxa_usein_jts"));
    }

    void startJTSTx(J2EETransaction tx) throws RollbackException, IllegalStateException, SystemException {
        try {
            if (tx.isAssociatedTimeout()) {
                int timeout = tx.cancelTimerTask();
                int newtimeout = (int)((System.currentTimeMillis() - tx.getStartTime()) / 1000L);
                newtimeout = timeout - newtimeout;
                super.begin(newtimeout);
            } else {
                super.begin();
            }
            if (tx != null && this.monitoringEnabled && this.activeTransactions.remove(tx)) {
                --this.m_transInFlight;
            }
        }
        catch (NotSupportedException ex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.lazy_transaction_notstarted"), ex);
        }
        Transaction jtsTx = super.getTransaction();
        tx.setJTSTx(jtsTx);
        jtsTx.registerSynchronization((Synchronization)new JTSSynchronization(jtsTx, this));
        this.globalTransactions.put(jtsTx, tx);
    }

    public boolean delistResource(Transaction tran, ResourceHandle h, int flag) throws IllegalStateException, SystemException {
        if (!h.isTransactional()) {
            return true;
        }
        if (!(tran instanceof J2EETransaction)) {
            return super.delistResource(tran, h, flag);
        }
        J2EETransaction tx = (J2EETransaction)tran;
        if (tx.isLocalTx()) {
            try {
                h.getXAResource().end(tx.getLocalXid(), flag);
            }
            catch (XAException ex) {
                throw new RuntimeException(sm.getString("enterprise_distributedtx.xaresource_end_excep", ex));
            }
            return true;
        }
        return super.delistResource(tx, h, flag);
    }

    public void checkTransactionImport() {
        int[] count = (int[])this.localCallCounter.get();
        if (count != null && count[0] > 0) {
            count[0] = count[0] - 1;
            return;
        }
        this.clearThreadTx();
    }

    public void checkTransactionExport(boolean isLocal) {
        if (isLocal) {
            int[] count = (int[])this.localCallCounter.get();
            if (count == null) {
                count = new int[1];
                this.localCallCounter.set(count);
            }
            count[0] = count[0] + 1;
            return;
        }
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx == null) {
            return;
        }
        if (!tx.isLocalTx()) {
            return;
        }
        if (tx.getNonXAResource() != null) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.cannot_export_transaction_having_nonxa"));
        }
        try {
            this.startJTSTx(tx);
        }
        catch (RollbackException rlex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.unable_tostart_JTSTransaction"), rlex);
        }
        catch (IllegalStateException isex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.unable_tostart_JTSTransaction"), isex);
        }
        catch (SystemException ex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.unable_tostart_JTSTransaction"), ex);
        }
        catch (Exception excep) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.unable_tostart_JTSTransaction"), excep);
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(this.transactionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(int timeout) throws NotSupportedException, SystemException {
        if (this.transactions.get() != null) {
            throw new NotSupportedException(sm.getString("enterprise_distributedtx.notsupported_nested_transaction"));
        }
        if (super.getStatus() != 6) {
            throw new NotSupportedException(sm.getString("enterprise_distributedtx.notsupported_nested_transaction"));
        }
        boolean acquiredlock = false;
        if (this.monitoringEnabled) {
            freezeLock.acquireReadLock();
            acquiredlock = true;
        }
        try {
            J2EETransaction tx = null;
            tx = timeout > 0 ? new J2EETransaction(timeout) : new J2EETransaction();
            this.transactions.set(tx);
            if (this.monitoringEnabled) {
                this.activeTransactions.addElement(tx);
                ++this.m_transInFlight;
            }
        }
        finally {
            if (acquiredlock) {
                freezeLock.releaseReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        block18: {
            try {
                J2EETransaction tx = (J2EETransaction)this.transactions.get();
                if (tx != null && tx.isLocalTx()) {
                    J2EETransaction obj = null;
                    boolean acquiredlock = false;
                    if (this.monitoringEnabled) {
                        obj = tx;
                    }
                    try {
                        if (this.monitoringEnabled) {
                            freezeLock.acquireReadLock();
                            acquiredlock = true;
                        }
                        tx.commit();
                        if (this.monitoringEnabled) {
                            this.monitorTxCompleted(obj, true);
                        }
                        break block18;
                    }
                    catch (RollbackException e) {
                        if (this.monitoringEnabled) {
                            this.monitorTxCompleted(obj, false);
                        }
                        throw e;
                    }
                    catch (HeuristicRollbackException e) {
                        if (this.monitoringEnabled) {
                            this.monitorTxCompleted(obj, false);
                        }
                        throw e;
                    }
                    catch (HeuristicMixedException e) {
                        if (this.monitoringEnabled) {
                            this.monitorTxCompleted(obj, true);
                        }
                        throw e;
                    }
                    finally {
                        if (acquiredlock) {
                            freezeLock.releaseReadLock();
                        }
                    }
                }
                super.commit();
            }
            finally {
                this.transactions.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        boolean acquiredlock = false;
        try {
            J2EETransaction tx = (J2EETransaction)this.transactions.get();
            if (tx != null && tx.isLocalTx()) {
                J2EETransaction obj = null;
                if (this.monitoringEnabled) {
                    obj = tx;
                }
                if (this.monitoringEnabled) {
                    freezeLock.acquireReadLock();
                    acquiredlock = true;
                }
                tx.rollback();
                if (this.monitoringEnabled) {
                    this.monitorTxCompleted(obj, false);
                }
            } else {
                super.rollback();
            }
            Object var5_4 = null;
            this.transactions.set(null);
            if (acquiredlock) {
                freezeLock.releaseReadLock();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.transactions.set(null);
            if (acquiredlock) {
                freezeLock.releaseReadLock();
            }
            throw throwable;
        }
    }

    public int getStatus() throws SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null && tx.isLocalTx()) {
            return tx.getStatus();
        }
        return super.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null) {
            return tx;
        }
        Transaction jtsTx = super.getTransaction();
        if (jtsTx == null) {
            return null;
        }
        tx = (J2EETransaction)this.globalTransactions.get(jtsTx);
        if (tx == null) {
            tx = new J2EETransaction(jtsTx);
            tx.setImportedTransaction();
            try {
                jtsTx.registerSynchronization((Synchronization)new JTSSynchronization(jtsTx, this));
            }
            catch (RollbackException rlex) {
                throw new SystemException(rlex.toString());
            }
            catch (IllegalStateException isex) {
                throw new SystemException(isex.toString());
            }
            catch (Exception ex) {
                throw new SystemException(ex.toString());
            }
            this.globalTransactions.put(jtsTx, tx);
        }
        this.transactions.set(tx);
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null && tx.isLocalTx()) {
            boolean acquiredlock = false;
            if (this.monitoringEnabled) {
                freezeLock.acquireReadLock();
                acquiredlock = true;
            }
            try {
                tx.setRollbackOnly();
            }
            finally {
                if (acquiredlock) {
                    freezeLock.releaseReadLock();
                }
            }
        } else {
            super.setRollbackOnly();
        }
    }

    public Transaction suspend() throws SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null) {
            if (!tx.isLocalTx()) {
                super.suspend();
            }
            this.transactions.set(null);
            return tx;
        }
        return super.suspend();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_exist_on_currentThread"));
        }
        if (tobj instanceof J2EETransaction) {
            J2EETransaction j2eeTx = (J2EETransaction)tobj;
            if (!j2eeTx.isLocalTx()) {
                super.resume(j2eeTx.getJTSTx());
            }
            this.transactions.set(tobj);
        } else {
            super.resume(tobj);
        }
    }

    public boolean isTimedOut() {
        J2EETransaction tx = (J2EETransaction)this.transactions.get();
        if (tx != null) {
            return tx.isTimedout();
        }
        return false;
    }

    public synchronized void freeze() {
        super.freeze();
        if (freezeLock.isWriteLocked()) {
            return;
        }
        freezeLock.acquireWriteLock();
    }

    public synchronized void unfreeze() {
        super.unfreeze();
        if (freezeLock.isWriteLocked()) {
            freezeLock.releaseWriteLock();
        }
    }

    private class JTSSynchronization
    implements Synchronization {
        private Transaction jtsTx;
        private J2EETransactionManagerOpt j2eeTM;

        JTSSynchronization(Transaction jtsTx, J2EETransactionManagerOpt j2eeTM) {
            this.jtsTx = jtsTx;
            this.j2eeTM = j2eeTM;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.j2eeTM.globalTransactions.remove(this.jtsTx);
        }
    }
}

