/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import java.util.Iterator;

public class TracerVisitor
extends DefaultDOLVisitor {
    public void accept(Application application) {
        DOLUtils.getDefaultLogger().info("Application");
        DOLUtils.getDefaultLogger().info("name " + application.getName());
        DOLUtils.getDefaultLogger().info("smallIcon " + application.getSmallIconUri());
    }

    public void accept(EjbBundleDescriptor bundleDescriptor) {
        DOLUtils.getDefaultLogger().info("Ejb Bundle " + bundleDescriptor.getName());
    }

    public void accept(EjbDescriptor ejb) {
        DOLUtils.getDefaultLogger().info("==================");
        DOLUtils.getDefaultLogger().info(ejb.getType() + " Bean " + ejb.getName());
        DOLUtils.getDefaultLogger().info("\thomeClassName " + ejb.getHomeClassName());
        DOLUtils.getDefaultLogger().info("\tremoteClassName " + ejb.getRemoteClassName());
        DOLUtils.getDefaultLogger().info("\tlocalhomeClassName " + ejb.getLocalHomeClassName());
        DOLUtils.getDefaultLogger().info("\tlocalClassName " + ejb.getLocalClassName());
        DOLUtils.getDefaultLogger().info("\tjndiName " + ejb.getJndiName());
        DOLUtils.getDefaultLogger().info("\tejbClassName " + ejb.getEjbClassName());
        DOLUtils.getDefaultLogger().info("\ttransactionType " + ejb.getTransactionType());
        if (!ejb.getUsesCallerIdentity()) {
            DOLUtils.getDefaultLogger().info("\trun-as role " + ejb.getRunAsIdentity());
        } else {
            DOLUtils.getDefaultLogger().info("\tuse-caller-identity " + ejb.getUsesCallerIdentity());
        }
    }

    public void accept(EjbReference ejbRef) {
        DOLUtils.getDefaultLogger().info(ejbRef.toString());
    }

    public void accept(MessageDestinationReferencer referencer) {
        DOLUtils.getDefaultLogger().info(referencer.getMessageDestinationLinkName());
    }

    public void accept(WebService webService) {
        DOLUtils.getDefaultLogger().info(webService.getWebServiceName());
    }

    public void accept(ServiceReferenceDescriptor serviceRef) {
        DOLUtils.getDefaultLogger().info(serviceRef.getName());
    }

    public void accept(MethodPermission pm, Iterator methods) {
        DOLUtils.getDefaultLogger().info("For method permission : " + pm.toString());
        while (methods.hasNext()) {
            DOLUtils.getDefaultLogger().info("\t" + ((MethodDescriptor)methods.next()).prettyPrint());
        }
    }

    public void accept(RoleReference roleRef) {
        DOLUtils.getDefaultLogger().info("Security Role Reference : " + roleRef.getName() + " link " + roleRef.getValue());
    }

    public void accept(MethodDescriptor method, ContainerTransaction ct) {
        DOLUtils.getDefaultLogger().info(ct.getTransactionAttribute() + " Container Transaction for method " + method.prettyPrint());
    }

    public void accept(EnvironmentProperty envEntry) {
        DOLUtils.getDefaultLogger().info(envEntry.toString());
    }

    public void accept(FieldDescriptor fd) {
        DOLUtils.getDefaultLogger().info("CMP Field " + fd);
    }

    public void accept(MethodDescriptor method, QueryDescriptor qd) {
        DOLUtils.getDefaultLogger().info(qd.toString());
    }

    public void accept(RelationshipDescriptor descriptor) {
        DOLUtils.getDefaultLogger().info("============ Relationships ===========");
        DOLUtils.getDefaultLogger().info("From EJB " + descriptor.getSource().getName() + " cmr field : " + descriptor.getSource().getCMRField() + "(" + descriptor.getSource().getCMRFieldType() + ")  to EJB " + descriptor.getSink().getName() + " isMany " + descriptor.getSource().getIsMany() + " cascade-delete " + descriptor.getSource().getCascadeDelete());
        DOLUtils.getDefaultLogger().info("To  EJB " + descriptor.getSink().getName() + " isMany " + descriptor.getSink().getIsMany() + " cascade-delete " + descriptor.getSink().getCascadeDelete());
        if (descriptor.getIsBidirectional()) {
            DOLUtils.getDefaultLogger().info("Bidirectional cmr field : " + descriptor.getSink().getCMRField() + "(" + descriptor.getSink().getCMRFieldType() + ")");
        }
    }

    public void accept(Descriptor descriptor) {
        DOLUtils.getDefaultLogger().info(descriptor.toString());
    }

    public void accept(ApplicationClientDescriptor appclientDesc) {
        DOLUtils.getDefaultLogger().info("==================");
        DOLUtils.getDefaultLogger().info("\tAppClient Description " + appclientDesc.getDescription());
        DOLUtils.getDefaultLogger().info("\tAppClient Name " + appclientDesc.getName());
        DOLUtils.getDefaultLogger().info("\tAppClient Small Icon " + appclientDesc.getSmallIconUri());
        DOLUtils.getDefaultLogger().info("\tAppClient Large Icon " + appclientDesc.getLargeIconUri());
        DOLUtils.getDefaultLogger().info("\tAppClient Callback Handler " + appclientDesc.getCallbackHandler());
    }

    public void accept(ConnectorDescriptor conDesc) {
        DOLUtils.getDefaultLogger().info("==================");
        DOLUtils.getDefaultLogger().info(conDesc.toString());
    }

    public void accept(WebBundleDescriptor descriptor) {
        DOLUtils.getDefaultLogger().info(descriptor.toString());
    }

    public void accept(WebComponentDescriptor descriptor) {
        DOLUtils.getDefaultLogger().info("==================");
        DOLUtils.getDefaultLogger().info(descriptor.toString());
    }
}

