/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;

public class ModuleContentLinker
extends DefaultDOLVisitor {
    protected FileArchive rootLocation_;

    public ModuleContentLinker(FileArchive rootLocation) {
        this.rootLocation_ = rootLocation;
    }

    protected ModuleContentLinker() {
    }

    private File getModuleLocation(ModuleDescriptor module) throws IOException {
        File moduleLocation = new File(this.rootLocation_.getArchiveUri());
        if (!module.isStandalone()) {
            String archiveUri = module.getArchiveUri();
            moduleLocation = new File(this.rootLocation_.getEmbeddedArchive(archiveUri).getArchiveUri());
        }
        return moduleLocation;
    }

    private URL internalGetUrl(ModuleDescriptor module, String uri) throws Exception {
        File moduleLocation = this.getModuleLocation(module);
        URL url = FileUtil.getEntryAsUrl(moduleLocation, uri);
        return url;
    }

    public void accept(ServiceReferenceDescriptor serviceRef) {
        try {
            ModuleDescriptor moduleDesc = serviceRef.getBundleDescriptor().getModuleDescriptor();
            if (serviceRef.hasWsdlFile()) {
                String wsdlFileUri = serviceRef.getWsdlFileUri();
                File wsdlFile = new File(this.getModuleLocation(moduleDesc), wsdlFileUri);
                URL wsdlFileUrl = this.internalGetUrl(moduleDesc, wsdlFileUri);
                serviceRef.setWsdlFileUrl(wsdlFile.toURL());
            }
            if (serviceRef.hasMappingFile()) {
                String mappingFileUri = serviceRef.getMappingFileUri();
                File mappingFile = new File(this.getModuleLocation(moduleDesc), mappingFileUri);
                serviceRef.setMappingFile(mappingFile);
            }
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{serviceRef.getName(), this.rootLocation_});
        }
    }

    public void accept(WebService webService) {
        try {
            ModuleDescriptor moduleDesc = webService.getBundleDescriptor().getModuleDescriptor();
            if (webService.hasWsdlFile()) {
                String wsdlFileUri = webService.getWsdlFileUri();
                File wsdlFile = new File(this.getModuleLocation(moduleDesc), wsdlFileUri);
                webService.setWsdlFileUrl(wsdlFile.toURL());
            }
            if (webService.hasMappingFile()) {
                String mappingFileUri = webService.getMappingFileUri();
                File mappingFile = new File(this.getModuleLocation(moduleDesc), mappingFileUri);
                webService.setMappingFile(mappingFile);
            }
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{webService.getWebServiceName(), this.rootLocation_});
        }
    }
}

