/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.ui;

import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeployerFactory;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.ui.SystemPropertiesSetter;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.util.Console;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.diagnostics.SystemProps;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DeployUnitTestTool {
    private String installRoot;
    private List args;
    private boolean debug = false;
    private DeploymentCommand command;
    private DeployableObjectType type;
    private String name;
    private String contextRoot = null;
    private String instance;
    private File file;
    private boolean interactive = false;
    private boolean shared = false;
    private boolean forced = false;
    private static boolean byron;
    private boolean noEJBC = false;
    String[][] DEFAULT_PROPS = new String[][]{{"org.xml.sax.parser", "org.xml.sax.helpers.XMLReaderAdapter"}, {"org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl"}, {"java.security.policy", "%IAS_HOME%/admin-server/config/server.policy"}, {"java.security.auth.login.config", "%IAS_HOME%/admin-server/config/login.conf"}, {"com.sun.jdo.api.persistence.model.multipleClassLoaders", "reload"}, {"KeepFailedStubs", "true"}};
    static final /* synthetic */ boolean $assertionsDisabled;

    DeployUnitTestTool(String[] theArgs) {
        this.args = new ArrayList();
        if (theArgs == null || theArgs.length < 1) {
            DeployUnitTestTool.goodbye("No arguments");
        }
        for (int i = 0; i < theArgs.length; ++i) {
            this.args.add(theArgs[i]);
        }
        this.parseResponseFile();
        this.setEnv();
        this.parseReporter();
        this.parseEJBCFlag();
        this.parseInstance();
        this.parseCommand();
        this.parseName();
        this.parseFile();
        this.parseType();
        this.parseShared();
        this.parseContextRoot();
        this.parseForced();
        this.doDeploy();
    }

    private void doDeploy() {
        try {
            DeploymentRequest req = new DeploymentRequest(new InstanceEnvironment(this.instance), this.type, this.command);
            if (this.file != null) {
                req.setFileSource(this.file);
            }
            if (this.name != null) {
                req.setName(this.name);
            }
            if (this.contextRoot != null) {
                req.setContextRoot(this.contextRoot);
            }
            if (this.debug) {
                req.setDebug(true);
            }
            if (this.type.isEJB() && this.shared) {
                req.setShared(true);
            }
            if (this.noEJBC) {
                req.setNoEJBC();
            }
            req.setForced(this.forced);
            Deployer deployer = DeployerFactory.getDeployer(req);
            deployer.doRequest();
        }
        catch (IASDeploymentException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void parseReporter() {
    }

    private void parseEJBCFlag() {
        this.noEJBC = this.getSwitch("-noejbc");
    }

    private void parseResponseFile() {
        String responseName = this.getSwitchParameter("-response");
        if (responseName == null) {
            return;
        }
        File responseFile = new File(responseName);
        if (!responseFile.exists() && !(responseFile = new File(new File(System.getProperty("user.dir")), responseName)).exists()) {
            DeployUnitTestTool.goodbye("Can't find either " + responseName + " or " + responseFile.getPath());
        }
        try {
            this.args = new ArrayList();
            BufferedReader reader = new BufferedReader(new FileReader(responseFile));
            String s = reader.readLine();
            while (s != null) {
                if (s.length() > 0 && s.charAt(0) != '#') {
                    this.args.add(s);
                }
                s = reader.readLine();
            }
        }
        catch (IOException e) {
            DeployUnitTestTool.goodbye("Error reading response file: " + e);
        }
    }

    private void parseInstance() {
        this.instance = this.getSwitchParameter("-instance");
        if (this.instance == null) {
            if (this.interactive) {
                this.instance = Console.readLine("Instance Name:");
            } else {
                DeployUnitTestTool.goodbye("You must specify '-instance instance-name'");
            }
        }
    }

    private void parseFile() {
        String fname = this.getSwitchParameter("-file");
        this.file = null;
        if (fname != null) {
            this.file = new File(fname);
            return;
        }
        if (this.command == DeploymentCommand.UNDEPLOY) {
            return;
        }
        if (this.interactive) {
            fname = Console.readLine("Ear filename: ");
        }
        if (!StringUtils.ok((String)fname)) {
            DeployUnitTestTool.goodbye("You must specify '-file ear-filename' for deploy");
        }
        this.file = new File(fname);
    }

    private void parseName() {
        this.name = this.getSwitchParameter("-name");
        if (this.name != null) {
            return;
        }
        if (this.command == DeploymentCommand.DEPLOY) {
            if (!this.interactive) {
                return;
            }
            this.name = Console.readLine("App Name [optional - leave empty for Deployment to create a name]:");
            if (!StringUtils.ok((String)this.name)) {
                this.name = null;
            }
            return;
        }
        if (this.interactive) {
            this.name = Console.readLine("App Name [required]:");
        }
        if (this.name == null) {
            DeployUnitTestTool.goodbye("You must specify '-name aname' for undeploy");
        }
    }

    private void parseCommand() {
        this.command = this.getDeployCommand();
        if (this.command == null) {
            String s;
            char c;
            if (!this.interactive) {
                DeployUnitTestTool.goodbye("You must specify -deploy or -undeploy");
            }
            if ((c = (s = Console.readLine("Command [D|U]:").toLowerCase()).charAt(0)) == 'u') {
                this.command = DeploymentCommand.UNDEPLOY;
            } else if (c == 'd') {
                this.command = DeploymentCommand.DEPLOY;
            } else {
                DeployUnitTestTool.goodbye("Unknown command: " + s);
            }
        }
    }

    private void parseContextRoot() {
        this.contextRoot = null;
        if (!this.type.isWEB()) {
            return;
        }
        this.contextRoot = this.getContextRoot();
        if (this.contextRoot == null && this.command != DeploymentCommand.UNDEPLOY) {
            if (!this.interactive) {
                DeployUnitTestTool.goodbye("You must specify a context root for Web Modules (-contextroot name)");
            }
            this.contextRoot = Console.readLine("Context Root:");
        }
    }

    private void promptType() {
        String s = Console.readLine("Command [A|E|W|C]:").toLowerCase();
        char c = s.charAt(0);
        this.type = null;
        if (c == 'a') {
            this.type = DeployableObjectType.APP;
        } else if (c == 'e') {
            this.type = DeployableObjectType.EJB;
        } else if (c == 'w') {
            this.type = DeployableObjectType.WEB;
        } else if (c == 'c') {
            this.type = DeployableObjectType.CONN;
        }
    }

    private void parseShared() {
        this.shared = this.getSwitch("-shared");
    }

    private void parseForced() {
        this.forced = this.getSwitch("-forced");
    }

    private void parseType() {
        this.type = this.getDeployType();
        if (this.type != null) {
            return;
        }
        if (this.command == DeploymentCommand.UNDEPLOY) {
            if (this.interactive) {
                this.promptType();
                if (this.type == null) {
                    DeployUnitTestTool.goodbye("You need to specify whether it's an App or Module.");
                }
            } else {
                DeployUnitTestTool.goodbye("You must specify -app, -web, -connector or -ejb for Undeploy");
            }
            return;
        }
        if (this.interactive) {
            this.promptType();
            if (this.type != null) {
                return;
            }
        }
        if (FileUtils.isEar(this.file)) {
            this.type = DeployableObjectType.APP;
        } else if (FileUtils.isJar(this.file)) {
            this.type = DeployableObjectType.EJB;
        } else if (FileUtils.isWar(this.file)) {
            this.type = DeployableObjectType.WEB;
        } else if (FileUtils.isRar(this.file)) {
            this.type = DeployableObjectType.CONN;
        } else {
            DeployUnitTestTool.goodbye("Can't figure out whether it's an App or what kind of Module from the filename: " + this.file);
        }
    }

    private DeploymentCommand getDeployCommand() {
        boolean com = this.getSwitch("-deploy");
        if (com) {
            return DeploymentCommand.DEPLOY;
        }
        com = this.getSwitch("-undeploy");
        if (com) {
            return DeploymentCommand.UNDEPLOY;
        }
        return null;
    }

    private String getContextRoot() {
        String cr = this.getSwitchParameter("-contextroot");
        if (StringUtils.ok((String)cr)) {
            return cr;
        }
        return null;
    }

    private DeployableObjectType getDeployType() {
        boolean com = this.getSwitch("-ejb");
        if (com) {
            return DeployableObjectType.EJB;
        }
        com = this.getSwitch("-web");
        if (com) {
            return DeployableObjectType.WEB;
        }
        com = this.getSwitch("-app");
        if (com) {
            return DeployableObjectType.APP;
        }
        com = this.getSwitch("-connector");
        if (com) {
            return DeployableObjectType.CONN;
        }
        com = this.getSwitch("-conn");
        if (com) {
            return DeployableObjectType.CONN;
        }
        return null;
    }

    private void setEnv() {
        if (this.getSwitch("-debug")) {
            this.debug = true;
        }
        if (this.getSwitch("-i")) {
            this.interactive = true;
        }
        this.setInstallRoot();
        this.checkInstallRoot();
        if (!this.setEnvFromFile()) {
            this.setDefaultEnv();
        }
        if (this.debug) {
            System.out.println("\n\n************* Here are all the System Props *****\n" + SystemProps.toStringStatic());
        }
    }

    private void setInstallRoot() {
        this.installRoot = this.getSwitchParameter("-installroot");
        if (this.installRoot == null) {
            this.installRoot = System.getProperty("com.sun.aas.installRoot");
        }
    }

    private void checkInstallRoot() {
        if (!StringUtils.ok((String)this.installRoot)) {
            DeployUnitTestTool.goodbye("com.sun.aas.installRoot is a mandatory java environmental variable, and it isn't set.");
        }
        if (!FileUtils.safeIsDirectory(new File(this.installRoot))) {
            DeployUnitTestTool.goodbye("com.sun.aas.installRoot is not pointing at a directory (" + this.installRoot + ")");
        }
        System.out.println("com.sun.aas.installRoot is OK -- set to " + this.installRoot);
    }

    private boolean setEnvFromFile() {
        String configFile = this.getSwitchParameter("-config");
        if (configFile == null) {
            return false;
        }
        System.out.println("config file: " + configFile);
        File f = new File(configFile);
        if (!f.exists()) {
            DeployUnitTestTool.goodbye("Config File doesn't exist: " + FileUtils.safeGetCanonicalPath(f));
        }
        new SystemPropertiesSetter(f);
        System.out.println("Set props from config file...");
        return true;
    }

    private void setDefaultEnv() {
        Properties props = new Properties();
        props.setProperty("com.sun.aas.installRoot", this.installRoot);
        props.setProperty("com.sun.aas.instanceRoot", this.installRoot + "/domains/domain1");
        for (int i = 0; i < this.DEFAULT_PROPS.length; ++i) {
            props.setProperty(this.DEFAULT_PROPS[i][0], this.DEFAULT_PROPS[i][1]);
        }
        new SystemPropertiesSetter(props);
    }

    private String getSwitchParameter(String sw) {
        Iterator it = this.args.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (!arg.toLowerCase().equals(sw)) continue;
            if (!it.hasNext()) {
                DeployUnitTestTool.goodbye(sw + " switch with no parameter");
            }
            it.remove();
            String ret = (String)it.next();
            it.remove();
            return ret;
        }
        return null;
    }

    private boolean getSwitch(String sw) {
        Iterator it = this.args.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (!arg.toLowerCase().equals(sw)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("DeployUnitTestTool [-debug] [-ejb|-web|-app|-connector] [-installroot ias-install-dir] [-config config-filename] [-deploy|-undeploy] [-name appName] [-file ear-filename] -instance instanceName[-contextroot rootname][-shared]\n == OR ==\nDeployUnitTestTool -response response-filename\nOne line per command in the response file.  The filename can be either a full pathname, or the name of a file located in the current working directory.");
    }

    private static void goodbye(String mesg) {
        System.out.println("FATAL ERROR:  " + mesg);
        DeployUnitTestTool.usage();
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length <= 0) {
            DeployUnitTestTool.goodbye("no args");
        }
        try {
            if (args[0].equals("-responses")) {
                DeployUnitTestTool.doMulti(args);
            } else {
                new DeployUnitTestTool(args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doMulti(String[] args) {
        if (!$assertionsDisabled && args.length <= 1) {
            throw new AssertionError();
        }
        String[] miniArgs = new String[2];
        miniArgs[0] = "-response";
        try {
            for (int i = 1; i < args.length; ++i) {
                miniArgs[1] = args[i];
                new DeployUnitTestTool(miniArgs);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !DeployUnitTestTool.class.desiredAssertionStatus();
        byron = false;
    }
}

