/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.ui;

import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.util.diagnostics.ObjectAnalyzer;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;

abstract class DBETestToolInfo {
    private String domainName = "domain1";
    private String domainsName = "domains";
    private String instance = "server";
    private boolean forced = false;
    private boolean noEJBC = false;
    private boolean jspc = false;
    private String installRoot = null;
    private String name = null;
    private String contextRoot = null;
    private DeploymentCommand command = null;
    private DeployableObjectType type = null;
    private File fileSource = null;

    DBETestToolInfo() throws IASDeploymentException {
    }

    void setDomainName(String n) {
        this.domainName = n;
    }

    String getDomainName() {
        return this.domainName;
    }

    void setDomainsName(String n) {
        this.domainsName = n;
    }

    String getDomainsName() {
        return this.domainsName;
    }

    void setInstallRoot(String n) {
        this.installRoot = n;
    }

    String getInstallRoot() throws IASDeploymentException {
        if (this.installRoot == null || !FileUtils.safeIsDirectory(this.installRoot)) {
            throw new IASDeploymentException("installRoot is not a directory: " + this.installRoot);
        }
        return this.installRoot;
    }

    void setName(String n) {
        this.name = n;
    }

    String getName() {
        return this.name;
    }

    void setInstance(String i) {
        this.instance = i;
    }

    String getInstance() {
        return this.instance;
    }

    void setCommand(DeploymentCommand c) {
        this.command = c;
    }

    DeploymentCommand getCommand() throws IASDeploymentException {
        if (this.command == null) {
            throw new IASDeploymentException("No DeploymentCommand set");
        }
        return this.command;
    }

    void setType(DeployableObjectType t) {
        this.type = t;
    }

    DeployableObjectType getType() throws IASDeploymentException {
        if (this.type == null) {
            throw new IASDeploymentException("No DeployableObjectType set");
        }
        return this.type;
    }

    void setFileSource(String s) {
        this.setFileSource(new File(s));
    }

    void setFileSource(File f) {
        this.fileSource = f;
    }

    File getFileSource() throws IASDeploymentException {
        if (this.fileSource == null) {
            throw new IASDeploymentException("No FileSource set");
        }
        if (!this.fileSource.exists()) {
            throw new IASDeploymentException("FileSource doesn't exist: " + this.fileSource);
        }
        return this.fileSource;
    }

    void setForced(boolean b) {
        this.forced = b;
    }

    boolean getForced() {
        return this.forced;
    }

    void setNoEJBC(boolean b) {
        this.noEJBC = b;
    }

    boolean getNoEJBC() {
        return this.noEJBC;
    }

    void setPrecompileJSP(boolean b) {
        this.jspc = b;
    }

    boolean getPrecompileJSP() {
        return this.jspc;
    }

    void setContextRoot(String s) {
        this.contextRoot = s;
    }

    String getContextRoot() {
        return this.contextRoot;
    }

    public String toString() {
        return ObjectAnalyzer.toString(this) + "\n" + ObjectAnalyzer.getSetters(this);
    }
}

