/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.ui;

import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeployerFactory;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.ui.DBETestToolInfo;
import com.sun.enterprise.deployment.ui.SimpleXMLParser;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.util.diagnostics.ObjectAnalyzer;
import com.sun.enterprise.util.diagnostics.SystemProps;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;

public class DBETestTool
extends DBETestToolInfo {
    public void doRequest() throws IASDeploymentException {
        this.init();
        this.setLateBindingProps();
        System.out.println("*******  System Props Start *******");
        System.out.println(SystemProps.toStringStatic());
        System.out.println("*******  System Props Start *******");
        DeploymentRequest req = new DeploymentRequest(new InstanceEnvironment(this.getInstance()), this.getType(), this.getCommand());
        if (this.getCommand() != DeploymentCommand.UNDEPLOY) {
            req.setFileSource(this.getFileSource());
        }
        if (this.getName() != null) {
            req.setName(this.getName());
        }
        if (this.getContextRoot() != null) {
            req.setContextRoot(this.getContextRoot());
        }
        if (this.getNoEJBC()) {
            req.setNoEJBC();
        }
        req.setForced(this.getForced());
        req.setPrecompileJSP(this.getPrecompileJSP());
        Deployer deployer = DeployerFactory.getDeployer(req);
        deployer.doRequest();
        deployer.cleanup();
    }

    public String toString() {
        return ObjectAnalyzer.toStringWithSuper(this);
    }

    private void init() throws IASDeploymentException {
        this.setBootstrapProps();
        this.setSpecialProps();
        this.parseProps();
    }

    private void setBootstrapProps() throws IASDeploymentException {
        File f = new File(this.getInstallRoot());
        if (!FileUtils.safeIsDirectory(f)) {
            throw new IllegalArgumentException("Bad Install Root: " + this.getInstallRoot());
        }
        System.setProperty("com.sun.aas.installRoot", f.getAbsolutePath());
        f = new File(f, this.getDomainsName());
        if (!FileUtils.safeIsDirectory(f)) {
            throw new IllegalArgumentException("Bad Install Domains Root (com.sun.aas.domainsRoot): " + f);
        }
        System.setProperty("com.sun.aas.domainsRoot", f.getAbsolutePath());
        f = new File(f, this.getDomainName());
        if (!FileUtils.safeIsDirectory(f)) {
            throw new IllegalArgumentException("Bad Install Instance Root (com.sun.aas.instanceRoot): " + f);
        }
        System.setProperty("com.sun.aas.instanceRoot", f.getAbsolutePath());
    }

    private void setSpecialProps() {
        System.setProperty("com.sun.aas.deployment.javac.file.enable", "false");
    }

    private void setLateBindingProps() throws IASDeploymentException {
        String server = this.getInstance();
        String value = System.getProperty("com.sun.aas.instanceRoot");
        if (value == null || !FileUtils.safeIsDirectory(value)) {
            throw new IASDeploymentException("Bad com.sun.aas.instanceRoot -- " + value);
        }
        value = value + "/" + server + "/generated/policy";
        value = value.replace('\\', '/');
        System.setProperty("com.sun.enterprise.jaccprovider.property.repository", value);
    }

    private void parseProps() throws IASDeploymentException {
        SimpleXMLParser parser = new SimpleXMLParser(this.getInstance());
    }

    public static void main(String[] args) {
        try {
            DBETestTool dtt = new DBETestTool();
            dtt.setInstallRoot("D:/ias8");
            dtt.setFileSource("d:/ias8samples/foo.war");
            dtt.setType(DeployableObjectType.WEB);
            dtt.setCommand(DeploymentCommand.DEPLOY);
            dtt.setContextRoot("foo38883");
            dtt.setForced(true);
            System.out.println(dtt.toString());
            dtt.doRequest();
        }
        catch (IASDeploymentException de) {
            de.printStackTrace();
        }
    }
}

