/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class ClasspathParser {
    private File domainXML;
    private String[] classpath = null;
    private String installRoot;

    public ClasspathParser(String installRoot, String domainFilename) {
        this.installRoot = installRoot;
        try {
            this.domainXML = new File(domainFilename);
            this.findClasspath();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void findClasspath() throws IOException {
        String s;
        BufferedReader reader = new BufferedReader(new FileReader(this.domainXML));
        while ((s = reader.readLine()) != null) {
            if (s.indexOf("<java-config") < 0) continue;
            this.parseClasspath(s);
            break;
        }
    }

    private void parseClasspath(String s) {
        String tag = "server-classpath=";
        int index = s.indexOf("server-classpath=");
        if (index < 0) {
            return;
        }
        s = s.substring(index + "server-classpath=".length());
        StringTokenizer st = new StringTokenizer(s, "<>\"" + File.pathSeparatorChar);
        this.classpath = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.classpath[i] = this.expandMacro(st.nextToken()).replace('\\', '/');
            ++i;
        }
    }

    private String expandMacro(String s) {
        String expanded;
        if (!s.startsWith("${")) {
            return s;
        }
        int rightBrace = s.indexOf(125);
        if (rightBrace < 0) {
            return s;
        }
        int len = s.length();
        String javaVar = s.substring(2, rightBrace);
        String theRest = "";
        if (len > rightBrace + 1) {
            theRest = s.substring(rightBrace + 1);
        }
        if ((expanded = javaVar.equals("java.home") ? this.installRoot + "/jdk" : System.getProperty(javaVar)) == null) {
            throw new RuntimeException("Can't find java-variable that is embedded in the path: " + s.substring(0, rightBrace + 1));
        }
        String ret = expanded + theRest;
        return ret;
    }

    public String toString() {
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        for (int i = 0; i < this.classpath.length; ++i) {
            sb1.append(this.classpath[i]);
            sb1.append('\n');
            if (i != 0) {
                sb2.append(File.pathSeparatorChar);
            }
            sb2.append(this.classpath[i]);
        }
        return sb1.toString() + "\n" + sb2.toString();
    }

    public static void main(String[] args) {
        try {
            ClasspathParser sx = new ClasspathParser("D:/ias8", "D:/ias8/domains/domain1/server/config/domain.xml");
            System.out.println(sx);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

