/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.server.core.AdminNotificationHelper;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class StopPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(StopPhase.class);
    private static final String LIST_ADMIN_OBJECTS = "getAdminObjectResource";
    private static final String DELETE_ADMIN_OBJECT = "deleteAdminObjectResource";
    private static final String LIST_CONNECTOR_CONNECTION_POOLS = "getConnectorConnectionPool";
    private static final String DELETE_CONNECTOR_CONNECTION_POOL = "deleteConnectorConnectionPool";
    private static final String LIST_RESOURCE_ADAPTER_CONFIGS = "getResourceAdapterConfig";
    private static final String DELETE_RESOURCE_ADAPTER_CONFIG = "deleteResourceAdapterConfig";

    public StopPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "Stop";
    }

    public void prePhase(DeploymentPhaseContext phaseCtx) {
        DeploymentStatus status = phaseCtx.getDeploymentStatus();
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        if (!req.getCascade()) {
            try {
                if (this.checkConnectorDependentResources(req.getName(), status)) {
                    status.setStageStatus(0);
                    String dependentResource = status.getStageStatusMessage();
                    status.setStageStatusMessage(localStrings.getString("enterprise.deployment.phasing.stop.dependentresexist", new Object[]{dependentResource, req.getName()}));
                }
            }
            catch (Throwable t) {
                status.setStageStatus(0);
                status.setStageException(t);
                status.setStageStatusMessage(t.getMessage());
            }
        }
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        boolean success;
        String type = null;
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        DeploymentTarget target = (DeploymentTarget)req.getTarget();
        DeploymentStatus status = phaseCtx.getDeploymentStatus();
        try {
            if (req.getCascade() && !req.isForced()) {
                this.deleteConnectorDependentResources(req.getName(), target.getName());
                this.deploymentCtx.getConfigContext().flush();
                AdminContext adminContext = AdminService.getAdminService().getAdminContext();
                new AdminNotificationHelper(adminContext).sendNotification();
            }
        }
        catch (Throwable t) {
            status.setStageStatus(0);
            status.setStageException(t);
            status.setStageStatusMessage(t.getMessage());
            return;
        }
        if (!req.isApplication()) {
            type = DeploymentServiceUtils.getModuleTypeString(req.getType());
        }
        this.prePhaseNotify(this.getPrePhaseEvent(req));
        try {
            success = target.sendStopEvent(req.getActionCode(), req.getName(), type, req.getCascade(), req.isForced());
        }
        catch (DeploymentTargetException dte) {
            status.setStageStatus(0);
            if (dte.getCause() != null) {
                status.setStageException(dte.getCause());
                status.setStageStatusMessage(dte.getMessage());
            }
            return;
        }
        if (success) {
            status.setStageStatus(2);
        } else {
            status.setStageStatus(0);
            status.setStageStatusMessage("Application failed to stop");
        }
        this.postPhaseNotify(this.getPostPhaseEvent(req));
    }

    protected DeploymentEvent getPrePhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(7, new DeploymentEventInfo(req));
    }

    protected DeploymentEvent getPostPhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(8, new DeploymentEventInfo(req));
    }

    private boolean checkConnectorDependentResources(String id, DeploymentStatus status) throws Exception {
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        ObjectName mbeanName = new ObjectName("com.sun.appserv:type=resources,category=config");
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        ObjectName[] adminObjs = (ObjectName[])mbs.invoke(mbeanName, LIST_ADMIN_OBJECTS, params, signature);
        for (int i = 0; i < adminObjs.length; ++i) {
            String raName = (String)mbs.getAttribute(adminObjs[i], "res_adapter");
            if (!id.equals(raName)) continue;
            String adminObjName = (String)mbs.getAttribute(adminObjs[i], "jndi_name");
            status.setStageStatusMessage("admin object [" + adminObjName + "]");
            return true;
        }
        ObjectName[] poolNames = (ObjectName[])mbs.invoke(mbeanName, LIST_CONNECTOR_CONNECTION_POOLS, params, signature);
        for (int i = 0; i < poolNames.length; ++i) {
            String raName = (String)mbs.getAttribute(poolNames[i], "resource_adapter_name");
            if (!id.equals(raName)) continue;
            String poolName = (String)mbs.getAttribute(poolNames[i], "name");
            status.setStageStatusMessage("connector connection pool [" + poolName + "]");
            return true;
        }
        ObjectName[] resAdapterConfigs = (ObjectName[])mbs.invoke(mbeanName, LIST_RESOURCE_ADAPTER_CONFIGS, params, signature);
        for (int i = 0; i < resAdapterConfigs.length; ++i) {
            String raName = (String)mbs.getAttribute(resAdapterConfigs[i], "resource_adapter_name");
            if (!id.equals(raName)) continue;
            status.setStageStatusMessage("resource adapter config");
            return true;
        }
        return false;
    }

    private void deleteConnectorDependentResources(String id, String targetName) throws Exception {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName mbeanName = new ObjectName("com.sun.appserv:type=resources,category=config");
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            ObjectName[] adminObjs = (ObjectName[])mbs.invoke(mbeanName, LIST_ADMIN_OBJECTS, params, signature);
            String[] adminObjSignature = new String[]{"java.lang.String", "java.lang.String"};
            for (int i = 0; i < adminObjs.length; ++i) {
                String raName = (String)mbs.getAttribute(adminObjs[i], "res_adapter");
                if (!id.equals(raName)) continue;
                String adminObjName = (String)mbs.getAttribute(adminObjs[i], "jndi_name");
                Object[] deleteAdminParams = new Object[]{adminObjName, targetName};
                mbs.invoke(mbeanName, DELETE_ADMIN_OBJECT, deleteAdminParams, adminObjSignature);
            }
            ObjectName[] poolNames = (ObjectName[])mbs.invoke(mbeanName, LIST_CONNECTOR_CONNECTION_POOLS, params, signature);
            String[] deletePoolSignature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String"};
            for (int i = 0; i < poolNames.length; ++i) {
                String raName = (String)mbs.getAttribute(poolNames[i], "resource_adapter_name");
                if (!id.equals(raName)) continue;
                String poolName = (String)mbs.getAttribute(poolNames[i], "name");
                Object[] deletePoolParams = new Object[]{poolName, Boolean.TRUE, targetName};
                mbs.invoke(mbeanName, DELETE_CONNECTOR_CONNECTION_POOL, deletePoolParams, deletePoolSignature);
            }
            ObjectName[] resAdapterConfigs = (ObjectName[])mbs.invoke(mbeanName, LIST_RESOURCE_ADAPTER_CONFIGS, params, signature);
            String[] adapterConfigSignature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] adapterConfigParams = new Object[]{id, targetName};
            for (int i = 0; i < resAdapterConfigs.length; ++i) {
                String raName = (String)mbs.getAttribute(resAdapterConfigs[i], "resource_adapter_name");
                if (!id.equals(raName)) continue;
                mbs.invoke(mbeanName, DELETE_RESOURCE_ADAPTER_CONFIG, adapterConfigParams, adapterConfigSignature);
            }
        }
        catch (Exception e) {
            throw new DeploymentPhaseException(this.getName(), "Exception occured while deleting dependent connector resources", e);
        }
    }
}

