/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.backend.ClientJarMakerRegistry;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentRequestRegistry;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.AssociationPhase;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentService;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DisassociationPhase;
import com.sun.enterprise.deployment.phasing.J2EECPhase;
import com.sun.enterprise.deployment.phasing.StartPhase;
import com.sun.enterprise.deployment.phasing.StopPhase;
import com.sun.enterprise.deployment.phasing.UndeployFromDomainPhase;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.management.deploy.DeploymentCallback;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PEDeploymentService
extends DeploymentService {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(PEDeploymentService.class);
    protected DeploymentContext deploymentContext = new DeploymentContext();
    private List deployToDomainPhaseList = null;
    private List undeployFromDomainPhaseList = null;
    private List deployPhaseList = null;
    private List undeployPhaseList = null;
    private List associatePhaseList = null;
    private List disassociatePhaseList = null;
    private List stopPhaseList = null;
    private List startPhaseList = null;
    private static final String UNDEPLOY_ACTION = "undeploy";
    private static final String REDEPLOY_ACTION = "redeploy";

    public PEDeploymentService(ConfigContext configContext) {
        this.deploymentContext.setConfigContext(configContext);
        this.initializePhases();
    }

    protected List getDeployPhaseListForTarget(DeploymentRequest req) {
        if (this.deployPhaseList != null) {
            return this.deployPhaseList;
        }
        J2EECPhase j2eec = new J2EECPhase(this.deploymentContext);
        AssociationPhase associate = new AssociationPhase(this.deploymentContext);
        StartPhase start = new StartPhase(this.deploymentContext);
        this.deployPhaseList = new ArrayList();
        this.deployPhaseList.add(j2eec);
        this.deployPhaseList.add(associate);
        this.deployPhaseList.add(start);
        return this.deployPhaseList;
    }

    private void initializePhases() {
        J2EECPhase j2eec = new J2EECPhase(this.deploymentContext);
        AssociationPhase associate = new AssociationPhase(this.deploymentContext);
        StartPhase start = new StartPhase(this.deploymentContext);
        DisassociationPhase disassociate = new DisassociationPhase(this.deploymentContext);
        StopPhase stop = new StopPhase(this.deploymentContext);
        UndeployFromDomainPhase undeploy = new UndeployFromDomainPhase(this.deploymentContext);
        this.deployToDomainPhaseList = new ArrayList();
        this.deployToDomainPhaseList.add(j2eec);
        this.associatePhaseList = new ArrayList();
        this.associatePhaseList.add(associate);
        this.disassociatePhaseList = new ArrayList();
        this.disassociatePhaseList.add(disassociate);
        this.undeployPhaseList = new ArrayList();
        this.undeployPhaseList.add(stop);
        this.undeployPhaseList.add(disassociate);
        this.undeployPhaseList.add(undeploy);
        this.undeployFromDomainPhaseList = new ArrayList();
        this.undeployFromDomainPhaseList.add(undeploy);
        this.startPhaseList = new ArrayList();
        this.startPhaseList.add(start);
        this.stopPhaseList = new ArrayList();
        this.stopPhaseList.add(stop);
    }

    public DeploymentStatus deploy(DeploymentRequest req) throws IASDeploymentException {
        if (req.getTarget() != null && !req.getTarget().getName().equals("domain")) {
            return this.executePhases(req, this.getDeployPhaseListForTarget(req));
        }
        return this.executePhases(req, this.deployToDomainPhaseList);
    }

    public DeploymentStatus undeploy(DeploymentRequest req) {
        if (AppVerification.doInstrument()) {
            AppVerification.getInstrumentLogger().handleChangeInDeployment();
        }
        if (req.getTarget() != null) {
            return this.executePhases(req, this.undeployPhaseList);
        }
        return this.executePhases(req, this.undeployFromDomainPhaseList);
    }

    public DeploymentStatus associate(DeploymentRequest req) throws IASDeploymentException {
        return this.executePhases(req, this.associatePhaseList);
    }

    public DeploymentStatus associate(String targetName, boolean enabled, String virtualServers, String referenceName) throws IASDeploymentException {
        try {
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(referenceName);
            DeploymentTarget target = DeploymentServiceUtils.getAndValidateDeploymentTarget(targetName, referenceName, false);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.DEPLOY);
            req.setName(referenceName);
            req.setStartOnDeploy(enabled);
            req.setTarget(target);
            Properties optionalAttributes = new Properties();
            if (virtualServers != null) {
                optionalAttributes.put(ServerTags.VIRTUAL_SERVERS, virtualServers);
            }
            req.setOptionalAttributes(optionalAttributes);
            return this.associate(req);
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus associate(String targetName, String referenceName, Map options) throws IASDeploymentException {
        DeploymentProperties dProps = new DeploymentProperties(options);
        String virtualServers = dProps.getVirtualServers();
        boolean enabled = dProps.getEnable();
        return this.associate(targetName, enabled, virtualServers, referenceName);
    }

    public DeploymentStatus disassociate(DeploymentRequest req) {
        return this.executePhases(req, this.disassociatePhaseList);
    }

    public DeploymentStatus disassociate(String targetName, String referenceName) throws IASDeploymentException {
        try {
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(referenceName);
            DeploymentTarget target = DeploymentServiceUtils.getAndValidateDeploymentTarget(targetName, referenceName, true);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.UNDEPLOY);
            req.setName(referenceName);
            req.setTarget(target);
            return this.disassociate(req);
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus disassociate(String targetName, String referenceName, Map options) throws IASDeploymentException {
        try {
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(referenceName);
            DeploymentTarget target = DeploymentServiceUtils.getAndValidateDeploymentTarget(targetName, referenceName, true);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.UNDEPLOY);
            req.setName(referenceName);
            req.setTarget(target);
            DeploymentProperties dProps = new DeploymentProperties(options);
            req.setCascade(dProps.getCascade());
            req.setForced(dProps.getForce());
            return this.disassociate(req);
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus start(DeploymentRequest req) {
        return this.executePhases(req, this.startPhaseList);
    }

    public DeploymentStatus start(String moduleID, String targetName, Map options) throws IASDeploymentException {
        try {
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(moduleID);
            DeploymentTarget target = DeploymentServiceUtils.getDeploymentTarget(targetName);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.DEPLOY);
            int actionCode = type.isAPP() ? 1 : 4;
            req.setName(moduleID);
            req.setActionCode(actionCode);
            req.setTarget(target);
            DeploymentProperties dProps = new DeploymentProperties(options);
            req.setForced(dProps.getForce());
            return this.start(req);
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus stop(DeploymentRequest req) {
        return this.executePhases(req, this.stopPhaseList);
    }

    public DeploymentStatus stop(String moduleID, String targetName, Map options) throws IASDeploymentException {
        try {
            DeployableObjectType type = DeploymentServiceUtils.getRegisteredType(moduleID);
            DeploymentTarget target = DeploymentServiceUtils.getDeploymentTarget(targetName);
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.UNDEPLOY);
            int actionCode = type.isAPP() ? 2 : 5;
            req.setName(moduleID);
            req.setActionCode(actionCode);
            req.setTarget(target);
            DeploymentProperties dProps = new DeploymentProperties(options);
            req.setCascade(dProps.getCascade());
            req.setForced(dProps.getForce());
            return this.stop(req);
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus deploy(File deployFile, File planFile, String archiveName, String moduleID, DeploymentProperties dProps, DeploymentCallback callback) throws IASDeploymentException {
        try {
            if (deployFile == null) {
                throw new IASDeploymentException(localStrings.getString("deployfile_not_specified"));
            }
            sLogger.log(Level.FINE, "mbean.begin_deploy", moduleID);
            DeployableObjectType type = DeploymentServiceUtils.getTypeFromFile(deployFile.getPath());
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.DEPLOY);
            DeploymentRequestRegistry.getRegistry().addDeploymentRequest(moduleID, req);
            req.setName(moduleID);
            boolean isRegistered = false;
            isRegistered = DeploymentServiceUtils.isRegistered(moduleID, type);
            if (isRegistered) {
                DeploymentServiceUtils.validate(moduleID, type, REDEPLOY_ACTION);
            }
            req.setFileSource(deployFile);
            req.setDeploymentPlan(planFile);
            req.setForced(dProps.getForce());
            if (type.isWEB()) {
                req.setDefaultContextRoot(dProps.getDefaultContextRoot(archiveName));
                req.setContextRoot(dProps.getContextRoot());
            }
            req.setVerifying(dProps.getVerify());
            req.setPrecompileJSP(dProps.getPrecompileJSP());
            req.setGenerateRMIStubs(dProps.getGenerateRMIStubs());
            req.setAvailabilityEnabled(dProps.getAvailabilityEnabled());
            req.setDirectoryDeployed(dProps.getDirectoryDeployed());
            req.setStartOnDeploy(dProps.getEnable());
            req.setDescription(dProps.getDescription());
            req.setDeploymentCallback(callback);
            Properties optionalAttributes = new Properties();
            String virtualServers = dProps.getVirtualServers();
            if (virtualServers != null) {
                optionalAttributes.put(ServerTags.VIRTUAL_SERVERS, virtualServers);
            }
            req.setOptionalAttributes(optionalAttributes);
            req.addOptionalArguments(dProps.prune());
            DeploymentServiceUtils.setHostAndPort(req);
            return this.deploy(req);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.deploy_failed", e);
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public DeploymentStatus undeploy(String mModuleID, Map mParams) throws IASDeploymentException {
        sLogger.log(Level.FINE, "mbean.begin_undeploy", mModuleID);
        try {
            DeployableObjectType objectType = DeploymentServiceUtils.getRegisteredType(mModuleID);
            DeploymentServiceUtils.checkAppReferencesBeforeUndeployFromDomain(mModuleID);
            DeploymentServiceUtils.validate(mModuleID, objectType, UNDEPLOY_ACTION);
            if (objectType.isWEB()) {
                DeploymentServiceUtils.checkWebModuleReferences(mModuleID);
            }
            InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
            DeploymentRequest req = new DeploymentRequest(env, objectType, DeploymentCommand.UNDEPLOY);
            DeploymentRequestRegistry.getRegistry().addDeploymentRequest(mModuleID, req);
            DeploymentProperties dProps = new DeploymentProperties(mParams);
            req.setName(mModuleID);
            req.setCascade(dProps.getCascade());
            req.addOptionalArguments(dProps.prune());
            return this.undeploy(req);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "mbean.undeploy_failed", e);
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public boolean quit(String moduleID) {
        DeploymentRequest request = DeploymentRequestRegistry.getRegistry().getDeploymentRequest(moduleID);
        if (request != null) {
            request.setAbort(true);
            return true;
        }
        return false;
    }

    public static String getClientJarPath(String moduleID) {
        ClientJarMakerRegistry registry = ClientJarMakerRegistry.getInstance();
        if (registry.isRegistered(moduleID)) {
            registry.waitForCompletion(moduleID);
        }
        return moduleID + "Client.jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeploymentStatus executePhases(DeploymentRequest req, List phases) {
        try {
            Descriptor.setBoundsChecking(true);
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageDescription("Deployment");
            req.setCurrentDeploymentStatus(ds);
            DeploymentPhaseContext[] phaseCtx = new DeploymentPhaseContext[phases.size()];
            for (int i = 0; i < phases.size(); ++i) {
                try {
                    DeploymentStatus phaseDs = new DeploymentStatus(ds);
                    phaseCtx[i] = ((DeploymentPhase)phases.get(i)).executePhase(req, phaseDs);
                    if (phaseDs.getStageStatus() >= 1) continue;
                    this.rollbackPhases(phases, phaseCtx, i - 1);
                    DeploymentStatus deploymentStatus = ds;
                    return deploymentStatus;
                }
                catch (Throwable dpe) {
                    String msg = localStrings.getString("enterprise.deployment.phasing.deploymentservice.exception");
                    sLogger.log(Level.SEVERE, msg, dpe);
                    this.rollbackPhases(phases, phaseCtx, i - 1);
                    ds.setStageStatus(0);
                    if (dpe instanceof Serializable) {
                        ds.setStageException(dpe);
                    } else {
                        sLogger.severe(localStrings.getString("enterprise.deployment.phasing.exception_notserializable", dpe.getClass()));
                        sLogger.severe(localStrings.getString("enterprise.deployment.phasing.exception_notforwarded", dpe.getMessage()));
                    }
                    ds.setStageException(dpe);
                    ds.setStageStatusMessage(dpe.getMessage());
                    DeploymentStatus deploymentStatus = ds;
                    return deploymentStatus;
                }
            }
            DeploymentStatus deploymentStatus = ds;
            return deploymentStatus;
        }
        finally {
            req.done();
        }
    }

    private void rollbackPhases(List phases, DeploymentPhaseContext[] phaseCtx, int index) {
        for (int j = index; j >= 0; --j) {
            try {
                ((DeploymentPhase)phases.get(j)).rollback(phaseCtx[j]);
                continue;
            }
            catch (Exception rollbackException) {
                String msg = localStrings.getString("enterprise.deployment.phasing.deploymentservice.rollbackexception");
                sLogger.log(Level.INFO, msg, rollbackException);
            }
        }
    }
}

