/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.appserv.management.deploy.DeploymentProgress;
import com.sun.appserv.management.deploy.DeploymentProgressImpl;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeployerFactory;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.management.deploy.DeploymentCallback;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class J2EECPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(J2EECPhase.class);

    public J2EECPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "J2EEC";
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        boolean wasUnRegistered = false;
        String type = null;
        boolean isApp = false;
        boolean isRedeploy = false;
        int actionCode = -1;
        String targetName = null;
        DeploymentTarget target = null;
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        DeploymentStatus status = phaseCtx.getDeploymentStatus();
        Deployer deployer = null;
        try {
            DeploymentCallback callback = req.getDeploymentCallback();
            if (callback != null) {
                boolean percent = false;
                DeploymentProgressImpl progress = new DeploymentProgressImpl((byte)(percent ? 1 : 0), "deployment started", null);
                callback.deploymentProgress((DeploymentProgress)progress);
            }
            req.setCurrentDeploymentStatus(status);
            deployer = DeployerFactory.getDeployer(req);
            if (req.isApplication()) {
                isApp = true;
            }
            deployer.doRequestPrepare();
            if (req.isReDeploy()) {
                isRedeploy = true;
                if (AppVerification.doInstrument()) {
                    AppVerification.getInstrumentLogger().handleChangeInDeployment();
                }
            }
            if (isRedeploy && (target = (DeploymentTarget)req.getTarget()) != null && !target.getName().equals("domain")) {
                targetName = target.getName();
                if (isApp) {
                    type = null;
                    actionCode = 2;
                } else {
                    type = DeploymentServiceUtils.getModuleTypeString(req.getType());
                    actionCode = 5;
                }
                DeploymentServiceUtils.multicastEvent(actionCode, req.getName(), type, req.getCascade(), req.isForced(), targetName);
                wasUnRegistered = true;
            }
            deployer.doRequestFinish();
            DeploymentServiceUtils.checkAbort(req.getName());
            if (isRedeploy) {
                DeploymentServiceUtils.removeFromConfig(req.getName(), req.getType());
            }
            DeploymentServiceUtils.addToConfig(req);
            wasUnRegistered = false;
            deployer.cleanup();
            status.setStageStatus(2);
            sLogger.log(Level.INFO, "deployed with moduleid = " + req.getName());
            DeploymentStatus mainStatus = status.getMainStatus();
            mainStatus.addProperty("moduleid", req.getName());
            mainStatus.addProperty("ModuleID", req.getName());
            if (callback != null) {
                int percent = 100;
                DeploymentProgressImpl progress2 = new DeploymentProgressImpl((byte)percent, "deployment finished", null);
                callback.deploymentProgress((DeploymentProgress)progress2);
            }
        }
        catch (Throwable t) {
            String msg = localStrings.getString("enterprise.deployment.phasing.j2eec.error");
            try {
                if (target == null) {
                    if (deployer != null) {
                        deployer.removePolicy();
                    }
                    DeploymentServiceUtils.removeFromConfig(req.getName(), req.getType());
                }
            }
            catch (Exception eee) {
                // empty catch block
            }
            if (isRedeploy && wasUnRegistered && t instanceof IASDeploymentException && req.getReRegisterOnFailure()) {
                actionCode = isApp ? 1 : 4;
                try {
                    DeploymentServiceUtils.multicastEvent(actionCode, req.getName(), type, req.getCascade(), req.isForced(), targetName);
                }
                catch (Throwable t2) {
                    msg = msg + t2;
                }
            }
            sLogger.log(Level.SEVERE, msg, t);
            status.setStageStatus(0);
            if (t instanceof Serializable) {
                status.setStageException(t);
            } else {
                sLogger.severe(localStrings.getString("enterprise.deployment.phasing.exception_notserializable", t.getClass()));
                sLogger.severe(localStrings.getString("enterprise.deployment.phasing.exception_notforwarded", t.getMessage()));
            }
            status.setStageStatusMessage(t.getMessage());
        }
    }

    protected DeploymentEvent getPrePhaseEvent(DeploymentEventInfo info) {
        return new DeploymentEvent(1, info);
    }

    protected DeploymentEvent getPostPhaseEvent(DeploymentEventInfo info) {
        return new DeploymentEvent(2, info);
    }
}

