/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.util.i18n.StringManager;

public class ApplicationReferenceHelper
implements IAdminConstants {
    private static final StringManager _strMgr = StringManager.getManager(ApplicationReferenceHelper.class);
    private ConfigContext _configContext = null;

    public ApplicationReferenceHelper(ConfigContext configContext) {
        this._configContext = configContext;
    }

    private ConfigContext getConfigContext() {
        return this._configContext;
    }

    private void addApplicationReferenceToCluster(Cluster cluster, boolean enabled, String virtualServers, String referenceName) throws ConfigException {
        ApplicationRef ref = cluster.getApplicationRefByRef(referenceName);
        if (ref != null) {
            throw new ConfigException(_strMgr.getString("clusterApplicationRefAlreadyExists", referenceName, cluster.getName()));
        }
        ref = new ApplicationRef();
        ref.setEnabled(enabled);
        ref.setRef(referenceName);
        ref.setVirtualServers(virtualServers);
        cluster.addApplicationRef(ref, true);
    }

    private void addApplicationReferenceToClusteredServers(Cluster cluster, Server[] servers, boolean enabled, String virtualServers, String referenceName) throws ConfigException {
        for (int i = 0; i < servers.length; ++i) {
            ApplicationRef ref = servers[i].getApplicationRefByRef(referenceName);
            if (ref != null) {
                throw new ConfigException(_strMgr.getString("clusterApplicationRefInconsistency", referenceName, cluster.getName(), servers[i].getName()));
            }
            this.addApplicationReferenceToServer(servers[i], enabled, virtualServers, referenceName);
        }
    }

    private void addApplicationReferenceToServer(Server server, boolean enabled, String virtualServers, String referenceName) throws ConfigException {
        ApplicationRef ref = server.getApplicationRefByRef(referenceName);
        if (ref != null) {
            throw new ConfigException(_strMgr.getString("serverApplicationRefAlreadyExists", referenceName, server.getName()));
        }
        ref = new ApplicationRef();
        ref.setEnabled(enabled);
        ref.setRef(referenceName);
        ref.setVirtualServers(virtualServers);
        server.addApplicationRef(ref, true);
    }

    protected String getApplicationType(String appName) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        Domain domain = ConfigAPIHelper.getDomainConfigBean(configContext);
        Applications applications = domain.getApplications();
        if (applications.getAppclientModuleByName(appName) != null) {
            return ServerTags.APPCLIENT_MODULE;
        }
        if (applications.getConnectorModuleByName(appName) != null) {
            return ServerTags.CONNECTOR_MODULE;
        }
        if (applications.getEjbModuleByName(appName) != null) {
            return ServerTags.EJB_MODULE;
        }
        if (applications.getJ2eeApplicationByName(appName) != null) {
            return ServerTags.J2EE_APPLICATION;
        }
        if (applications.getLifecycleModuleByName(appName) != null) {
            return ServerTags.LIFECYCLE_MODULE;
        }
        if (applications.getWebModuleByName(appName) != null) {
            return ServerTags.WEB_MODULE;
        }
        throw new ConfigException(_strMgr.getString("applicationDoesNotExist", appName));
    }

    public void createApplicationReference(TargetType[] validTypes, String targetName, boolean enabled, String virtualServers, String referenceName) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        String type = this.getApplicationType(referenceName);
        Target target = TargetBuilder.INSTANCE.createTarget(validTypes, targetName, configContext);
        if (target.getType() == TargetType.CLUSTER) {
            Cluster cluster = ClusterHelper.getClusterByName(configContext, target.getName());
            this.addApplicationReferenceToCluster(cluster, enabled, virtualServers, referenceName);
            Server[] servers = ServerHelper.getServersInCluster(configContext, target.getName());
            this.addApplicationReferenceToClusteredServers(cluster, servers, enabled, virtualServers, referenceName);
        } else if (target.getType() == TargetType.SERVER || target.getType() == TargetType.DAS) {
            Server server = ServerHelper.getServerByName(configContext, target.getName());
            this.addApplicationReferenceToServer(server, enabled, virtualServers, referenceName);
        } else {
            throw new ConfigException(_strMgr.getString("invalidClusterOrServerTarget", target.getName()));
        }
    }

    private void deleteApplicationReferenceFromCluster(Cluster cluster, String referenceName) throws ConfigException {
        ApplicationRef ref = cluster.getApplicationRefByRef(referenceName);
        if (ref == null) {
            throw new ConfigException(_strMgr.getString("clusterApplicationRefDoesNotExist", cluster.getName(), referenceName));
        }
        cluster.removeApplicationRef(ref, true);
    }

    private void deleteApplicationReferenceFromClusteredServers(Cluster cluster, Server[] servers, String referenceName) throws ConfigException {
        for (int i = 0; i < servers.length; ++i) {
            ApplicationRef ref = servers[i].getApplicationRefByRef(referenceName);
            if (ref == null) {
                throw new ConfigException(_strMgr.getString("clusterApplicationRefInconsistency", referenceName, cluster.getName(), servers[i].getName()));
            }
            this.deleteApplicationReferenceFromServer(servers[i], referenceName);
        }
    }

    private void deleteApplicationReferenceFromServer(Server server, String referenceName) throws ConfigException {
        ApplicationRef ref = server.getApplicationRefByRef(referenceName);
        if (ref == null) {
            throw new ConfigException(_strMgr.getString("serverApplicationRefDoesNotExist", server.getName(), referenceName));
        }
        server.removeApplicationRef(ref, true);
    }

    public void deleteApplicationReference(TargetType[] validTypes, String targetName, String referenceName) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        String type = this.getApplicationType(referenceName);
        Target target = TargetBuilder.INSTANCE.createTarget(validTypes, targetName, configContext);
        if (target.getType() == TargetType.SERVER || target.getType() == TargetType.DAS) {
            Server server = ServerHelper.getServerByName(configContext, targetName);
            this.deleteApplicationReferenceFromServer(server, referenceName);
        } else if (target.getType() == TargetType.CLUSTER) {
            Cluster cluster = ClusterHelper.getClusterByName(configContext, targetName);
            this.deleteApplicationReferenceFromCluster(cluster, referenceName);
            Server[] servers = ServerHelper.getServersInCluster(configContext, targetName);
            this.deleteApplicationReferenceFromClusteredServers(cluster, servers, referenceName);
        } else {
            throw new ConfigException(_strMgr.getString("invalidClusterOrServerTarget", targetName));
        }
    }
}

