/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.web;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.web.CacheHelperNode;
import com.sun.enterprise.deployment.node.runtime.web.CacheMappingNode;
import com.sun.enterprise.deployment.node.runtime.web.WebPropertyNode;
import com.sun.enterprise.deployment.node.runtime.web.WebRuntimeNode;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.runtime.web.Cache;
import com.sun.enterprise.deployment.runtime.web.CacheHelper;
import com.sun.enterprise.deployment.runtime.web.CacheMapping;
import com.sun.enterprise.deployment.runtime.web.DefaultHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CacheNode
extends WebRuntimeNode {
    public CacheNode() {
        this.registerElementHandler(new XMLElement("cache-helper"), CacheHelperNode.class, "addNewCacheHelper");
        this.registerElementHandler(new XMLElement("default-helper"), WebPropertyNode.class, "setDefaultHelper");
        this.registerElementHandler(new XMLElement("property"), WebPropertyNode.class, "addWebProperty");
        this.registerElementHandler(new XMLElement("cache-mapping"), CacheMappingNode.class, "addNewCacheMapping");
    }

    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        RuntimeDescriptor descriptor = this.getRuntimeDescriptor();
        if (descriptor == null) {
            throw new RuntimeException("Trying to set values on a null descriptor");
        }
        if (attributeName.getQName().equals("max-entries")) {
            descriptor.setAttributeValue("MaxEntries", value);
            return true;
        }
        if (attributeName.getQName().equals("timeout-in-seconds")) {
            descriptor.setAttributeValue("TimeoutInSeconds", value);
            return true;
        }
        if (attributeName.getQName().equals("enabled")) {
            descriptor.setAttributeValue("Enabled", value);
            return true;
        }
        return false;
    }

    public Node writeDescriptor(Node parent, String nodeName, Cache descriptor) {
        Element cache = (Element)super.writeDescriptor(parent, nodeName, descriptor);
        CacheHelper[] cacheHelpers = descriptor.getCacheHelper();
        if (cacheHelpers != null && cacheHelpers.length > 0) {
            CacheHelperNode chn = new CacheHelperNode();
            for (int i = 0; i < cacheHelpers.length; ++i) {
                chn.writeDescriptor((Node)cache, "cache-helper", cacheHelpers[i]);
            }
        }
        WebPropertyNode wpn = new WebPropertyNode();
        DefaultHelper dh = descriptor.getDefaultHelper();
        if (dh != null && dh.getWebProperty() != null) {
            Element dhn = CacheNode.appendChild(cache, "default-helper");
            wpn.writeDescriptor((Node)dhn, "property", dh.getWebProperty());
        }
        wpn.writeDescriptor((Node)cache, "property", descriptor.getWebProperty());
        CacheMapping[] mappings = descriptor.getCacheMapping();
        if (mappings != null && mappings.length > 0) {
            CacheMappingNode cmn = new CacheMappingNode();
            for (int i = 0; i < mappings.length; ++i) {
                cmn.writeDescriptor((Node)cache, "cache-mapping", mappings[i]);
            }
        }
        CacheNode.setAttribute(cache, "max-entries", descriptor.getAttributeValue("MaxEntries"));
        CacheNode.setAttribute(cache, "timeout-in-seconds", descriptor.getAttributeValue("TimeoutInSeconds"));
        CacheNode.setAttribute(cache, "enabled", descriptor.getAttributeValue("Enabled"));
        return cache;
    }
}

