/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.application;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RoleMappingNode;
import com.sun.enterprise.deployment.node.runtime.RuntimeBundleNode;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ApplicationRuntimeNode
extends RuntimeBundleNode {
    private Application descriptor = null;
    private String currentWebUri = null;

    public ApplicationRuntimeNode(Application descriptor) {
        super(descriptor);
        this.descriptor = descriptor;
    }

    protected void Init() {
        super.Init();
        this.registerElementHandler(new XMLElement("security-role-mapping"), RoleMappingNode.class);
    }

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 J2EE Application 1.3//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-application_1_4-0.dtd");
        publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application_1_4-0.dtd");
        if (!ApplicationRuntimeNode.restrictDTDDeclarations()) {
            publicIDToDTD.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 J2EE Application 1.4//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-application_1_4-0.dtd");
        }
        return "sun-application";
    }

    protected XMLElement getXMLRootTag() {
        return new XMLElement("sun-application");
    }

    public String getDocType() {
        return "-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN";
    }

    public String getSystemID() {
        return "http://www.sun.com/software/appserver/dtds/sun-application_1_4-0.dtd";
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("realm", "setRealm");
        return table;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElementValue(XMLElement element, String value) {
        if (element.getQName().equals("pass-by-reference")) {
            this.descriptor.setPassByReference("true".equalsIgnoreCase(value));
            return;
        } else if (element.getQName().equals("unique-id")) {
            this.descriptor.setUniqueId(Long.parseLong(value));
            return;
        } else if (element.getQName().equals("web-uri")) {
            this.currentWebUri = value;
            return;
        } else if (element.getQName().equals("context-root")) {
            if (this.currentWebUri == null) throw new RuntimeException("No uri provided for this context-root " + value);
            ModuleDescriptor md = this.descriptor.getModuleDescriptorByUri(this.currentWebUri);
            if (md == null) {
                throw new RuntimeException("No bundle in application with uri " + this.currentWebUri);
            }
            this.currentWebUri = null;
            if (!md.getModuleType().equals(ModuleType.WAR)) throw new RuntimeException(this.currentWebUri + " uri does not point to a web bundle");
            md.setContextRoot(value);
            return;
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        if (!(descriptor instanceof Application)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        Application application = (Application)descriptor;
        Node appNode = super.writeDescriptor(parent, nodeName, descriptor);
        Iterator modules = application.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor module = (ModuleDescriptor)modules.next();
            if (!module.getModuleType().equals(ModuleType.WAR)) continue;
            Element web = ApplicationRuntimeNode.appendChild(appNode, "web");
            ApplicationRuntimeNode.appendTextChild((Node)web, "web-uri", module.getArchiveUri());
            ApplicationRuntimeNode.appendTextChild((Node)web, "context-root", module.getContextRoot());
        }
        if (application.isPassByReferenceDefined()) {
            ApplicationRuntimeNode.appendTextChild(appNode, "pass-by-reference", String.valueOf(application.getPassByReference()));
        }
        ApplicationRuntimeNode.appendTextChild(appNode, "unique-id", String.valueOf(application.getUniqueId()));
        SecurityRoleMapper rm = application.getRoleMapper();
        if (rm != null) {
            RoleMappingNode rmNode = new RoleMappingNode();
            rmNode.writeDescriptor(appNode, "security-role-mapping", rm);
        }
        ApplicationRuntimeNode.appendTextChild(appNode, "realm", application.getRealm());
        return appNode;
    }
}

