/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.web.WebBundleRuntimeNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class WebServiceRuntimeNode
extends DeploymentDescriptorNode {
    private WebService descriptor;

    public Object getDescriptor() {
        return this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("webservice-description-name".equals(element.getQName())) {
            BundleDescriptor parent = this.getParentNode() instanceof WebBundleRuntimeNode ? ((WebBundleRuntimeNode)this.getParentNode()).getWebBundleDescriptor() : (BundleDescriptor)this.getParentNode().getDescriptor();
            WebServicesDescriptor webServices = parent.getWebServices();
            this.descriptor = webServices.getWebServiceByName(value);
        } else if ("wsdl-publish-location".equals(element.getQName())) {
            if (this.descriptor == null) {
                DOLUtils.getDefaultLogger().info("Warning : WebService descriptor is null for final wsdl url=" + value);
                return;
            }
            try {
                URL url = new URL(value);
                this.descriptor.setClientPublishUrl(url);
            }
            catch (MalformedURLException mue) {
                DOLUtils.getDefaultLogger().log(Level.INFO, "Warning : Invalid final wsdl url=" + value, mue);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebService webService) {
        Node webServiceNode = super.writeDescriptor(parent, nodeName, webService);
        WebServiceRuntimeNode.appendTextChild(webServiceNode, "webservice-description-name", webService.getWebServiceName());
        if (webService.hasClientPublishUrl()) {
            URL url = webService.getClientPublishUrl();
            WebServiceRuntimeNode.appendTextChild(webServiceNode, "wsdl-publish-location", url.toExternalForm());
        }
        return webServiceNode;
    }

    public void writeWebServiceRuntimeInfo(Node parent, BundleDescriptor bundle) {
        WebServicesDescriptor webServices = bundle.getWebServices();
        if (webServices != null) {
            Iterator iter = webServices.getWebServices().iterator();
            while (iter.hasNext()) {
                WebService next = (WebService)iter.next();
                if (!next.hasClientPublishUrl()) continue;
                this.writeDescriptor(parent, "webservice-description", next);
            }
        }
    }
}

