/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.types.RoleMappingContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Enumeration;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RoleMappingNode
extends DeploymentDescriptorNode {
    SecurityRoleMapper rm = null;
    Role role = null;

    public Object getDescriptor() {
        if (this.rm == null) {
            Application app;
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof BundleDescriptor && ((BundleDescriptor)parentDesc).getApplication() != null && (parentDesc = ((BundleDescriptor)parentDesc).getApplication()) != null && !(app = (Application)parentDesc).isVirtual()) {
                return null;
            }
            if (parentDesc instanceof RoleMappingContainer) {
                this.rm = ((RoleMappingContainer)parentDesc).getRoleMapper();
            }
        }
        return this.rm;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("role-name".equals(element.getQName())) {
            this.role = new Role(value);
            return;
        }
        if (this.getDescriptor() == null) {
            DOLUtils.getDefaultLogger().fine("In " + this.getXMLPath() + " node, descriptor is null");
            return;
        }
        if ("principal-name".equals(element.getQName())) {
            if (this.getDescriptor() == null || this.role == null) {
                throw new RuntimeException("Invalid security-role-mapping");
            }
            PrincipalImpl principal = new PrincipalImpl(value);
            this.rm.assignRole(principal, this.role);
        } else if ("group-name".equals(element.getQName())) {
            if (this.getDescriptor() == null || this.role == null) {
                throw new RuntimeException("Invalid security-role-mapping");
            }
            Group group = new Group(value);
            this.rm.assignRole(group, this.role);
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, SecurityRoleMapper descriptor) {
        Iterator roles = descriptor.getRoles();
        if (!roles.hasNext()) {
            return null;
        }
        while (roles.hasNext()) {
            Element roleMapping = RoleMappingNode.appendChild(parent, nodeName);
            Object o = roles.next();
            Role nextRole = o instanceof Role ? (Role)o : new Role((String)o);
            RoleMappingNode.appendTextChild((Node)roleMapping, "role-name", nextRole.getName());
            Enumeration principals = descriptor.getUsersAssignedTo(nextRole);
            while (principals.hasMoreElements()) {
                PrincipalImpl principal = (PrincipalImpl)principals.nextElement();
                RoleMappingNode.appendTextChild((Node)roleMapping, "principal-name", principal.getName());
            }
            Enumeration groups = descriptor.getGroupsAssignedTo(nextRole);
            while (groups.hasMoreElements()) {
                Group group = (Group)groups.nextElement();
                RoleMappingNode.appendTextChild((Node)roleMapping, "group-name", group.getName());
            }
        }
        return null;
    }
}

