/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.WebServiceHandlerNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebServiceEndpointNode
extends DisplayableComponentNode {
    private static final XMLElement tag = new XMLElement("port-component");

    public WebServiceEndpointNode() {
        this.registerElementHandler(new XMLElement("handler"), WebServiceHandlerNode.class, "addHandler");
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("port-component-name", "setEndpointName");
        table.put("service-endpoint-interface", "setServiceEndpointInterface");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        String elementName = element.getQName();
        WebServiceEndpoint endpoint = (WebServiceEndpoint)this.getDescriptor();
        if ("ejb-link".equals(elementName)) {
            endpoint.setEjbLink(value);
        } else if ("servlet-link".equals(elementName)) {
            endpoint.setWebComponentLink(value);
        } else if ("wsdl-port".equals(elementName)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{prefix, value});
            } else {
                QName wsdlPort = new QName(namespaceUri, localPart);
                endpoint.setWsdlPort(wsdlPort, prefix);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, WebServiceEndpoint descriptor) {
        Element linkNode;
        Node wseNode = super.writeDescriptor(parent, nodeName, descriptor);
        this.writeDisplayableComponentInfo(wseNode, descriptor);
        WebServiceEndpointNode.appendTextChild(wseNode, "port-component-name", descriptor.getEndpointName());
        QName wsdlPort = descriptor.getWsdlPort();
        this.appendQNameChild("wsdl-port", wseNode, wsdlPort.getNamespaceURI(), wsdlPort.getLocalPart(), descriptor.getWsdlPortNamespacePrefix());
        WebServiceEndpointNode.appendTextChild(wseNode, "service-endpoint-interface", descriptor.getServiceEndpointInterface());
        if (descriptor.implementedByWebComponent()) {
            linkNode = WebServiceEndpointNode.appendChild(wseNode, "service-impl-bean");
            WebServiceEndpointNode.appendTextChild((Node)linkNode, "servlet-link", descriptor.getWebComponentLink());
        } else if (descriptor.implementedByEjbComponent()) {
            linkNode = WebServiceEndpointNode.appendChild(wseNode, "service-impl-bean");
            WebServiceEndpointNode.appendTextChild((Node)linkNode, "ejb-link", descriptor.getEjbLink());
        } else {
            DOLUtils.getDefaultLogger().log(Level.INFO, "Warning : Web service endpoint " + descriptor.getEndpointName() + " is not tied to a component");
        }
        WebServiceHandlerNode handlerNode = new WebServiceHandlerNode();
        handlerNode.writeWebServiceHandlers(wseNode, descriptor.getHandlerChain());
        return wseNode;
    }
}

