/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.ModuleNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.SecurityRoleNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class ApplicationNode
extends BundleNode
implements RootXMLNode {
    public static final String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    public static final String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    public static final String SYSTEM_ID = "http://java.sun.com/dtd/application_1_3.dtd";
    public static final String SYSTEM_ID_12 = "http://java.sun.com/dtd/application_1_2.dtd";
    public static final String SCHEMA_ID = "application_1_4.xsd";
    public static final String SPEC_VERSION = "1.4";
    public static final XMLElement tag = new XMLElement("application");
    private Application descriptor;

    public static String registerBundle(Map publicIDToDTD) {
        publicIDToDTD.put(PUBLIC_DTD_ID, SYSTEM_ID);
        publicIDToDTD.put(PUBLIC_DTD_ID_12, SYSTEM_ID_12);
        return tag.getQName();
    }

    public ApplicationNode() {
        this.registerElementHandler(new XMLElement("module"), ModuleNode.class, "addModule");
        this.registerElementHandler(new XMLElement("security-role"), SecurityRoleNode.class, "addAppRole");
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof EjbBundleDescriptor) {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("In  " + this.toString() + " adding descriptor " + newDescriptor);
            }
            this.descriptor.addEjbBundleDescriptor((EjbBundleDescriptor)newDescriptor);
        } else if (newDescriptor instanceof WebBundleDescriptor) {
            DOLUtils.getDefaultLogger().fine("In  " + this.toString() + " adding web descriptor " + newDescriptor);
            this.descriptor.addWebBundleDescriptor((WebBundleDescriptor)newDescriptor);
        }
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (Application)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    public String getDocType() {
        return null;
    }

    public String getSystemID() {
        return SCHEMA_ID;
    }

    public Node writeDescriptor(Node parent, Descriptor descriptor) {
        if (!(descriptor instanceof Application)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        Application application = (Application)descriptor;
        Node appNode = super.writeDescriptor(parent, application);
        ModuleNode moduleNode = new ModuleNode();
        Iterator modules = application.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor next = (ModuleDescriptor)modules.next();
            moduleNode.writeDescriptor(appNode, "module", next);
        }
        return appNode;
    }

    public String getSpecVersion() {
        return SPEC_VERSION;
    }
}

