/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.io;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.node.J2EEDocumentBuilder;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DeploymentDescriptorFile {
    public static final String FULL_VALIDATION = "full";
    public static final String PARSING_VALIDATION = "parsing";
    private boolean xmlValidation = true;
    private String validationLevel = "parsing";
    private String errorReportingString = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentDescriptorFile.class);

    public SAXParser getSAXParser() {
        return this.getSAXParser(false);
    }

    public SAXParser getSAXParser(boolean validating) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(validating);
            if (spf.getClass().getName().indexOf("xerces") != -1) {
                spf.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            } else {
                DOLUtils.getDefaultLogger().log(Level.WARNING, "modify your java command line to include the -Djava.endorsed.dirs option");
            }
            try {
                spf.setFeature("http://apache.org/xml/features/validation/schema", validating);
                SAXParser sp = spf.newSAXParser();
                String path = this.getDefaultSchemaSource();
                if (path != null) {
                    sp.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", path);
                }
                sp.getXMLReader().setFeature("http://apache.org/xml/features/validation/dynamic", validating);
                return sp;
            }
            catch (SAXNotRecognizedException x) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "INFO: JAXP SAXParser property not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "Check to see if parser conforms to JAXP 1.2 spec.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{e.getMessage()});
        }
        return null;
    }

    public DocumentBuilder getDocumentBuilder(boolean validating) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(validating);
            try {
                String path = this.getDefaultSchemaSource();
                if (path != null) {
                    dbf.setAttribute("http://apache.org/xml/properties/schema/external-schemaLocation", path);
                }
                return dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException x) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "Error: JAXP DOMParser property not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "Check to see if parser conforms to JAXP 1.2 spec.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{e.getMessage()});
        }
        return null;
    }

    public Descriptor read(InputStream is) throws IOException, SAXParseException {
        return this.read(null, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptor read(Descriptor descriptor, File in) throws IOException, SAXParseException {
        FileInputStream fis = new FileInputStream(in);
        try {
            Descriptor descriptor2 = this.read(descriptor, fis);
            return descriptor2;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptor read(Descriptor descriptor, AbstractArchive in) throws IOException, SAXParseException {
        InputStream is = in.getEntry(this.getDeploymentDescriptorPath());
        try {
            Descriptor descriptor2 = this.read(descriptor, is);
            return descriptor2;
        }
        finally {
            is.close();
        }
    }

    public Descriptor read(Descriptor descriptor, InputStream is) throws IOException, SAXParseException {
        Object topDesc;
        String errorReporting = localStrings.getLocalString("enterprise.deployment.io.errorcontext", "archive {0} and deployment descriptor file {1}", new Object[]{this.errorReportingString, this.getDeploymentDescriptorPath()});
        SAXParser sp = this.getSAXParser(this.getXMLValidation());
        SaxParserHandler dh = new SaxParserHandler();
        if (this.validationLevel.equals(FULL_VALIDATION)) {
            dh.setStopOnError(true);
        }
        if (descriptor != null) {
            dh.setTopNode(this.getRootXMLNode(descriptor));
        }
        dh.setErrorReportingString(errorReporting);
        InputSource input = new InputSource(is);
        try {
            sp.parse(input, (DefaultHandler)dh);
        }
        catch (SAXParseException e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{e.getMessage()});
            throw e;
        }
        catch (SAXException e) {
            if (e.getException() != null) {
                e.getException().printStackTrace();
            }
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{e.getMessage()});
            return null;
        }
        catch (IOException e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError", new Object[]{e.getMessage()});
            throw e;
        }
        if (dh.getTopNode() != null && (topDesc = dh.getTopNode().getDescriptor()) instanceof Descriptor) {
            return (Descriptor)topDesc;
        }
        return null;
    }

    public Document getDocument(Descriptor descriptor) {
        return J2EEDocumentBuilder.getDocument(descriptor, this.getRootXMLNode(descriptor));
    }

    public void write(Descriptor descriptor, OutputStream os) {
        J2EEDocumentBuilder.write(descriptor, this.getRootXMLNode(descriptor), os);
    }

    public void write(Descriptor descriptor, String path) throws IOException {
        String dir;
        String fileName = this.getDeploymentDescriptorPath();
        if (fileName.lastIndexOf(47) != -1) {
            dir = path + File.separator + fileName.substring(0, fileName.lastIndexOf(47));
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        } else {
            dir = path;
        }
        File dirs = new File(dir.replace('/', File.separatorChar));
        if (!dirs.exists()) {
            dirs.mkdirs();
        }
        File out = new File(dirs, fileName);
        this.write(descriptor, out);
    }

    public void write(Descriptor descriptor, File out) throws IOException {
        FileOutputStream fos = new FileOutputStream(out);
        this.write(descriptor, fos);
        fos.close();
    }

    public abstract String getDeploymentDescriptorPath();

    public abstract RootXMLNode getRootXMLNode(Descriptor var1);

    protected boolean getXMLValidation() {
        return this.xmlValidation;
    }

    public void setXMLValidation(boolean validate) {
        this.xmlValidation = validate;
    }

    public void setXMLValidationLevel(String level) {
        this.validationLevel = level;
    }

    public String getXMLValidationLevel() {
        return this.validationLevel;
    }

    public String getDefaultSchemaSource() {
        RootXMLNode node = this.getRootXMLNode(null);
        if (node != null) {
            return node.getSystemID();
        }
        return null;
    }

    public void setErrorReportingString(String s) {
        this.errorReportingString = s;
    }
}

