/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class DescriptorLoader
implements Runnable {
    private AbstractArchive moduleArchive = null;
    private AbstractArchive planArchive = null;
    private String moduleID = null;
    private ModuleType type = null;
    private Application app = null;
    private static Logger logger = null;

    public DescriptorLoader(AbstractArchive module, AbstractArchive plan, String id) {
        this.moduleArchive = module;
        this.planArchive = plan;
        this.moduleID = id;
    }

    public Application getLoadedDescriptors() {
        return this.app;
    }

    public ModuleType getModuleType() {
        return this.type;
    }

    public void run() {
        try {
            Archivist source = ArchivistFactory.getArchivistForArchive(this.moduleArchive);
            RootDeploymentDescriptor descriptor = null;
            descriptor = source.open(this.moduleArchive);
            source.readRuntimeDDFromDeploymentPlan(this.planArchive, descriptor);
            this.type = source.getModuleType();
            if (this.type.equals(ModuleType.EAR)) {
                this.app = (Application)descriptor;
            } else {
                ModuleDescriptor md = source.createModuleDescriptor((BundleDescriptor)descriptor);
                this.app = Application.createApplication(this.moduleID, md);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to load descriptor for " + this.moduleID);
            this.app = null;
        }
    }

    static {
        logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    }
}

