/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.enterprise.deployapi.SunTarget;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class DeploymentClientUtils {
    private static final String APPS_CONFIG_MBEAN = "com.sun.appserv:type=applications,category=config";

    public static final ModuleType mapXTypeToModuleType(String xType) {
        if ("X-J2EEApplicationConfig".equals(xType)) {
            return ModuleType.EAR;
        }
        if ("X-EJBModuleConfig".equals(xType)) {
            return ModuleType.EJB;
        }
        if ("X-RARModuleConfig".equals(xType)) {
            return ModuleType.RAR;
        }
        if ("X-WebModuleConfig".equals(xType)) {
            return ModuleType.WAR;
        }
        if ("X-AppClientModuleConfig".equals(xType)) {
            return ModuleType.CAR;
        }
        return null;
    }

    public static final String mapModuleTypeToXType(ModuleType moduleType) {
        if (ModuleType.EAR.equals(moduleType)) {
            return "X-J2EEApplicationConfig";
        }
        if (ModuleType.EJB.equals(moduleType)) {
            return "X-EJBModuleConfig";
        }
        if (ModuleType.RAR.equals(moduleType)) {
            return "X-RARModuleConfig";
        }
        if (ModuleType.WAR.equals(moduleType)) {
            return "X-WebModuleConfig";
        }
        if (ModuleType.CAR.equals(moduleType)) {
            return "X-AppClientModuleConfig";
        }
        return null;
    }

    public static final ModuleType getModuleType(MBeanServerConnection mbsc, String moduleID) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{moduleID};
            Integer modType = (Integer)mbsc.invoke(applicationsMBean, "getModuleType", params, signature);
            if (modType != null) {
                return ModuleType.getModuleType((int)modType);
            }
        }
        return null;
    }

    public static final com.sun.enterprise.deployment.backend.DeploymentStatus deleteApplicationReference(MBeanServerConnection mbsc, String moduleID, SunTarget target, Map options) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            Object[] params = new Object[]{target.getName(), moduleID, options};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "deleteApplicationReference", params, signature);
        }
        return null;
    }

    public static final com.sun.enterprise.deployment.backend.DeploymentStatus stopApplication(MBeanServerConnection mbsc, String moduleID, SunTarget target, Map options) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            Object[] params = new Object[]{moduleID, target.getName(), options};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "stop", params, signature);
        }
        return null;
    }

    public static final com.sun.enterprise.deployment.backend.DeploymentStatus createApplicationReference(MBeanServerConnection mbsc, String moduleID, SunTarget target, Map options) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            Object[] params = new Object[]{target.getName(), moduleID, options};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "createApplicationReference", params, signature);
        }
        return null;
    }

    public static final com.sun.enterprise.deployment.backend.DeploymentStatus startApplication(MBeanServerConnection mbsc, String moduleID, SunTarget target, Map options) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            Object[] params = new Object[]{moduleID, target.getName(), options};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "start", params, signature);
        }
        return null;
    }

    public static boolean isModuleDeployed(MBeanServerConnection mbsc, String moduleID) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{moduleID};
            Object result = mbsc.invoke(applicationsMBean, "getModuleType", params, signature);
            if (result != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLifecycleModule(MBeanServerConnection mbsc, String moduleID) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{moduleID};
            Boolean ret = (Boolean)mbsc.invoke(applicationsMBean, "isLifecycleModuleRegistered", params, signature);
            if (Boolean.TRUE.equals(ret)) {
                return true;
            }
        }
        return false;
    }

    public static com.sun.enterprise.deployment.backend.DeploymentStatus createLifecycleModuleReference(MBeanServerConnection mbsc, String moduleID, String target, Map options) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
            Object[] params = new Object[]{moduleID, target, options};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "createLifecycleModuleReference", params, signature);
        }
        return null;
    }

    public static com.sun.enterprise.deployment.backend.DeploymentStatus removeLifecycleModuleReference(MBeanServerConnection mbsc, String moduleID, String target) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{moduleID, target};
            return (com.sun.enterprise.deployment.backend.DeploymentStatus)mbsc.invoke(applicationsMBean, "removeLifecycleModuleReference", params, signature);
        }
        return null;
    }

    public static final void changeStateOfModule(MBeanServerConnection mbsc, String moduleID, String type, SunTarget target, boolean enable) throws Exception {
        if (mbsc != null) {
            ObjectName applicationsMBean = new ObjectName(APPS_CONFIG_MBEAN);
            Object[] params = new Object[]{moduleID, type, target.getName()};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            if (enable) {
                mbsc.invoke(applicationsMBean, "enable", params, signature);
            } else {
                mbsc.invoke(applicationsMBean, "disable", params, signature);
            }
        }
    }

    public static boolean isTargetListComplete(Map deployedTargets, SunTarget[] targetList) throws IOException {
        HashMap tmpMap = new HashMap();
        tmpMap.putAll(deployedTargets);
        for (int i = 0; i < targetList.length; ++i) {
            if (tmpMap.get(targetList[i].getName()) == null) continue;
            tmpMap.remove(targetList[i].getName());
        }
        return tmpMap.size() == 0;
    }

    public static boolean isNewTarget(Map deployedTargets, SunTarget[] targetList) throws IOException {
        if (targetList.length == 1 && "domain".equals(targetList[0].getName())) {
            return false;
        }
        if (deployedTargets.size() != targetList.length) {
            return true;
        }
        HashMap tmpMap = new HashMap();
        tmpMap.putAll(deployedTargets);
        for (int i = 0; i < targetList.length; ++i) {
            if (tmpMap.get(targetList[i].getName()) != null) continue;
            return true;
        }
        return false;
    }

    public static Map getDeployedTargetList(ConnectionSource dasConnection, String id) throws IOException {
        DeployedItemRefConfig refProxy;
        StandaloneServerConfig tgtProxy;
        int i;
        HashMap<String, Boolean> deployedTargets = new HashMap<String, Boolean>();
        DomainConfig domainCfg = ProxyFactory.getInstance((ConnectionSource)dasConnection).getDomainRoot().getDomainConfig();
        Map serverProxies = domainCfg.getStandaloneServerConfigMap();
        Map clusterProxies = domainCfg.getClusterConfigMap();
        String[] serverNames = serverProxies.keySet().toArray(new String[0]);
        String[] clusterNames = clusterProxies.keySet().toArray(new String[0]);
        for (i = 0; i < serverNames.length; ++i) {
            tgtProxy = (StandaloneServerConfig)serverProxies.get(serverNames[i]);
            refProxy = (DeployedItemRefConfig)tgtProxy.getContainee("X-DeployedItemRefConfig", id);
            if (refProxy == null) continue;
            deployedTargets.put(serverNames[i], new Boolean(refProxy.getEnabled()));
        }
        for (i = 0; i < clusterNames.length; ++i) {
            tgtProxy = (ClusterConfig)clusterProxies.get(clusterNames[i]);
            refProxy = (DeployedItemRefConfig)tgtProxy.getContainee("X-DeployedItemRefConfig", id);
            if (refProxy == null) continue;
            deployedTargets.put(clusterNames[i], new Boolean(refProxy.getEnabled()));
        }
        return deployedTargets;
    }

    public static com.sun.enterprise.deployment.backend.DeploymentStatus getDeploymentStatusFromAdminStatus(DeploymentStatus stat) {
        com.sun.enterprise.deployment.backend.DeploymentStatus tmp = new com.sun.enterprise.deployment.backend.DeploymentStatus();
        tmp.setStageStatus(stat.getStageStatus());
        if (stat.getThrowable() != null) {
            tmp.setStageException(stat.getThrowable());
        }
        tmp.setStageDescription(stat.getStageDescription());
        tmp.setStageStatusMessage(stat.getStageStatusMessage());
        Iterator it = stat.getSubStages();
        while (it.hasNext()) {
            DeploymentStatus stageStatus = DeploymentSupport.mapToDeploymentStatus((Map)((Map)it.next()));
            tmp.addSubStage(DeploymentClientUtils.getDeploymentStatusFromAdminStatus(stageStatus));
        }
        return tmp;
    }
}

