/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.deploy.DeploymentProgress;
import com.sun.appserv.management.deploy.DeploymentSourceImpl;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.enterprise.deployapi.ProgressObjectImpl;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.MemoryMappedArchive;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.DescriptorLoader;
import com.sun.enterprise.deployment.client.RollBackAction;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.webservice.ClientWsdlPublisher;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.management.Notification;

public class DeployAction
extends ProgressObjectImpl {
    private DeploymentMgr deplMgr = null;
    private static int SLEEP_TIME = 100;
    private static long TIMEOUT_LOOPS = 1000000000 / SLEEP_TIME;
    private static StringManager localStrings = StringManager.getManager(DeployAction.class);

    public DeployAction(SunTarget[] targets) {
        super(targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object uploadArchive(AbstractArchive module) throws IOException {
        long totalSize = module.getArchiveSize();
        int chunkSize = 32768;
        Object uploadID = this.deplMgr.initiateFileUpload(totalSize);
        long remaining = totalSize;
        BufferedInputStream bis = null;
        try {
            if (module instanceof MemoryMappedArchive) {
                byte[] bytes = ((MemoryMappedArchive)module).getByteArray();
                bis = new BufferedInputStream(new ByteArrayInputStream(bytes));
            } else {
                bis = new BufferedInputStream(new FileInputStream(new File(module.getArchiveUri())));
            }
            while (remaining != 0L) {
                int actual = remaining < (long)chunkSize ? (int)remaining : chunkSize;
                byte[] bytes = new byte[actual];
                try {
                    bis.read(bytes);
                }
                catch (EOFException eof) {
                    break;
                }
                this.deplMgr.uploadBytes(uploadID, bytes);
                remaining -= (long)actual;
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
        return uploadID;
    }

    public void run() {
        ConnectionSource dasConnection = (ConnectionSource)this.args[0];
        AbstractArchive deployArchive = (AbstractArchive)this.args[1];
        AbstractArchive deployPlan = (AbstractArchive)this.args[2];
        Map deployOptions = (Map)this.args[3];
        SunTarget[] targetList = (SunTarget[])this.args[4];
        SunTarget domain = (SunTarget)this.args[5];
        boolean isLocalConnectionSource = (Boolean)this.args[6];
        Object archiveUploadID = null;
        Object planUploadID = null;
        Map deployedTargets = null;
        Object deployActionID = null;
        boolean isDirectoryDeploy = false;
        if (deployArchive == null) {
            this.setupForAbnormalExit("Archive to be deployed is not specified at all", domain);
            return;
        }
        if (deployArchive.getArchiveUri() != null) {
            File tmpFile = new File(deployArchive.getArchiveUri());
            if (!tmpFile.exists()) {
                this.setupForAbnormalExit("Unable to find the archive to be deployed in specified location", domain);
                return;
            }
            if (!tmpFile.canRead()) {
                this.setupForAbnormalExit("Archive to be deployed does not have read permission", domain);
                return;
            }
            if (tmpFile.isDirectory()) {
                isDirectoryDeploy = true;
            }
        }
        try {
            String moduleID = (String)deployOptions.get("X-DeploymentMgr.Name");
            if ("false".equals(deployOptions.get("X-DeploymentMgr.Force")) && this.isModuleDeployed(dasConnection, moduleID)) {
                this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.deploy_error_module_exists"), domain);
                return;
            }
            this.deplMgr = ProxyFactory.getInstance((ConnectionSource)dasConnection).getDomainRoot().getDeploymentMgr();
            if (targetList.length == 1 && "stand_alone_server".equals(targetList[0].getTargetType()) && !"server".equals(targetList[0].getName())) {
                deployOptions.put("wsdlTargetHint", targetList[0].getName());
            }
            if ("true".equals(deployOptions.get("X-DeploymentMgr.Force")) && this.isModuleDeployed(dasConnection, moduleID)) {
                deployedTargets = DeploymentClientUtils.getDeployedTargetList(dasConnection, moduleID);
                if (DeploymentClientUtils.isNewTarget(deployedTargets, targetList)) {
                    this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.useCreateAppRef", moduleID), domain);
                }
                if (deployedTargets.size() > 0) {
                    if ("domain".equals(targetList[0].getName())) {
                        DeploymentFacility deploymentFacility = isLocalConnectionSource ? DeploymentFacilityFactory.getLocalDeploymentFacility() : DeploymentFacilityFactory.getDeploymentFacility();
                        deploymentFacility.connect(targetList[0].getConnectionInfo());
                        Set nameSet = deployedTargets.keySet();
                        String[] targetNames = nameSet.toArray(new String[nameSet.size()]);
                        Target[] targetList2 = deploymentFacility.createTargets(targetNames);
                        if (targetList2 == null) {
                            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.createTargetsFailed"), domain);
                            return;
                        }
                        targetList = new SunTarget[targetList2.length];
                        for (int ii = 0; ii < targetList2.length; ++ii) {
                            targetList[ii] = (SunTarget)targetList2[ii];
                        }
                    } else if (!DeploymentClientUtils.isTargetListComplete(deployedTargets, targetList)) {
                        this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.specifyAllTargets", moduleID, "redeploy"), domain);
                        return;
                    }
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.putAll(deployOptions);
                    RollBackAction undeplRollback = new RollBackAction(4, moduleID, deployOptions);
                    for (int i = 0; i < targetList.length; ++i) {
                        options.put("X-DeploymentMgr.Cascade", "true");
                        com.sun.enterprise.deployment.backend.DeploymentStatus stat = DeploymentClientUtils.stopApplication(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], options);
                        this.checkStatusAndAddStage(targetList[i], null, "While redeploying, trying to stop the application in target " + targetList[i].getName(), dasConnection, stat);
                        options.put("X-DeploymentMgr.Cascade", "false");
                        stat = DeploymentClientUtils.deleteApplicationReference(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], options);
                        if (!this.checkStatusAndAddStage(targetList[i], undeplRollback, "While redeploying, trying to remove reference for application in target " + targetList[i].getName(), dasConnection, stat)) {
                            return;
                        }
                        undeplRollback.addTarget(targetList[i], 3);
                    }
                }
            }
            deployActionID = this.deplMgr.initDeploy();
            HashMap<String, String> dupOptions = new HashMap<String, String>();
            dupOptions.putAll(deployOptions);
            dupOptions.put("X-DeploymentMgr.Enable", Boolean.TRUE.toString());
            if (!isDirectoryDeploy && !isLocalConnectionSource) {
                archiveUploadID = this.uploadArchive(deployArchive);
                if (deployPlan != null && deployPlan.getArchiveSize() != 0L) {
                    planUploadID = this.uploadArchive(deployPlan);
                }
                this.deplMgr.startDeploy(deployActionID, archiveUploadID, planUploadID, dupOptions);
            } else {
                if (isDirectoryDeploy && !this.isDomainLocal(domain)) {
                    this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.domainNotLocal"), domain);
                    return;
                }
                if (isDirectoryDeploy) {
                    dupOptions.put("directorydeployed", Boolean.TRUE.toString());
                }
                DeploymentSourceImpl archive = new DeploymentSourceImpl(deployArchive.getArchiveUri(), true, new String[1], new String[1], new String[1], new HashMap());
                this.deplMgr.startDeploy(deployActionID, archive.asMap(), archive.asMap(), dupOptions);
            }
            if (deployActionID == null) {
                this.setupForAbnormalExit("Unable to get deployment ID from the server", domain);
                return;
            }
            DescriptorLoader loadDD = new DescriptorLoader(deployArchive, deployPlan, moduleID);
            Thread loadDDThread = new Thread(loadDD);
            loadDDThread.start();
            boolean done = false;
            int waitLoopCount = 0;
            DeploymentStatus finalStatusFromMBean = null;
            do {
                Notification[] notifs = this.deplMgr.takeNotifications(deployActionID);
                for (int i = 0; i < notifs.length; ++i) {
                    Map notifType = (Map)notifs[i].getUserData();
                    if (notifType.get("X-DeploymentMgr.DeploymentCompletedStatus") != null) {
                        finalStatusFromMBean = DeploymentSupport.mapToDeploymentStatus((Map)this.deplMgr.getFinalDeploymentStatus(deployActionID));
                        done = true;
                        continue;
                    }
                    if (notifType.get("X-DeploymentMgr.DeploymentProgress") == null) continue;
                    DeploymentProgress prog = DeploymentSupport.mapToDeploymentProgress((Map)((Map)notifType.get("X-DeploymentMgr.DeploymentProgress")));
                    String progStr = prog.getDescription() + " : " + prog.getProgressPercent() + "%";
                    this.fireProgressEvent(StateType.RUNNING, progStr, domain);
                }
                if (!done) {
                    if ((long)waitLoopCount > TIMEOUT_LOOPS) {
                        this.setupForAbnormalExit("Deployment operation timed out waiting for deploy to complete", domain);
                        return;
                    }
                    try {
                        Thread.sleep(SLEEP_TIME);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                ++waitLoopCount;
            } while (!done);
            com.sun.enterprise.deployment.backend.DeploymentStatus tmp = DeploymentClientUtils.getDeploymentStatusFromAdminStatus(finalStatusFromMBean);
            if (!this.checkStatusAndAddStage(domain, null, "Deploying application in domain ", dasConnection, tmp)) {
                return;
            }
            RollBackAction rollback = new RollBackAction(1, moduleID, deployOptions);
            if (!"domain".equals(targetList[0].getName())) {
                for (int i = 0; i < targetList.length; ++i) {
                    if (deployedTargets != null) {
                        dupOptions.put("X-DeploymentMgr.Enable", deployedTargets.get(targetList[i].getName()).toString());
                    } else {
                        dupOptions.put("X-DeploymentMgr.Enable", (String)deployOptions.get("X-DeploymentMgr.Enable"));
                    }
                    com.sun.enterprise.deployment.backend.DeploymentStatus stat = DeploymentClientUtils.createApplicationReference(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], dupOptions);
                    if (!this.checkStatusAndAddStage(targetList[i], rollback, "Trying to create reference for application in target " + targetList[i].getName(), dasConnection, stat)) {
                        return;
                    }
                    rollback.addTarget(targetList[i], 1);
                    if (deployedTargets != null && Boolean.FALSE.equals(deployedTargets.get(targetList[i].getName()))) continue;
                    stat = DeploymentClientUtils.startApplication(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    if (!this.checkStatusAndAddStage(targetList[i], null, "Trying to start application in target " + targetList[i].getName(), dasConnection, stat)) continue;
                    rollback.addTarget(targetList[i], 2);
                }
            }
            loadDDThread.join((long)SLEEP_TIME * TIMEOUT_LOOPS);
            this.moduleType = loadDD.getModuleType();
            if (this.moduleType != null && !isLocalConnectionSource) {
                try {
                    ClientWsdlPublisher publisher = new ClientWsdlPublisher();
                    if (deployArchive instanceof MemoryMappedArchive) {
                        publisher.retrieveWsdlFiles(domain, moduleID, loadDD.getModuleType(), deployArchive, loadDD.getLoadedDescriptors());
                    } else {
                        publisher.retrieveWsdlFiles(domain, moduleID, loadDD.getModuleType(), deployArchive.getArchiveUri(), loadDD.getLoadedDescriptors());
                    }
                }
                catch (Exception wsdlEx) {
                    com.sun.enterprise.deployment.backend.DeploymentStatus newStatus = new com.sun.enterprise.deployment.backend.DeploymentStatus();
                    newStatus.setStageStatus(0);
                    newStatus.setStageStatusMessage(wsdlEx.getMessage());
                    newStatus.setStageException(wsdlEx);
                    this.checkStatusAndAddStage(domain, rollback, "Trying to publish WSDL ", dasConnection, newStatus);
                    this.setupForAbnormalExit("Received exception '" + wsdlEx.getMessage() + "' while publishing WSDL", domain);
                    return;
                }
            }
            this.initializeTargetModuleIDForAllServers(moduleID, loadDD.getLoadedDescriptors(), dasConnection.getMBeanServerConnection(false));
            this.setupForNormalExit("Deployment of application " + moduleID, domain);
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit("Deployment of application failed - " + ioex.getMessage(), domain);
            return;
        }
    }

    private boolean isModuleDeployed(ConnectionSource dasConnection, String moduleID) throws Exception {
        return DeploymentClientUtils.isModuleDeployed(dasConnection.getExistingMBeanServerConnection(), moduleID);
    }

    private boolean isDomainLocal(SunTarget domain) {
        if ("localhost".equalsIgnoreCase(domain.getHostName())) {
            return true;
        }
        try {
            InetAddress lh = InetAddress.getLocalHost();
            if (domain.getHostName().equalsIgnoreCase(lh.getCanonicalHostName())) {
                return true;
            }
            if (domain.getHostName().equalsIgnoreCase(lh.getHostName())) {
                return true;
            }
            if (domain.getHostName().equalsIgnoreCase(lh.getHostAddress())) {
                return true;
            }
        }
        catch (UnknownHostException ex) {
            return false;
        }
        return false;
    }
}

