/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.enterprise.deployapi.ProgressObjectImpl;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.deployment.client.RollBackAction;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;

public class ApplicationReferenceAction
extends ProgressObjectImpl {
    public ApplicationReferenceAction(SunTarget[] targets) {
        super(targets);
    }

    private void handleAppRefActionForLifeCycleModules(ConnectionSource dasConnection, SunTarget[] targetList, String id, CommandType cmd, Map options) {
        String action = CommandType.DISTRIBUTE.equals(cmd) ? "Creation" : "Removal";
        try {
            for (int i = 0; i < targetList.length; ++i) {
                DeploymentStatus stat = null;
                stat = CommandType.DISTRIBUTE.equals(cmd) ? DeploymentClientUtils.createLifecycleModuleReference(dasConnection.getExistingMBeanServerConnection(), id, targetList[i].getName(), options) : DeploymentClientUtils.removeLifecycleModuleReference(dasConnection.getExistingMBeanServerConnection(), id, targetList[i].getName());
                if (this.checkStatusAndAddStage(targetList[i], null, action + " of reference for lifecyclemodule in target " + targetList[i].getName(), dasConnection, stat)) continue;
                return;
            }
            this.setupForNormalExit(action + " of reference for lifecyclemodule in all targets ", targetList[0]);
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit(action + " of reference for lifecyclemodule failed : " + ioex.getMessage(), targetList[0]);
        }
    }

    public void run() {
        ConnectionSource dasConnection = (ConnectionSource)this.args[0];
        SunTarget[] targetList = (SunTarget[])this.args[1];
        String moduleID = (String)this.args[2];
        CommandType cmd = (CommandType)this.args[3];
        Map deployOptions = (Map)this.args[4];
        String action = CommandType.DISTRIBUTE.equals(cmd) ? "Creation" : "Removal";
        try {
            if (DeploymentClientUtils.isLifecycleModule(dasConnection.getExistingMBeanServerConnection(), moduleID)) {
                this.handleAppRefActionForLifeCycleModules(dasConnection, targetList, moduleID, cmd, deployOptions);
                return;
            }
            ArrayList<SunTargetModuleID> resultTargetModuleIDs = new ArrayList<SunTargetModuleID>();
            RollBackAction rollback = CommandType.DISTRIBUTE.equals(cmd) ? new RollBackAction(3, moduleID, deployOptions) : new RollBackAction(4, moduleID, deployOptions);
            for (int i = 0; i < targetList.length; ++i) {
                DeploymentStatus stat;
                if (CommandType.DISTRIBUTE.equals(cmd)) {
                    stat = DeploymentClientUtils.createApplicationReference(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    if (!this.checkStatusAndAddStage(targetList[i], rollback, "Creation of reference for application in target " + targetList[i].getName(), dasConnection, stat)) {
                        return;
                    }
                    rollback.addTarget(targetList[i], 1);
                    stat = DeploymentClientUtils.startApplication(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    if (this.checkStatusAndAddStage(targetList[i], null, "Starting of application in target " + targetList[i].getName(), dasConnection, stat)) {
                        rollback.addTarget(targetList[i], 2);
                    }
                } else {
                    deployOptions.put("X-DeploymentMgr.Force", "false");
                    stat = DeploymentClientUtils.stopApplication(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    this.checkStatusAndAddStage(targetList[i], null, "Stopping of application in target " + targetList[i].getName(), dasConnection, stat);
                    stat = DeploymentClientUtils.deleteApplicationReference(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    if (!this.checkStatusAndAddStage(targetList[i], rollback, "Removal of reference for application in target " + targetList[i].getName(), dasConnection, stat)) {
                        return;
                    }
                    rollback.addTarget(targetList[i], 3);
                }
                resultTargetModuleIDs.add(new SunTargetModuleID(moduleID, targetList[i]));
            }
            this.targetModuleIDs = new TargetModuleID[resultTargetModuleIDs.size()];
            this.targetModuleIDs = resultTargetModuleIDs.toArray(this.targetModuleIDs);
            this.setupForNormalExit(action + " of application reference in all targets", targetList[0]);
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit(action + " of application reference failed - " + ioex.getMessage(), targetList[0]);
            return;
        }
    }
}

