/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.backend.ContextRootChecker;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.JSPCompiler;
import com.sun.enterprise.deployment.backend.ModuleDeployer;
import com.sun.enterprise.deployment.backend.ModuleInfo;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import com.sun.web.security.WebSecurityManager;
import com.sun.web.security.WebSecurityManagerFactory;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

public class WebModuleDeployer
extends ModuleDeployer {
    private WebModulesManager webModulesMgr = null;
    private String oldRegisteredContextRoot = null;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    WebModuleDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    public void cleanup_internal() {
        try {
            if (this.request.isUnDeploy()) {
                this.liquidate();
            } else if (this.request.isReDeploy() && this.isArchive() && this.oldModuleDir != null) {
                FileUtils.whack(this.oldModuleDir);
            }
        }
        catch (Exception e) {
            this.logger.warning("Exception caught and ignored in cleanup_internal()");
        }
    }

    protected BaseManager createConfigManager(InstanceEnvironment ienv, ModuleEnvironment menv) throws IASDeploymentException, ConfigException {
        this.webModulesMgr = new WebModulesManager(ienv);
        return this.webModulesMgr;
    }

    protected void preDeploy() throws IASDeploymentException {
        try {
            if (!$assertionsDisabled && this.moduleDir == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !StringUtils.ok((String)this.moduleName)) {
                throw new AssertionError();
            }
            if (this.isRegistered()) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
                throw new IASDeploymentException(msg);
            }
            this.liquidateModuleDirAndStubsDirIfTheyHappenToExist();
            if (this.request.isDirectory()) {
                this.moduleInfo = new ModuleInfo(this.moduleDir, this.moduleName);
                this.moduleInfo.setType(DeployableObjectType.WEB);
            } else {
                this.moduleInfo = J2EEModuleExploder.explode(this.request.getFileSource().getFile(), this.moduleDir, this.moduleName, true);
            }
            this.xmlDir.mkdirs();
            this.runVerifier();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected List getModuleClasspath(Application application) throws IASDeploymentException {
        try {
            String location = this.request.getDeployedDirectory().getAbsolutePath();
            return EJBClassPathUtils.getWarClassPath(location, location);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void deploy() throws IASDeploymentException {
        try {
            String mLocation = this.moduleDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IASDeploymentException(e);
        }
        Application app = this.loadDescriptors();
        WebBundleDescriptor bundleDesc = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
        if (this.request.getContextRoot() == null || this.request.getContextRoot().trim().equals("")) {
            if (bundleDesc.getContextRoot() != null && !bundleDesc.getContextRoot().trim().equals("")) {
                this.request.setContextRoot(bundleDesc.getContextRoot());
            } else {
                this.request.setContextRoot(this.request.getDefaultContextRoot());
            }
        }
        this.verifyContextRoot();
        ZipItem[] clientStubs = this.runEJBC();
        try {
            if (this.request.getPrecompileJSP()) {
                long time = System.currentTimeMillis();
                JSPCompiler.compile(this.moduleDir, this.jspDir, bundleDesc);
                this.addJSPCTime(System.currentTimeMillis() - time);
            }
        }
        catch (IASDeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void preRedeploy() throws IASDeploymentException, ConfigException {
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !StringUtils.ok((String)this.moduleName)) {
            throw new AssertionError();
        }
        this.setOldDirs();
        if (this.request.isDirectory()) {
            this.moduleInfo = new ModuleInfo(this.moduleDir, this.moduleName);
            this.moduleInfo.setType(DeployableObjectType.WEB);
        } else {
            try {
                this.moduleInfo = J2EEModuleExploder.explode(this.request.getFileSource().getFile(), this.moduleDir, this.moduleName, true);
            }
            catch (IOException e) {
                throw new IASDeploymentException(e.toString(), e);
            }
        }
        this.xmlDir.mkdirs();
        this.runVerifier();
    }

    private void verifyContextRoot() throws IASDeploymentException {
        if (!$assertionsDisabled && this.webModulesMgr == null) {
            throw new AssertionError();
        }
        String cr = this.request.getContextRoot();
        if (cr == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.web_module_context_root_not_set");
            throw new IASDeploymentException(msg);
        }
        String[] contextRoots = new String[]{cr};
        ContextRootChecker checker = new ContextRootChecker(this.getInstanceEnv(), contextRoots, this.webModulesMgr, this.moduleName);
        checker.check();
    }

    protected boolean needsStubs() {
        return true;
    }

    protected boolean needsJSPs() {
        return true;
    }

    protected void generatePolicy() throws IASDeploymentException {
        try {
            if (this.webModulesMgr == null) {
                this.webModulesMgr = (WebModulesManager)this.createConfigManager(this.getInstanceEnv(), this.moduleEnv);
            }
            Application app = this.request.getDescriptor();
            WebBundleDescriptor wbd = (WebBundleDescriptor)app.getStandaloneBundleDescriptor();
            WebSecurityManagerFactory wsmf = null;
            wsmf = WebSecurityManagerFactory.getInstance();
            wsmf.newWebSecurityManager(wbd);
            if (this.request.isApplication()) {
                return;
            }
            String name = WebSecurityManager.getContextID(wbd);
            SecurityUtil.generatePolicyFile(name);
        }
        catch (IASDeploymentException iasde) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error");
            this.logger.log(Level.WARNING, msg, iasde);
            throw iasde;
        }
        catch (ConfigException ce) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error");
            this.logger.log(Level.WARNING, msg, ce);
            throw new IASDeploymentException(ce.toString());
        }
        catch (IASSecurityException iassec) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error");
            this.logger.log(Level.WARNING, msg, iassec);
            throw new IASDeploymentException(msg, iassec);
        }
    }

    public void removePolicy() throws IASDeploymentException {
        if (this.request.isApplication()) {
            return;
        }
        WebSecurityManagerFactory wsmf = WebSecurityManagerFactory.getInstance();
        String requestName = this.request.getName();
        Object[] name = wsmf.getAndRemoveContextIdForWebAppName(requestName);
        try {
            if (name != null && name[0] != null) {
                SecurityUtil.removePolicy((String)name[0]);
            }
        }
        catch (IASSecurityException ex) {
            String msg = localStrings.getString("enterprise.deployment.backend.remove_policy_error", name);
            this.logger.log(Level.WARNING, msg, ex);
            throw new IASDeploymentException(msg, ex);
        }
    }

    static {
        $assertionsDisabled = !WebModuleDeployer.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(WebModuleDeployer.class);
    }
}

