/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;

public class OptionalPkgDependency {
    private static Hashtable optionalPackageStore = new Hashtable();
    private static Set extDirJars = new LinkedHashSet();
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    static void resolveOptionalPkgDependency(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String elem = (String)iter.next();
            logger.fine("iter.next()..." + elem);
            OptionalPkgDependency.optionalPkgDependencyLogic(new File(elem));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean optionalPkgDependencyLogic(File file) {
        boolean dependencySatisfied;
        block35: {
            String extensionList;
            Manifest manifest;
            block34: {
                JarFile jarfile;
                block32: {
                    block30: {
                        dependencySatisfied = true;
                        if (!file.isFile()) break block35;
                        jarfile = null;
                        manifest = null;
                        extensionList = null;
                        jarfile = new JarFile(file);
                        if (jarfile != null) break block30;
                        boolean bl = dependencySatisfied;
                        Object var7_11 = null;
                        try {
                            if (jarfile != null) {
                                jarfile.close();
                            }
                        }
                        catch (IOException ioe2) {
                            logger.log(Level.WARNING, "OptionalPkgDependency : exception occurred ==> " + ioe2.toString());
                        }
                        return bl;
                    }
                    manifest = jarfile.getManifest();
                    if (manifest != null) break block32;
                    boolean bl = dependencySatisfied;
                    Object var7_12 = null;
                    try {
                        if (jarfile != null) {
                            jarfile.close();
                        }
                    }
                    catch (IOException ioe2) {
                        logger.log(Level.WARNING, "OptionalPkgDependency : exception occurred ==> " + ioe2.toString());
                    }
                    return bl;
                }
                extensionList = manifest.getMainAttributes().getValue(Attributes.Name.EXTENSION_LIST);
                logger.fine("extensionList..." + extensionList);
                Object var7_13 = null;
                try {
                    if (jarfile != null) {
                        jarfile.close();
                    }
                    break block34;
                }
                catch (IOException ioe2) {
                    logger.log(Level.WARNING, "OptionalPkgDependency : exception occurred ==> " + ioe2.toString());
                }
                break block34;
                {
                    catch (NullPointerException npe) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "OptionalPkgDependency : exception occurred ==> " + npe.toString());
                        }
                        var7_13 = null;
                        try {
                            if (jarfile != null) {
                                jarfile.close();
                            }
                            break block34;
                        }
                        catch (IOException ioe2) {
                            logger.log(Level.WARNING, "OptionalPkgDependency : exception occurred ==> " + ioe2.toString());
                        }
                        break block34;
                    }
                    catch (ZipException ze) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "OptionalPkgDependency : exception occurred ==> " + ze.toString());
                        }
                        var7_13 = null;
                        try {
                            if (jarfile != null) {
                                jarfile.close();
                            }
                            break block34;
                        }
                        catch (IOException ioe2) {
                            logger.log(Level.WARNING, "OptionalPkgDependency : exception occurred ==> " + ioe2.toString());
                        }
                        break block34;
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "OptionalPkgDependency : exception occurred ==> " + ioe.toString());
                        var7_13 = null;
                        try {
                            if (jarfile != null) {
                                jarfile.close();
                            }
                            break block34;
                        }
                        catch (IOException ioe2) {
                            logger.log(Level.WARNING, "OptionalPkgDependency : exception occurred ==> " + ioe2.toString());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_14 = null;
                    try {
                        if (jarfile != null) {
                            jarfile.close();
                        }
                    }
                    catch (IOException ioe2) {
                        logger.log(Level.WARNING, "OptionalPkgDependency : exception occurred ==> " + ioe2.toString());
                    }
                    throw throwable;
                }
            }
            if (extensionList == null) {
                return dependencySatisfied;
            }
            StringTokenizer st = new StringTokenizer(extensionList, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                String extName = manifest.getMainAttributes().getValue(token + "-" + Attributes.Name.EXTENSION_NAME);
                String specVersion = manifest.getMainAttributes().getValue(token + "-" + Attributes.Name.SPECIFICATION_VERSION);
                if (specVersion == null) {
                    specVersion = new String("");
                }
                if (!optionalPackageStore.containsKey(extName)) {
                    logger.log(Level.WARNING, "enterprise.deployment.backend.optionalpkg.dependency.notexist", new Object[]{extName, file.getName()});
                    dependencySatisfied = false;
                    continue;
                }
                if ((specVersion.equals("") || !optionalPackageStore.get(extName).toString().equals("")) && specVersion.equals(optionalPackageStore.get(extName).toString())) continue;
                logger.log(Level.WARNING, "enterprise.deployment.backend.optionalpkg.dependency.notexist", new Object[]{extName, file.getName()});
                dependencySatisfied = false;
            }
        }
        if (dependencySatisfied) {
            logger.log(Level.INFO, "enterprise.deployment.backend.optionalpkg.dependency.satisfied", new Object[]{file.getName()});
        }
        return dependencySatisfied;
    }

    public static void satisfyOptionalPackageDependencies() {
        String ext_dirStr = new String(System.getProperty("java.ext.dirs"));
        logger.fine("ext_dirStr..." + ext_dirStr);
        Vector<String> ext_dirs = new Vector<String>();
        StringTokenizer st = new StringTokenizer(ext_dirStr, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            logger.log(Level.FINE, "string tokens..." + next);
            ext_dirs.addElement(next);
        }
        for (int v = 0; v < ext_dirs.size(); ++v) {
            int i;
            File[] optionalPackages;
            File ext_dir = new File((String)ext_dirs.elementAt(v));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "extension dir..." + ext_dir);
            }
            if ((optionalPackages = ext_dir.listFiles()) == null) continue;
            for (i = 0; i < optionalPackages.length; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "optional package..." + optionalPackages[i]);
                }
                try {
                    if (optionalPackages[i].isDirectory()) continue;
                    JarFile jarFile = new JarFile(optionalPackages[i]);
                    Manifest manifest = jarFile.getManifest();
                    jarFile.close();
                    extDirJars.add(optionalPackages[i].toString());
                    String extNameOfOptionalPkg = manifest.getMainAttributes().getValue(Attributes.Name.EXTENSION_NAME);
                    logger.fine("extNameOfOptionalPkg..." + extNameOfOptionalPkg);
                    String specVersion = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
                    logger.fine("specVersion..." + specVersion);
                    if (extNameOfOptionalPkg == null) continue;
                    if (specVersion == null) {
                        logger.log(Level.WARNING, "enterprise.tools.deployment.backend.optionalpkg.dependency.specversion.null", new Object[]{extNameOfOptionalPkg});
                        specVersion = new String("");
                    }
                    optionalPackageStore.put(extNameOfOptionalPkg, specVersion);
                    continue;
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "enterprise.deployment.backend.optionalpkg.dependency.exception", new Object[]{e.getMessage()});
                }
            }
            for (i = 0; i < optionalPackages.length; ++i) {
                if (optionalPackages[i].isDirectory()) continue;
                OptionalPkgDependency.optionalPkgDependencyLogic(optionalPackages[i]);
            }
        }
    }

    public static String getExtDirFilesAsClasspath() {
        StringBuffer classpath = new StringBuffer();
        Iterator iter = extDirJars.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(next);
        }
        return classpath.toString();
    }
}

