/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.AbstractArchiveFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.archivist.FileArchiveFactory;
import com.sun.enterprise.deployment.archivist.JarArchiveFactory;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.ModuleInfo;
import com.sun.enterprise.deployment.backend.OptionalPkgDependency;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.util.zip.ZipFileException;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.zip.ZipException;
import javax.enterprise.deploy.shared.ModuleType;

public class J2EEModuleExploder {
    private static StringManager localStrings;
    private static final String PRESERVED_MANIFEST_NAME = "META-INF/MANIFEST.MF.preserved";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ModuleInfo explode(File archive, File directory, String moduleName) throws IOException, IASDeploymentException {
        return J2EEModuleExploder.explode(archive, directory, moduleName, false);
    }

    public static ModuleInfo explode(File archive, File directory, String moduleName, boolean preserveManifest) throws IOException, IASDeploymentException {
        if (!$assertionsDisabled && archive == null) {
            throw new AssertionError();
        }
        File explodedManifest = null;
        File preservedManifestFromArchive = null;
        AbstractArchiveFactory factory = null;
        factory = archive.isDirectory() ? new FileArchiveFactory() : new JarArchiveFactory();
        AbstractArchive source = factory.openArchive(archive.getAbsolutePath());
        FileArchive target = new FileArchive();
        target.create(directory.getAbsolutePath());
        Archivist archivist = null;
        try {
            archivist = ArchivistFactory.getArchivistForArchive(source);
            if (archivist == null) {
                String msg = localStrings.getString("enterprise.deployment.backend.no_archivist_recognized_arch", archive.getAbsolutePath());
                throw new IASDeploymentException(msg);
            }
        }
        catch (IOException ioe) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_archivist", archive.getAbsolutePath());
            throw new IASDeploymentException(msg, ioe);
        }
        archivist.copyInto(source, target);
        if (preserveManifest && (explodedManifest = new File(directory, "META-INF/MANIFEST.MF")).exists() && !explodedManifest.renameTo(preservedManifestFromArchive = new File(directory, PRESERVED_MANIFEST_NAME))) {
            throw new RuntimeException(localStrings.getString("enterprise.deployment.backend.error_saving_manifest", new Object[]{explodedManifest.getAbsolutePath(), preservedManifestFromArchive.getAbsolutePath()}));
        }
        Enumeration itr = source.entries();
        while (itr.hasMoreElements()) {
            String fileName = (String)itr.nextElement();
            J2EEModuleExploder.optionalPkgDependencyLogic(new File(directory, fileName));
            if (!fileName.toLowerCase().endsWith(".jar") || fileName.replace('\\', '/').toUpperCase().startsWith(WEB_INF_PREFIX)) continue;
            try {
                File f = new File(directory, fileName);
                File targetDirectory = directory;
                ZipFile zip = new ZipFile(f, targetDirectory);
                zip.explode();
            }
            catch (ZipFileException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (preservedManifestFromArchive != null) {
            if (explodedManifest.exists() && !explodedManifest.delete()) {
                throw new RuntimeException(localStrings.getString("enterprise.deployment.backend.error_deleting_manifest", new Object[]{explodedManifest.getAbsolutePath(), preservedManifestFromArchive.getAbsolutePath()}));
            }
            if (!preservedManifestFromArchive.renameTo(explodedManifest)) {
                throw new RuntimeException(localStrings.getString("enterprise.deployment.backend.error_restoring_manifest", new Object[]{preservedManifestFromArchive.getAbsolutePath(), explodedManifest.getAbsolutePath()}));
            }
        }
        source.close();
        target.close();
        ModuleInfo mi = new ModuleInfo(directory, moduleName, archive);
        mi.setType(DeployableObjectType.valueOf(archivist.getModuleType()));
        return mi;
    }

    static void optionalPkgDependencyLogic(File archive) throws IASDeploymentException {
        boolean fileTypeRecognized;
        boolean moduleTypeRecognized = false;
        boolean bl = fileTypeRecognized = FileUtils.isJar(archive) || FileUtils.isWar(archive) || FileUtils.isRar(archive) || archive.getName().endsWith(".ear");
        if (!fileTypeRecognized && archive.getName().endsWith(".tmp")) {
            Archivist arch = null;
            try {
                arch = ArchivistFactory.getArchivistForArchive(archive);
                if (arch != null) {
                    ModuleType moduleType = arch.getModuleType();
                    moduleTypeRecognized = moduleType == ModuleType.EAR || moduleType == ModuleType.EJB || moduleType == ModuleType.RAR || moduleType == ModuleType.WAR;
                }
            }
            catch (ZipException ze) {
            }
            catch (IOException ioe) {
                String msg = localStrings.getString("enterprise.deployment.backend.error_getting_archivist", archive.getAbsolutePath());
                throw new IASDeploymentException(msg, ioe);
            }
        }
        if ((fileTypeRecognized || moduleTypeRecognized) && !OptionalPkgDependency.optionalPkgDependencyLogic(archive)) {
            String msg = localStrings.getString("enterprise.deployment.backend.optionalpkgdependencynotsatisfied");
            throw new IASDeploymentException(msg);
        }
    }

    static void optionalPkgDependencyLogic(File dir, AbstractList files) throws IASDeploymentException {
        for (int i = 0; i < files.size(); ++i) {
            File newjar = new File(dir, files.get(i).toString());
            J2EEModuleExploder.optionalPkgDependencyLogic(newjar);
        }
    }

    static {
        $assertionsDisabled = !J2EEModuleExploder.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(J2EEModuleExploder.class);
    }
}

