/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.ModuleDeployer;
import com.sun.enterprise.deployment.backend.ModuleInfo;
import com.sun.enterprise.deployment.interfaces.DDGenerator;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

public class EjbModuleDeployer
extends ModuleDeployer {
    DDGenerator ddGenerator = null;
    private EjbModulesManager manager = null;
    private boolean isMaybeCMPDropTables = false;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    EjbModuleDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    public void cleanup_internal() {
        try {
            if (this.request.isUnDeploy()) {
                if (this.isMaybeCMPDropTables) {
                    this.dropTables();
                }
                this.liquidate();
            } else if (this.request.isReDeploy() && this.isArchive() && this.oldModuleDir != null) {
                FileUtils.whack(this.oldModuleDir);
            }
        }
        catch (Exception e) {
            this.logger.warning("Exception caught and ignored in cleanup_internal()");
        }
    }

    protected List getModuleClasspath(Application application) throws IASDeploymentException {
        try {
            return EJBClassPathUtils.getEjbModuleClasspathList(application.getRegistrationName(), this.getManager(), this.request.getDeployedDirectory().getCanonicalPath());
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void preundeploy() throws IASDeploymentException, ConfigException {
        if (this.getRequest().isMaybeCMPDropTables()) {
            this.isMaybeCMPDropTables = true;
        }
    }

    protected boolean needsStubs() {
        return true;
    }

    protected BaseManager createConfigManager(InstanceEnvironment ienv, ModuleEnvironment menv) throws IASDeploymentException, ConfigException {
        this.manager = new EjbModulesManager(ienv);
        return this.manager;
    }

    protected void preDeploy() throws IASDeploymentException {
        if (!$assertionsDisabled && this.stubsDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleName == null) {
            throw new AssertionError();
        }
        try {
            if (this.isRegistered()) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
                throw new IASDeploymentException(msg);
            }
            this.liquidateModuleDirAndStubsDirIfTheyHappenToExist();
            if (this.request.isDirectory()) {
                this.moduleInfo = new ModuleInfo(this.moduleDir, this.moduleName);
                this.moduleInfo.setType(DeployableObjectType.EJB);
            } else {
                this.moduleInfo = J2EEModuleExploder.explode(this.request.getFileSource().getFile(), this.moduleDir, this.moduleName);
            }
            this.xmlDir.mkdirs();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e.toString(), e);
        }
    }

    protected void deploy() throws IASDeploymentException, ConfigException {
        this.loadDescriptors();
        ZipItem[] clientStubs = this.runEJBC();
        this.createClientJar(clientStubs);
    }

    protected void preRedeploy() throws IASDeploymentException, ConfigException {
        if (!$assertionsDisabled && this.stubsDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleName == null) {
            throw new AssertionError();
        }
        this.setOldDirs();
        if (this.request.isDirectory()) {
            this.moduleInfo = new ModuleInfo(this.moduleDir, this.moduleName);
            this.moduleInfo.setType(DeployableObjectType.EJB);
        } else {
            try {
                this.moduleInfo = J2EEModuleExploder.explode(this.request.getFileSource().getFile(), this.moduleDir, this.moduleName);
            }
            catch (IOException e) {
                throw new IASDeploymentException(e.toString(), e);
            }
        }
        this.xmlDir.mkdirs();
    }

    protected void postRedeploy() throws IASDeploymentException, ConfigException {
        this.handlePostDeployEvent();
        super.postRedeploy();
    }

    protected void register() throws IASDeploymentException, ConfigException {
        super.register();
        this.setShared(this.request.isSharedModule());
    }

    protected void generatePolicy() throws IASDeploymentException {
        try {
            if (this.request.isApplication()) {
                return;
            }
            SecurityUtil.generatePolicyFile(this.request.getName());
        }
        catch (IASSecurityException se) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error");
            this.logger.log(Level.WARNING, msg, se);
            throw new IASDeploymentException(msg, se);
        }
    }

    protected void postDeploy() throws IASDeploymentException, ConfigException {
        this.handlePostDeployEvent();
        super.postDeploy();
    }

    private void handlePostDeployEvent() throws IASDeploymentException {
        DeploymentEventInfo info = this.getEventInfo();
        DeploymentEvent ev = new DeploymentEvent(2, info);
        DeploymentEventManager.notifyDeploymentEvent(ev);
    }

    private DeploymentEventInfo getEventInfo() throws IASDeploymentException {
        return new DeploymentEventInfo(this.moduleDir, this.stubsDir, this.oldStubsDir, this.request.getDescriptor(), this.getRequest());
    }

    private void dropTables() {
        if (!$assertionsDisabled && !this.isMaybeCMPDropTables) {
            throw new AssertionError();
        }
        try {
            Application moduleDD = FileUtils.safeIsDirectory(this.xmlDir) ? DeploymentUtils.getEjbDescriptor(this.xmlDir.getAbsolutePath()) : DeploymentUtils.getEjbDescriptor(this.moduleDir.getAbsolutePath());
            moduleDD.setRegistrationName(this.moduleName);
            DeploymentEventInfo info = new DeploymentEventInfo(this.moduleDir, this.stubsDir, this.oldStubsDir, moduleDD, this.request);
            DeploymentEvent ev = new DeploymentEvent(3, info);
            DeploymentEventManager.notifyDeploymentEvent(ev);
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "enterprise.deployment_pre_undeploy_event_error", t);
        }
    }

    public void removePolicy() throws IASDeploymentException {
        if (this.request.isApplication()) {
            return;
        }
        String name = this.request.getName();
        try {
            SecurityUtil.removePolicy(name);
        }
        catch (IASSecurityException ex) {
            String msg = localStrings.getString("enterprise.deployment.backend.remove_policy_error", name);
            this.logger.log(Level.WARNING, msg, ex);
            throw new IASDeploymentException(msg, ex);
        }
    }

    static {
        $assertionsDisabled = !EjbModuleDeployer.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(EjbModuleDeployer.class);
    }
}

