/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.AppDD;
import com.sun.enterprise.deployment.backend.AppInfo;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.util.Console;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.util.zip.ZipFileException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EarExploder {
    private File appDir;
    private File ear;
    private AppInfo info;
    private ArrayList files;
    private Application app;
    private String[] ejbs;
    private String[] wars;
    private String[] clients;
    private String[] rars;
    private static StringManager localStrings;
    private static final String VERIFY_ERR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EarExploder(AppInfo anInfo) {
        if (!$assertionsDisabled && anInfo == null) {
            throw new AssertionError();
        }
        this.info = anInfo;
        this.appDir = this.info.getRootPath();
        this.ear = this.info.getArchive();
        if (!$assertionsDisabled && this.ear == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.appDir == null) {
            throw new AssertionError();
        }
    }

    public Application explode() throws ZipFileException, IASDeploymentException, IOException {
        J2EEModuleExploder.optionalPkgDependencyLogic(this.ear);
        ZipFile zip = new ZipFile(this.ear, this.appDir);
        this.files = zip.explode();
        J2EEModuleExploder.optionalPkgDependencyLogic(this.appDir, this.files);
        this.createModulesList();
        this.verify();
        this.explodeEjbs();
        this.explodeWars();
        this.explodeRars();
        this.explodeClients();
        DirInfo.cleanupExtraDirectories();
        return this.app;
    }

    private void explodeEjbs() throws IASDeploymentException, IOException {
        for (int i = 0; this.ejbs != null && i < this.ejbs.length; ++i) {
            DirInfo di = new DirInfo(this.ejbs[i], this.appDir);
            J2EEModuleExploder.explode(di.archiveFile, di.moduleDir, di.massagedModuleName);
            di.cleanup();
        }
    }

    private void explodeWars() throws IASDeploymentException, IOException {
        for (int i = 0; this.wars != null && i < this.wars.length; ++i) {
            DirInfo di = new DirInfo(this.wars[i], this.appDir);
            J2EEModuleExploder.explode(di.archiveFile, di.moduleDir, di.massagedModuleName, true);
            di.cleanup();
        }
    }

    private void explodeRars() throws IASDeploymentException, IOException {
        for (int i = 0; this.rars != null && i < this.rars.length; ++i) {
            DirInfo di = new DirInfo(this.rars[i], this.appDir);
            J2EEModuleExploder.explode(di.archiveFile, di.moduleDir, di.massagedModuleName);
            di.cleanup();
        }
    }

    private void explodeClients() throws IASDeploymentException, IOException {
        for (int i = 0; this.clients != null && i < this.clients.length; ++i) {
            DirInfo di = new DirInfo(this.clients[i], this.appDir);
            J2EEModuleExploder.explode(di.archiveFile, di.moduleDir, di.massagedModuleName);
            di.cleanup();
        }
    }

    private void verify() throws IASDeploymentException {
        this.verifyModulesExist();
    }

    private void createModulesList() throws IASDeploymentException {
        try {
            AppDD appDD = new AppDD(this.appDir, false);
            this.app = appDD.getApplication();
            this.ejbs = appDD.getEjbModules();
            this.wars = appDD.getWarModules();
            this.clients = appDD.getClientModules();
            this.rars = appDD.getRarModules();
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e.toString());
        }
    }

    private void verifyModulesExist() throws IASDeploymentException {
        int i;
        String err = "Verify Error: Module specified in application.xml not found in ear file: ";
        String err2 = "Verify Error: Illegal module name in Application.xml: ";
        for (i = 0; i < this.ejbs.length; ++i) {
            if (!this.files.contains(this.ejbs[i])) {
                String msg = localStrings.getString("enterprise.deployment.backend.verify_error_module_not_present_in_ear", this.ejbs[i]);
                throw new IASDeploymentException(msg);
            }
            if (FileUtils.isJar(this.ejbs[i])) continue;
            String msg = localStrings.getString("enterprise.deployment.backend.verify_error_illegal_module_name", this.ejbs[i]);
            throw new IASDeploymentException(msg);
        }
        for (i = 0; i < this.wars.length; ++i) {
            if (!this.files.contains(this.wars[i])) {
                String msg = localStrings.getString("enterprise.deployment.backend.verify_error_module_not_present_in_ear", this.wars[i]);
                throw new IASDeploymentException(msg);
            }
            if (FileUtils.isWar(this.wars[i])) continue;
            String msg = localStrings.getString("enterprise.deployment.backend.verify_error_illegal_module_name", this.wars[i]);
            throw new IASDeploymentException(msg);
        }
        for (i = 0; i < this.rars.length; ++i) {
            if (!this.files.contains(this.rars[i])) {
                String msg = localStrings.getString("enterprise.deployment.backend.verify_error_module_not_present_in_ear", this.rars[i]);
                throw new IASDeploymentException(msg);
            }
            if (FileUtils.isRar(this.rars[i])) continue;
            String msg = localStrings.getString("enterprise.deployment.backend.verify_error_illegal_module_name", this.rars[i]);
            throw new IASDeploymentException(msg);
        }
        for (i = 0; i < this.clients.length; ++i) {
            if (!this.files.contains(this.clients[i])) {
                String msg = localStrings.getString("enterprise.deployment.backend.verify_error_module_not_present_in_ear", this.clients[i]);
                throw new IASDeploymentException(msg);
            }
            if (FileUtils.isJar(this.clients[i])) continue;
            String msg = localStrings.getString("enterprise.deployment.backend.verify_error_illegal_module_name", this.clients[i]);
            throw new IASDeploymentException(msg);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            args = new String[]{Console.readLine("Full path EAR filename: "), Console.readLine("Root-Directory-To-explode-In: ")};
        }
        String ear = args[0];
        File dest = new File(args[1]);
        if (!FileUtils.isEar(ear)) {
            return;
        }
        String appName = FileUtils.makeFriendlyFileNameNoExtension(ear);
        File appDir = new File(dest, appName);
        File stubsDir = new File(appDir, "stubs");
        stubsDir.mkdirs();
        AppInfo ai = new AppInfo(appDir, appName, new File(ear));
        EarExploder earex = new EarExploder(ai);
        try {
            earex.explode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    static {
        $assertionsDisabled = !EarExploder.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(EarExploder.class);
        VERIFY_ERR = localStrings.getString("enterprise.deployment.backend.earexploder_verify_error");
    }

    private static class DirInfo {
        private File appDir;
        private String moduleName;
        private String massagedModuleName;
        private File archiveFile;
        private File moduleDir;
        private static Set instances = new HashSet();

        private DirInfo(String moduleNameFromXML, File appDirectory) throws IASDeploymentException {
            this.appDir = appDirectory;
            this.moduleName = moduleNameFromXML;
            this.massagedModuleName = FileUtils.makeFriendlyFilename(this.moduleName);
            this.archiveFile = new File(this.appDir, this.removeLeadingSlashes(this.moduleName));
            this.moduleDir = new File(this.appDir, this.massagedModuleName);
            instances.add(this);
        }

        private String removeLeadingSlashes(String s) throws IASDeploymentException {
            char c;
            String fixed = s;
            while (fixed.length() > 0 && ((c = fixed.charAt(0)) == '/' || c == '\\')) {
                fixed = fixed.substring(1);
            }
            if (fixed.length() <= 0) {
                throw new IASDeploymentException("Illegal module filename: " + s);
            }
            return fixed;
        }

        private void cleanup() {
            if (!this.archiveFile.delete()) {
                this.archiveFile.deleteOnExit();
            }
        }

        private static void cleanupExtraDirectories() {
            Iterator it = instances.iterator();
            while (it.hasNext()) {
                DirInfo di = (DirInfo)it.next();
                for (File parent = di.archiveFile.getParentFile(); parent != null && !parent.equals(di.appDir); parent = parent.getParentFile()) {
                    File curr = parent;
                    if (!FileUtils.safeIsDirectory(curr) || curr.delete()) continue;
                    curr.deleteOnExit();
                }
            }
            instances.clear();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("DirInfo Dump:\n");
            sb.append("appDir: " + this.appDir.getPath());
            sb.append("\nmoduleName: " + this.moduleName);
            sb.append("\nmassagedModuleName: " + this.massagedModuleName);
            sb.append("\narchiveFile: " + this.archiveFile.getPath());
            sb.append("\nmoduleDir: " + this.moduleDir.getPath());
            return sb.toString();
        }
    }
}

