/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.ejb.codegen.IASEJBC;
import com.sun.ejb.codegen.IASEJBCTimes;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.backend.EjbcContextImpl;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.ModulesManager;
import com.sun.enterprise.instance.UniqueIdGenerator;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.tools.verifier.AppVerifier;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;

public class EJBCompiler {
    private String name;
    private ModulesManager moduleManager;
    private AppsManager appManager;
    private DeploymentRequest request;
    private EjbcContextImpl ejbcContext;
    private List classpathForCompilation;
    private static final Logger _logger;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EJBCompiler(String name, File srcDir, File oldSrcDir, File stubsDir, File oldStubsDir, BaseManager manager, DeploymentRequest request, IASEJBCTimes timing) throws IASDeploymentException {
        this(name, srcDir, oldSrcDir, stubsDir, oldStubsDir, manager, request, timing, request.getCompleteClasspath());
    }

    public EJBCompiler(String name, File srcDir, File oldSrcDir, File stubsDir, File oldStubsDir, BaseManager manager, DeploymentRequest request, IASEJBCTimes timing, List classpathForCompilation) throws IASDeploymentException {
        if (!$assertionsDisabled && !StringUtils.ok((String)name)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !FileUtils.safeIsDirectory(srcDir)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !FileUtils.safeIsDirectory(oldSrcDir)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !FileUtils.safeIsDirectory(stubsDir)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !FileUtils.safeIsDirectory(oldStubsDir)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && manager == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && timing == null) {
            throw new AssertionError();
        }
        try {
            this.name = name;
            this.request = request;
            this.classpathForCompilation = classpathForCompilation;
            this.ejbcContext = new EjbcContextImpl();
            this.ejbcContext.setSrcDir(srcDir);
            this.ejbcContext.setOldSrcDir(oldSrcDir);
            this.ejbcContext.setStubsDir(stubsDir);
            this.ejbcContext.setOldStubsDir(oldStubsDir);
            this.ejbcContext.setTiming(timing);
            this.ejbcContext.setRmicOptions(manager.getRmicOptions());
            this.ejbcContext.setJavacOptions(manager.getJavacOptions());
            this.ejbcContext.setOptionalArguments(this.request.getOptionalArguments());
            this.ejbcContext.setDeploymentRequest(request);
            if (manager instanceof ModulesManager) {
                this.moduleManager = (ModulesManager)manager;
                this.appManager = null;
            } else if (manager instanceof AppsManager) {
                this.appManager = (AppsManager)manager;
                this.moduleManager = null;
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
    }

    public ZipItem[] compile() throws IASDeploymentException {
        ZipItem[] clientStubs = null;
        try {
            if (this.request.getNoEJBC()) {
                _logger.info("**********  EJBC Skipped! ************");
                ZipItem[] zipItemArray = new ZipItem[]{};
                return zipItemArray;
            }
            clientStubs = this.appManager != null ? this.preDeployApp() : this.preDeployModule();
            Application app = this.ejbcContext.getDescriptor();
            if (app != null) {
                Iterator iter = app.getEjbDescriptors().iterator();
                while (iter.hasNext()) {
                    EJBSecurityManager.loadPolicyConfiguration((EjbDescriptor)iter.next());
                }
            }
        }
        catch (Throwable t) {
            throw this.wrapException(t);
        }
        finally {
            this.ejbcContext.cleanup();
        }
        return clientStubs;
    }

    private ZipItem[] preDeployApp() throws Exception {
        String archive;
        AppVerifier v;
        int status;
        ZipItem[] clientStubs = null;
        Application application = this.request.getDescriptor();
        String appRoot = this.ejbcContext.getSrcDir().getCanonicalPath();
        if (this.request.isVerifying() && (status = (v = new AppVerifier(archive = this.request.getFileSource().getFile().getAbsolutePath())).verify()) != 0) {
            String msg = localStrings.getString("enterprise.deployment.backend.verifier_error");
            throw new IASDeploymentException(msg);
        }
        this.setEjbClasspath(this.request.getModuleClasspath());
        this.ejbcContext.setDescriptor(application);
        String[] classPathUrls = new String[this.classpathForCompilation.size()];
        classPathUrls = this.classpathForCompilation.toArray(classPathUrls);
        this.ejbcContext.setClasspathUrls(classPathUrls);
        this.verifyContext();
        if (this.ejbcContext.isRedeploy()) {
            String oldAppRoot = this.ejbcContext.getOldSrcDir().getCanonicalPath();
            ArrayList<String> oldEjbClassPath = new ArrayList<String>();
            String newStubsDir = this.ejbcContext.getStubsDir().getCanonicalPath();
            for (int i = 0; i < classPathUrls.length; ++i) {
                String nextNew = classPathUrls[i];
                if (nextNew.startsWith(appRoot)) {
                    StringBuffer sb = new StringBuffer(nextNew);
                    StringBuffer nextOld = sb.replace(0, appRoot.length(), oldAppRoot);
                    oldEjbClassPath.add(nextOld.toString());
                    continue;
                }
                if (nextNew.equals(newStubsDir)) continue;
                oldEjbClassPath.add(nextNew);
            }
            EJBClassLoader oldEjbClassLoader = DeploymentUtils.getClassLoader(oldEjbClassPath, this.request.getParentClassLoader(), this.ejbcContext.getOldStubsDir());
            this.ejbcContext.setOldClassLoader(oldEjbClassLoader);
        }
        clientStubs = IASEJBC.ejbc(this.ejbcContext);
        UniqueIdGenerator uidGenerator = UniqueIdGenerator.getInstance();
        long uid = uidGenerator.getNextUniqueId();
        application.setUniqueId(uid);
        this.appManager.saveAppDescriptor(this.name, application, this.request.getDeployedDirectory().getCanonicalPath(), this.request.getGeneratedXMLDirectory().getCanonicalPath(), false);
        return clientStubs;
    }

    private void setEjbClasspath(List ejbClassPath) {
        String[] ejbClassPathUrls = new String[ejbClassPath.size()];
        ejbClassPathUrls = ejbClassPath.toArray(ejbClassPathUrls);
        this.ejbcContext.setEjbClasspathUrls(ejbClassPathUrls);
    }

    private ZipItem[] preDeployModule() throws Exception {
        String archive;
        AppVerifier v;
        int status;
        ZipItem[] clientStubs = null;
        Application application = this.request.getDescriptor();
        Iterator it = application.getEjbBundleDescriptors().iterator();
        if (it.hasNext() && this.request.isVerifying() && (status = (v = new AppVerifier(archive = this.request.getFileSource().getFile().getAbsolutePath())).verify()) != 0) {
            String msg = localStrings.getString("enterprise.deployment.backend.verifier_error");
            throw new IASDeploymentException(msg);
        }
        this.ejbcContext.setDescriptor(application);
        String[] classPathUrls = new String[this.classpathForCompilation.size()];
        classPathUrls = this.classpathForCompilation.toArray(classPathUrls);
        this.ejbcContext.setClasspathUrls(classPathUrls);
        this.verifyContext();
        if (this.ejbcContext.isRedeploy()) {
            String oldModRoot = this.ejbcContext.getOldSrcDir().getCanonicalPath();
            ArrayList<String> oldEjbClassPath = new ArrayList<String>();
            oldEjbClassPath.add(oldModRoot);
            EJBClassLoader oldEjbClassLoader = DeploymentUtils.getClassLoader(oldEjbClassPath, this.request.getParentClassLoader(), this.ejbcContext.getOldStubsDir());
            this.ejbcContext.setOldClassLoader(oldEjbClassLoader);
        }
        clientStubs = IASEJBC.ejbc(this.ejbcContext);
        UniqueIdGenerator uidGenerator = UniqueIdGenerator.getInstance();
        long uid = uidGenerator.getNextUniqueId();
        Iterator itr = application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor bundleDesc = (EjbBundleDescriptor)itr.next();
            bundleDesc.setUniqueId(uid);
        }
        this.moduleManager.saveAppDescriptor(this.name, application, this.request.getDeployedDirectory().getCanonicalPath(), this.request.getGeneratedXMLDirectory().getCanonicalPath(), true);
        return clientStubs;
    }

    void verifyContext() throws IASDeploymentException {
        if (this.ejbcContext.getSrcDir() == null || this.ejbcContext.getStubsDir() == null || this.ejbcContext.getDescriptor() == null || this.ejbcContext.getRmicOptions() == null || this.ejbcContext.getJavacOptions() == null || this.ejbcContext.getTiming() == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.bad_ejbc_ctx");
            throw new IASDeploymentException(msg);
        }
    }

    public Application getOldAppDescriptor(String appDir, String appId, ClassLoader cl) throws ConfigException, IOException, SAXParseException {
        FileArchive archive = new FileArchive();
        archive.open(appDir);
        ApplicationArchivist archivist = new ApplicationArchivist();
        archivist.setXMLValidation(false);
        return (Application)archivist.open(archive);
    }

    public Application getOldModuleDescriptor(String modDir, String modId, ClassLoader cl) throws ConfigException, IOException, SAXParseException {
        FileArchive archive = new FileArchive();
        archive.open(modDir);
        EjbArchivist ejbArch = new EjbArchivist();
        ejbArch.setXMLValidation(false);
        return ApplicationArchivist.openArchive((Archivist)ejbArch, archive, true);
    }

    IASDeploymentException wrapException(Throwable t) {
        String msg = localStrings.getString("enterprise.deployment.backend.fatal_ejbc_error");
        if (t instanceof RemoteException) {
            msg = msg + localStrings.getString("enterprise.deployment.backend.ejbc_remoteexception", t);
        }
        return new IASDeploymentException(msg, t);
    }

    static {
        $assertionsDisabled = !EJBCompiler.class.desiredAssertionStatus();
        _logger = DeploymentLogger.get();
        localStrings = StringManager.getManager(EJBCompiler.class);
    }
}

