/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.loader.ClassLoaderUtils;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class DeploymentUtils {
    DeploymentUtils() {
    }

    static void setParentClassLoader(ClassLoader bootStrap, BaseManager baseMgr, DeploymentRequest req) throws ConfigException, IOException {
        List sharedClassPath;
        List commonClassPath;
        ArrayList allClassPaths = new ArrayList();
        List systemClasspath = baseMgr.getSystemCPathPrefixNSuffix();
        if (systemClasspath.size() > 0) {
            allClassPaths.addAll(systemClasspath);
        }
        if ((commonClassPath = DeploymentUtils.getCommonClasspath(baseMgr)).size() > 0) {
            allClassPaths.addAll(commonClassPath);
        }
        if ((sharedClassPath = baseMgr.getSharedClasspath()).size() > 0) {
            allClassPaths.addAll(sharedClassPath);
        }
        EJBClassLoader parentClassLoader = DeploymentUtils.getClassLoader(allClassPaths, bootStrap, null);
        req.setParentClassLoader(parentClassLoader);
        req.setParentClasspath(allClassPaths);
    }

    static EJBClassLoader getClassLoader(List paths, ClassLoader parent, File other) throws IOException {
        EJBClassLoader ejbCl = null;
        ejbCl = parent != null ? new EJBClassLoader(parent) : new EJBClassLoader();
        int LIST_SZ = paths.size();
        for (int i = 0; i < LIST_SZ; ++i) {
            String path = (String)paths.get(i);
            ejbCl.appendURL(new File(path).toURL());
        }
        if (other != null) {
            ejbCl.appendURL(other.toURL());
        }
        return ejbCl;
    }

    static List getCommonClasspath(BaseManager mgr) throws IOException {
        InstanceEnvironment env = mgr.getInstanceEnvironment();
        String dir = env.getLibClassesPath();
        String jarDir = env.getLibPath();
        return ClassLoaderUtils.getUrlList(new File[]{new File(dir)}, new File[]{new File(jarDir)});
    }

    protected static String getSystemPropertyIgnoreCase(String key) {
        Properties p = System.getProperties();
        Set<Map.Entry<Object, Object>> set = p.entrySet();
        Iterator<Map.Entry<Object, Object>> it = set.iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> me = it.next();
            String propKey = (String)me.getKey();
            if (key.compareToIgnoreCase(propKey) != 0) continue;
            return (String)me.getValue();
        }
        return null;
    }

    static Application getAppDescriptor(String appDir) throws IASDeploymentException {
        try {
            FileArchive archive = new FileArchive();
            archive.open(appDir);
            ApplicationArchivist archivist = new ApplicationArchivist();
            archivist.setXMLValidation(false);
            return (Application)archivist.open(archive);
        }
        catch (Throwable t) {
            throw new IASDeploymentException(t);
        }
    }

    static Application getEjbDescriptor(String appDir) throws IASDeploymentException {
        try {
            FileArchive archive = new FileArchive();
            archive.open(appDir);
            EjbArchivist ejbArchivist = new EjbArchivist();
            ejbArchivist.setXMLValidation(false);
            return ApplicationArchivist.openArchive((Archivist)ejbArchivist, archive, true);
        }
        catch (Throwable t) {
            throw new IASDeploymentException(t);
        }
    }

    static boolean isS1ASOwned(File f) {
        try {
            File iasRootFile = new File(System.getProperty("com.sun.aas.instanceRoot")).getCanonicalFile();
            if (!FileUtils.safeIsDirectory(iasRootFile)) {
                return false;
            }
            return (f = f.getCanonicalFile()).getPath().startsWith(iasRootFile.getPath() + File.separatorChar);
        }
        catch (IOException e) {
            return false;
        }
    }
}

