/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.backend.AppClientModuleDeployer;
import com.sun.enterprise.deployment.backend.AppDeployer;
import com.sun.enterprise.deployment.backend.AppReDeployer;
import com.sun.enterprise.deployment.backend.AppUnDeployer;
import com.sun.enterprise.deployment.backend.ConnectorModuleDeployer;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.EjbModuleDeployer;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.WebModuleDeployer;
import com.sun.enterprise.util.i18n.StringManager;

public class DeployerFactory {
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DeployerFactory() {
    }

    public static Deployer getDeployer(DeploymentRequest request) throws IASDeploymentException {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        request.verify();
        if (request.isApplication()) {
            return DeployerFactory.getAppDeployer(request);
        }
        if (request.isEjbModule()) {
            return new EjbModuleDeployer(request);
        }
        if (request.isWebModule()) {
            return new WebModuleDeployer(request);
        }
        if (request.isConnectorModule()) {
            return new ConnectorModuleDeployer(request);
        }
        if (request.isAppClientModule()) {
            if (request.isDirectory()) {
                String msg = localStrings.getStringWithDefault("enterprise.deployment.backend.DirDeployOfAppClient", "App Client Directory-Deployment not supported");
                throw new IASDeploymentException(msg);
            }
            return new AppClientModuleDeployer(request);
        }
        String msg = localStrings.getString("enterprise.deployment.backend.deployment_not_supported");
        throw new IASDeploymentException(msg);
    }

    public static Deployer getAppDeployer(DeploymentRequest request) throws IASDeploymentException {
        if (request.isDeploy()) {
            return new AppDeployer(request);
        }
        if (request.isReDeploy()) {
            return new AppReDeployer(request);
        }
        if (request.isUnDeploy()) {
            return new AppUnDeployer(request);
        }
        String msg = localStrings.getString("enterprise.deployment.backend.unknown_deployment_request_type");
        throw new IASDeploymentException(msg);
    }

    static {
        $assertionsDisabled = !DeployerFactory.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(DeployerFactory.class);
    }
}

