/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import javax.enterprise.deploy.shared.ModuleType;

public class DeployableObjectType {
    public static final DeployableObjectType APP;
    public static final DeployableObjectType EJB;
    public static final DeployableObjectType WEB;
    public static final DeployableObjectType CONN;
    public static final DeployableObjectType CAR;
    private final String name;
    private final String ddName;
    private final ModuleType jsr88Type;
    private static StringManager localStrings;
    private static List allTypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean isEJB() {
        return this == EJB;
    }

    public boolean isWEB() {
        return this == WEB;
    }

    public boolean isAPP() {
        return this == APP;
    }

    public boolean isCONN() {
        return this == CONN;
    }

    public boolean isCAR() {
        return this == CAR;
    }

    public String toString() {
        return this.name;
    }

    public ModuleType getModuleType() {
        return this.jsr88Type;
    }

    public static DeployableObjectType valueOf(String s) {
        if (s.equals(APP.toString())) {
            return APP;
        }
        if (s.equals(EJB.toString())) {
            return EJB;
        }
        if (s.equals(WEB.toString())) {
            return WEB;
        }
        if (s.equals(CONN.toString())) {
            return CONN;
        }
        if (s.equals(CAR.toString())) {
            return CAR;
        }
        return null;
    }

    public static DeployableObjectType valueOf(ModuleType moduleType) {
        Iterator it = allTypes.iterator();
        while (it.hasNext()) {
            DeployableObjectType dot = (DeployableObjectType)it.next();
            if (dot.jsr88Type != moduleType) continue;
            return dot;
        }
        return null;
    }

    public static DeployableObjectType valueOf(File f) throws IASDeploymentException {
        if (f == null || !f.exists()) {
            throw new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", f));
        }
        if (FileUtils.safeIsDirectory(f)) {
            return DeployableObjectType.valueOfDir(f);
        }
        return DeployableObjectType.valueOfArchive(f);
    }

    private DeployableObjectType(String theName, String theDDName, ModuleType type) {
        if (!$assertionsDisabled && theName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && theDDName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && allTypes == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        this.name = theName;
        this.ddName = theDDName;
        this.jsr88Type = type;
        allTypes.add(this);
    }

    private static DeployableObjectType valueOfDir(File dir) throws IASDeploymentException {
        Iterator it = allTypes.iterator();
        while (it.hasNext()) {
            DeployableObjectType dot = (DeployableObjectType)it.next();
            File checkit = new File(dir, dot.ddName);
            if (!checkit.exists()) continue;
            return dot;
        }
        throw new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.cant_determine_type", dir));
    }

    private static DeployableObjectType valueOfArchive(File archive) throws IASDeploymentException {
        JarFile jar = null;
        try {
            jar = new JarFile(archive);
            Iterator it = allTypes.iterator();
            while (true) {
                if (it.hasNext()) {
                    DeployableObjectType dot = (DeployableObjectType)it.next();
                    if (jar.getEntry(dot.ddName) == null) continue;
                    DeployableObjectType deployableObjectType = dot;
                    return deployableObjectType;
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            throw new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.cant_determine_type", ex.getMessage()), ex);
        }
        finally {
            try {
                jar.close();
            }
            catch (Exception e) {}
        }
        throw new IASDeploymentException(localStrings.getString("enterprise.deployment.backend.cant_determine_type", archive));
    }

    public static void main(String[] args) {
        String[] files = new String[]{"pkgingEApp.ear", "foof.rar", "hello.war", "foo.jar", "nothere", "junk.ear", "ear", "ejb", "rar", "war"};
        for (int i = 0; i < files.length; ++i) {
            File file = new File("C:/ias8samples/" + files[i]);
        }
    }

    static {
        $assertionsDisabled = !DeployableObjectType.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(DeployableObjectType.class);
        allTypes = new ArrayList(5);
        APP = new DeployableObjectType("Application", "META-INF/application.xml", ModuleType.EAR);
        EJB = new DeployableObjectType("EJB Module", "META-INF/ejb-jar.xml", ModuleType.EJB);
        WEB = new DeployableObjectType("Web Module", "WEB-INF/web.xml", ModuleType.WAR);
        CONN = new DeployableObjectType("Connector Module", "META-INF/ra.xml", ModuleType.RAR);
        CAR = new DeployableObjectType("AppClient Module", "META-INF/application-client.xml", ModuleType.CAR);
    }
}

