/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.archivist.OutputJarArchive;
import com.sun.enterprise.deployment.backend.ClientJarMakerRegistry;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.PEDeploymentFactoryImpl;
import com.sun.enterprise.deployment.interfaces.ClientJarMaker;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.util.logging.Level;

public class ClientJarMakerThread
extends Thread {
    private DeploymentRequest request;
    private File clientJar;
    private ZipItem[] clientStubs;
    private static StringManager localStrings = StringManager.getManager(Deployer.class);

    public ClientJarMakerThread(DeploymentRequest request, File clientJar, ZipItem[] clientStubs) {
        this.request = request;
        this.clientJar = clientJar;
        this.clientStubs = clientStubs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ClientJarMakerRegistry registry = ClientJarMakerRegistry.getInstance();
        String moduleID = this.request.getName();
        registry.register(moduleID, this);
        try {
            ClientJarMakerThread.createClientJar(this.request, this.clientJar, this.clientStubs);
        }
        catch (IASDeploymentException e) {
            DeploymentLogger.get().log(Level.SEVERE, localStrings.getString("enterprise.deployment.error_creating_client_jar", e.getLocalizedMessage()), e);
        }
        finally {
            registry.unregister(moduleID);
        }
        DeploymentLogger.get().fine("Created client jar file for " + moduleID + " at " + this.clientJar.getAbsolutePath());
    }

    public static final void createClientJar(DeploymentRequest request, File clientJar, ZipItem[] clientStubs) throws IASDeploymentException {
        try {
            OutputJarArchive target = new OutputJarArchive();
            target.create(clientJar.getAbsolutePath());
            RootDeploymentDescriptor descriptor = request.getDescriptor().isVirtual() ? request.getDescriptor().getStandaloneBundleDescriptor() : request.getDescriptor();
            FileArchive source = new FileArchive();
            source.open(request.getDeployedDirectory().getAbsolutePath());
            PEDeploymentFactoryImpl pe = new PEDeploymentFactoryImpl();
            ClientJarMaker jarMaker = pe.getClientJarMaker(null);
            if (FileUtils.safeIsDirectory(request.getGeneratedXMLDirectory())) {
                FileArchive source2 = new FileArchive();
                source2.open(request.getGeneratedXMLDirectory().getAbsolutePath());
                jarMaker.create(descriptor, source, source2, target, clientStubs, null);
                source2.close();
            } else {
                jarMaker.create(descriptor, source, target, clientStubs, null);
            }
            source.close();
            target.close();
        }
        catch (Exception e) {
            IASDeploymentException newE = new IASDeploymentException();
            newE.initCause(e);
            throw newE;
        }
    }
}

