/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.backend.AppInfo;
import com.sun.enterprise.deployment.backend.ContextRootChecker;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.ApplicationEnvironment;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.web.security.WebSecurityManager;
import com.sun.web.security.WebSecurityManagerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

abstract class AppDeployerBase
extends Deployer {
    private ApplicationEnvironment appEnv;
    private AppsManager appMgr;
    private String appName;
    private boolean isReg;
    private boolean isSystem = false;
    private File stubsDir;
    private File jspDir;
    private File xmlDir;
    private File appDir;
    private AppInfo appInfo;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;

    AppDeployerBase(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    protected abstract File setAppDir() throws IASDeploymentException;

    protected void begin() throws IASDeploymentException {
        super.begin();
        try {
            this.appEnv = this.request.getAppEnv();
            if (this.appEnv == null) {
                String msg = localStrings.getString("enterprise.deployment.backend.null_applicationenvironment_object");
                throw new IASDeploymentException(msg);
            }
            this.appMgr = new AppsManager(this.getInstanceEnv());
            this.appName = this.request.getName();
            if (!StringUtils.ok((String)this.appName)) {
                String msg = localStrings.getString("enterprise.deployment.backend.null_appname");
                throw new IASDeploymentException(msg);
            }
            this.isReg = DeploymentServiceUtils.isRegistered(this.getAppName(), this.request.getType());
            if (this.isReg) {
                this.isSystem = this.isSystem();
            }
            this.verify();
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void predeploy() throws IASDeploymentException {
        try {
            this.appDir = this.setAppDir();
            this.request.setDeployedDirectory(this.appDir);
            this.setGeneratedDirs();
            this.appInfo = this.createAppInfo();
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected AppInfo createAppInfo() throws IASDeploymentException {
        AppInfo ai;
        if (!$assertionsDisabled && this.appDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getAppName() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.request.isUnDeploy()) {
            throw new AssertionError();
        }
        if (this.isDirectory()) {
            ai = new AppInfo(this.appDir, this.getAppName());
        } else {
            File f = this.request.getFileSource().getFile();
            ai = new AppInfo(this.appDir, this.getAppName(), f);
        }
        return ai;
    }

    protected final void verify() throws IASDeploymentException {
        if (!this.request.isApplication()) {
            String msg = localStrings.getString("enterprise.deployment.backend.attempt_to_deploy_non_application");
            throw new IASDeploymentException(msg);
        }
        if (this.request.isUnDeploy()) {
            if (!this.isReg) {
                String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_application_not_registered");
                throw new IASDeploymentException(msg);
            }
            if (this.isSystem) {
                String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_application_is_a_system_resource");
                throw new IASDeploymentException(msg);
            }
        } else if (this.request.isDeploy()) {
            if (this.isReg) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_application_exists");
                throw new IASDeploymentException(msg);
            }
            this.checkRegisteredAnywhereElse(this.appName);
        } else if (this.request.isReDeploy()) {
            if (!this.isReg) {
                String msg = localStrings.getString("enterprise.deployment.backend.redeploy_error_application_does_not_exist");
                throw new IASDeploymentException(msg);
            }
            if (this.isSystem) {
                String msg = localStrings.getString("enterprise.deployment.backend.redeploy_error_application_is_a_system_resource");
                throw new IASDeploymentException(msg);
            }
        }
    }

    protected final void checkContextRoot() throws IASDeploymentException {
        Application app = this.request.getDescriptor();
        Vector<String> roots = new Vector<String>();
        Iterator modules = app.getModules();
        while (modules.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)modules.next();
            if (!md.getModuleType().equals(ModuleType.WAR)) continue;
            roots.add(md.getContextRoot());
        }
        if (roots.isEmpty()) {
            return;
        }
        Object[] contextRoots = new String[roots.size()];
        roots.copyInto(contextRoots);
        ContextRootChecker checker = new ContextRootChecker(this.getInstanceEnv(), (String[])contextRoots, (AppsManager)this.getManager(), this.getAppName());
        checker.check();
    }

    private final void setGeneratedDirs() throws IASDeploymentException {
        try {
            this.stubsDir = new File(this.getAppEnv().getAppStubPath());
            this.jspDir = new File(this.getAppEnv().getAppJSPPath());
            this.xmlDir = new File(this.getAppEnv().getAppGeneratedXMLPath());
            this.request.setJSPDirectory(this.jspDir);
            this.request.setStubsDirectory(this.stubsDir);
            this.request.setGeneratedXMLDirectory(this.xmlDir);
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_generated_dirs", e);
            throw new IASDeploymentException(msg);
        }
    }

    protected final ApplicationEnvironment getAppEnv() {
        return this.appEnv;
    }

    protected BaseManager getManager() {
        return this.appMgr;
    }

    protected final String getAppName() {
        return this.appName;
    }

    protected final File getStubsDir() {
        return this.stubsDir;
    }

    protected final File getJSPDir() {
        return this.jspDir;
    }

    protected final File getXMLDir() {
        return this.xmlDir;
    }

    protected final void setAppInfo(File dir, String name) {
        this.appInfo = new AppInfo(dir, name);
    }

    protected final AppInfo getAppInfo() {
        return this.appInfo;
    }

    protected final File getAppDir() {
        return this.appDir;
    }

    protected final File getModuleDir() {
        return this.appDir;
    }

    protected List getModuleClasspath(Application application) throws IASDeploymentException {
        try {
            return EJBClassPathUtils.getAppDeploymentClassPath(application, this.request.getDeployedDirectory().getAbsolutePath(), this.getManager());
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected final boolean isSystem() throws IASDeploymentException {
        try {
            boolean guardSystemApp;
            boolean isSystem = DeploymentServiceUtils.isSystem(this.getAppName(), this.request.getType());
            boolean bl = guardSystemApp = Boolean.valueOf(System.getProperty("com.sun.aas.deployment.AllowSysAppDeployment", "false")) == false;
            return isSystem && guardSystemApp;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void generatePolicy() throws IASDeploymentException {
        try {
            Application applicationDD = this.request.getDescriptor();
            String linkName = null;
            boolean lastInService = false;
            Iterator iter = applicationDD.getWebBundleDescriptors().iterator();
            while (iter.hasNext()) {
                String name = WebSecurityManager.getContextID((WebBundleDescriptor)iter.next());
                lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                linkName = name;
            }
            Set set = applicationDD.getEjbBundleDescriptors();
            String lastname = this.request.getName();
            if (!set.isEmpty()) {
                SecurityUtil.linkPolicyFile(lastname, linkName, lastInService);
                SecurityUtil.generatePolicyFile(lastname);
            }
            Iterator iter2 = applicationDD.getWebBundleDescriptors().iterator();
            while (iter2.hasNext()) {
                String name = WebSecurityManager.getContextID((WebBundleDescriptor)iter2.next());
                SecurityUtil.generatePolicyFile(name);
            }
        }
        catch (IASSecurityException se) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error", this.request.getName());
            throw new IASDeploymentException(msg, se);
        }
    }

    public void removePolicy() throws IASDeploymentException {
        String name = this.request.getName();
        try {
            SecurityUtil.removePolicy(name);
            String[] webcontexts = WebSecurityManagerFactory.getInstance().getAndRemoveContextIdForWebAppName(name);
            ArrayList<String> submodules = new ArrayList<String>();
            if (webcontexts == null) {
                File policyRoot;
                String policyRootDir = System.getProperty("com.sun.enterprise.jaccprovider.property.repository");
                if (policyRootDir != null && (policyRoot = new File(policyRootDir)).exists()) {
                    File[] policies = policyRoot.listFiles();
                    for (int i = 0; i < policies.length; ++i) {
                        String policy;
                        if (!policies[i].isDirectory() || !(policy = policies[i].getName()).startsWith(name + "_")) continue;
                        submodules.add(policy);
                    }
                }
                if (submodules.size() > 0) {
                    webcontexts = new String[submodules.size()];
                    webcontexts = submodules.toArray(webcontexts);
                }
            }
            if (webcontexts != null) {
                for (int i = 0; i < webcontexts.length; ++i) {
                    if (webcontexts[i] == null) continue;
                    SecurityUtil.removePolicy(webcontexts[i]);
                }
            }
        }
        catch (IASSecurityException ex) {
            String msg = localStrings.getString("enterprise.deployment.backend.remove_policy_error", name);
            this.logger.log(Level.WARNING, msg, ex);
            throw new IASDeploymentException(msg, ex);
        }
    }

    static {
        $assertionsDisabled = !AppDeployerBase.class.desiredAssertionStatus();
        localStrings = StringManager.getManager(AppDeployerBase.class);
    }
}

