/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerImpl;
import com.sun.enterprise.deployment.autodeploy.AutoDeployDirectoryScanner;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileFilter;
import java.util.logging.Level;
import java.util.logging.Logger;

class AutoDeployFileFilter
implements FileFilter {
    private static final Logger sLogger = AutoDeployControllerImpl.sLogger;
    private static StringManager localStrings = StringManager.getManager(AutoDeployDirectoryScanner.class);
    String type = null;

    AutoDeployFileFilter(String type) {
        this.type = type;
    }

    public boolean accept(File f) {
        String msg;
        boolean flag = false;
        if (this.type.equals("all")) {
            return this.quickCheck(f);
        }
        String name = f.getName();
        String fileType = null;
        int lastIndex = -1;
        if (name != null && name.length() > 0) {
            lastIndex = name.lastIndexOf(46);
            try {
                if (lastIndex >= 0) {
                    fileType = name.substring(lastIndex + 1);
                }
                if (!f.isDirectory() && fileType != null && fileType.equals(this.type)) {
                    name = name.substring(0, lastIndex);
                    if (f.canWrite() && f.canRead() && name != null && name.length() > 0) {
                        flag = true;
                    } else {
                        msg = localStrings.getString("enterprise.deployment.autodeploy.not_selecting_file", f.getAbsolutePath());
                        sLogger.log(Level.INFO, msg);
                    }
                }
            }
            catch (SecurityException se) {
                String msg2 = localStrings.getString("enterprise.deployment.autodeploy.security_exception_occured", f.getName());
                sLogger.log(Level.WARNING, msg2 + se.getMessage());
            }
            catch (Exception e) {
                String msg3 = localStrings.getString("enterprise.deployment.autodeploy.exception_occured", f.getName());
                sLogger.log(Level.WARNING, msg3 + e.getMessage());
            }
        }
        if (flag) {
            msg = localStrings.getString("enterprise.deployment.autodeploy.selecting_file", f.getAbsolutePath());
            sLogger.log(Level.FINE, msg);
        }
        return flag;
    }

    private boolean quickCheck(File f) {
        boolean flag = false;
        String name = f.getName();
        String fileType = null;
        int lastIndex = -1;
        if (name != null && name.length() > 0) {
            lastIndex = name.lastIndexOf(46);
            try {
                if (lastIndex >= 0) {
                    fileType = name.substring(lastIndex + 1);
                    if (!f.isDirectory() && fileType != null && !fileType.equals("") && (fileType.equals("ear") || fileType.equals("war") || fileType.equals("jar") || fileType.equals("rar"))) {
                        flag = true;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return flag;
    }
}

