/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerImpl;
import com.sun.enterprise.deployment.autodeploy.AutoDeployFileFilter;
import com.sun.enterprise.deployment.autodeploy.AutoDeployedFilesManager;
import com.sun.enterprise.deployment.autodeploy.DirectoryScanner;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileFilter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoDeployDirectoryScanner
implements DirectoryScanner {
    private static final Logger sLogger = AutoDeployControllerImpl.sLogger;
    private static StringManager localStrings = StringManager.getManager(AutoDeployDirectoryScanner.class);

    public File[] getAllDeployableEntity(File autodeployDir, String type) {
        if (type.equals("ear")) {
            return this.getAllDeployableApplications(autodeployDir);
        }
        if (type.equals("war")) {
            return this.getAllDeployableWarModules(autodeployDir);
        }
        if (type.equals("jar")) {
            return this.getAllDeployableEjbModules(autodeployDir);
        }
        if (type.equals("rar")) {
            return this.getAllDeployableRarModules(autodeployDir);
        }
        return null;
    }

    public void deployedEntity(File autodeployDir, File deployedEntity) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            adfm.setDeployedFileInfo(deployedEntity);
            adfm.writeStatus();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void undeployedApplication(File autodeployDir, String application) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            adfm.deleteDeployedFileInfo(application);
            adfm.writeStatus();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public boolean hasNewDeployableEntity(File autodeployDir) {
        boolean newFilesExist = false;
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            if (adfm.getFilesForDeployment(autodeployDir.listFiles(this.createFileFilter("all"))).length > 0) {
                newFilesExist = true;
            }
        }
        catch (Exception e) {
            this.printException(e);
            return false;
        }
        return newFilesExist;
    }

    public String[] getAllApplicationsForUndeployment(File autodeployDir) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            return adfm.getApplicationsForUndeployment(autodeployDir.listFiles(this.createFileFilter("all")));
        }
        catch (Exception e) {
            this.printException(e);
            return new String[0];
        }
    }

    protected FileFilter createFileFilter(String type) {
        return new AutoDeployFileFilter(type);
    }

    protected File[] getAllDeployableApplications(File autodeployDir) {
        try {
            AutoDeployedFilesManager adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
            return adfm.getFilesForDeployment(autodeployDir.listFiles(this.createFileFilter("ear")));
        }
        catch (Exception e) {
            this.printException(e);
            return new File[0];
        }
    }

    protected File[] getAllDeployableWarModules(File autodeployDir) {
        AutoDeployedFilesManager adfm = null;
        try {
            adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
        }
        catch (Exception e) {
            this.printException(e);
            return new File[0];
        }
        return adfm.getFilesForDeployment(autodeployDir.listFiles(this.createFileFilter("war")));
    }

    protected File[] getAllDeployableEjbModules(File autodeployDir) {
        AutoDeployedFilesManager adfm = null;
        try {
            adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
        }
        catch (Exception e) {
            this.printException(e);
            return new File[0];
        }
        return adfm.getFilesForDeployment(autodeployDir.listFiles(this.createFileFilter("jar")));
    }

    protected File[] getAllDeployableRarModules(File autodeployDir) {
        AutoDeployedFilesManager adfm = null;
        try {
            adfm = AutoDeployedFilesManager.loadStatus(autodeployDir);
        }
        catch (Exception e) {
            this.printException(e);
            return new File[0];
        }
        return adfm.getFilesForDeployment(autodeployDir.listFiles(this.createFileFilter("rar")));
    }

    protected void printException(Exception e) {
        sLogger.log(Level.SEVERE, e.getMessage(), e);
        e.printStackTrace();
    }
}

