/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.deployment.archivist.InputJarArchive;
import com.sun.enterprise.deployment.archivist.PluggableArchivists;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

public class PluggableArchivistsHelper
implements PluggableArchivists {
    private Archivist[] archivists = new Archivist[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archivist getArchivistForArchive(String path) throws IOException {
        AbstractArchive archive;
        File f = new File(path);
        if (!f.exists()) {
            throw new FileNotFoundException(path);
        }
        if (f.isDirectory()) {
            archive = new FileArchive();
            ((FileArchive)archive).open(path);
        } else {
            archive = new InputJarArchive();
            ((InputJarArchive)archive).open(path);
        }
        Archivist archivist = null;
        try {
            archivist = this.getArchivistForArchive(archive);
        }
        finally {
            archive.close();
        }
        return archivist;
    }

    public Archivist getArchivistForArchive(File jarFileOrDirectory) throws IOException {
        return this.getArchivistForArchive(jarFileOrDirectory.getAbsolutePath());
    }

    public Archivist getArchivistForArchive(AbstractArchive archive) throws IOException {
        for (int i = 0; i < this.archivists.length; ++i) {
            if (!this.archivists[i].handles(archive)) continue;
            try {
                Archivist archivist = (Archivist)this.archivists[i].getClass().newInstance();
                archivist.setPluggableArchivists(this);
                return archivist;
            }
            catch (Exception e) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.archivistInstantiationFailure", new Object[]{this.archivists[i].getClass(), archive});
                e.printStackTrace();
            }
        }
        DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.archivistInstantiationFailure", new Object[]{null, archive});
        return null;
    }

    public Archivist getArchivistForType(ModuleType type) {
        for (int i = 0; i < this.archivists.length; ++i) {
            if (!this.archivists[i].getModuleType().equals(type)) continue;
            try {
                Archivist archivist = (Archivist)this.archivists[i].getClass().newInstance();
                archivist.setPluggableArchivists(this);
                return archivist;
            }
            catch (Exception e) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.archivistInstantiationFailure", new Object[]{this.archivists[i].getClass(), type});
                e.printStackTrace();
            }
        }
        DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.archivistInstantiationFailure", new Object[]{null, type});
        return null;
    }

    public void registerArchivist(Archivist archivist) {
        for (int i = 0; i < this.archivists.length; ++i) {
            if (!this.archivists[i].getModuleType().equals(archivist.getModuleType())) continue;
            this.archivists[i] = archivist;
            return;
        }
        Archivist[] newArchivists = new Archivist[this.archivists.length + 1];
        System.arraycopy(this.archivists, 0, newArchivists, 0, this.archivists.length);
        newArchivists[this.archivists.length] = archivist;
        this.archivists = newArchivists;
    }

    public Archivist[] getRegisteredArchivists() {
        Archivist[] newArchivists = new Archivist[this.archivists.length + 1];
        System.arraycopy(this.archivists, 0, newArchivists, 0, this.archivists.length);
        return newArchivists;
    }
}

