/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.EjbDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.EjbRuntimeDDFile;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EjbBundleValidator;
import com.sun.enterprise.deployment.util.ModuleContentValidator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

public class EjbArchivist
extends Archivist {
    EjbBundleDescriptor descriptor = null;
    DeploymentDescriptorFile standardDD = new EjbDeploymentDescriptorFile();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbArchivist.class);

    public ModuleType getModuleType() {
        return ModuleType.EJB;
    }

    public void setDescriptor(Descriptor descriptor) {
        if (!(descriptor instanceof EjbBundleDescriptor)) {
            Set ejbBundles;
            if (descriptor instanceof Application && (ejbBundles = ((Application)descriptor).getEjbBundleDescriptors()).size() > 0) {
                this.descriptor = (EjbBundleDescriptor)ejbBundles.iterator().next();
                if (this.descriptor.getModuleDescriptor().isStandalone()) {
                    return;
                }
                this.descriptor = null;
            }
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.descriptorFailure", new Object[]{this});
            throw new RuntimeException("Error setting descriptor " + descriptor + " in " + this);
        }
        this.descriptor = (EjbBundleDescriptor)descriptor;
    }

    public DeploymentDescriptorFile getStandardDDFile() {
        return this.standardDD;
    }

    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new EjbRuntimeDDFile();
    }

    public String getWebServicesDeploymentDescriptorPath() {
        return "META-INF/webservices.xml";
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    protected void postOpen(RootDeploymentDescriptor descriptor, AbstractArchive archive) throws IOException {
        super.postOpen(descriptor, archive);
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)descriptor;
        ModuleContentValidator mdv = new ModuleContentValidator(archive);
        ejbBundle.visit(mdv);
    }

    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        this.descriptor.visit(new EjbBundleValidator());
    }

    protected void prepareForInclusion(AbstractArchive out) throws IOException {
        String ejbClientJarUri = this.descriptor.getEjbClientJarUri();
        if (!ejbClientJarUri.equals("")) {
            String ejbClientJarPath = ejbClientJarUri.replace('/', File.separatorChar);
            File ejbJarFile = new File(this.path);
            File ejbClientJar = new File(ejbJarFile.getParentFile(), ejbClientJarPath);
            if (ejbClientJar.exists()) {
                EjbArchivist.addFileToArchive(out, ejbClientJar.getAbsolutePath(), ejbClientJarUri);
                String classPath = this.getClassPath();
                classPath = classPath == null ? ejbClientJarUri : classPath + " " + ejbClientJarUri;
                this.setClassPath(classPath);
            } else {
                throw new FileNotFoundException(localStrings.getLocalString("enterprise.deployment.noclientjarentry", "Warning: {0} not found as a client jar entry.", new Object[]{ejbClientJar.toString()}));
            }
        }
    }
}

