/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.archivist.AbstractArchive;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class DeploymentPlanArchive
extends AbstractArchive {
    JarFile jarFile = null;
    String archiveUri = null;
    Vector elements = null;
    String subArchiveUri = null;

    public void open(String path) throws IOException {
        this.archiveUri = path;
        File f = new File(path);
        if (f.exists()) {
            this.jarFile = new JarFile(f);
        }
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        if (this.getArchiveUri() == null) {
            return -1L;
        }
        File tmpFile = new File(this.getArchiveUri());
        return tmpFile.length();
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
            this.jarFile = null;
        }
    }

    public void closeEntry() throws IOException {
    }

    public void closeEntry(AbstractArchive sub) throws IOException {
    }

    public boolean delete() {
        File f = new File(this.archiveUri);
        if (f.exists()) {
            return FileUtils.deleteFile(f);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration entries() {
        Enumeration<Object> e;
        if (this.elements == null) {
            DeploymentPlanArchive deploymentPlanArchive = this;
            synchronized (deploymentPlanArchive) {
                this.elements = new Vector();
                e = this.jarFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = (ZipEntry)e.nextElement();
                    if (ze.isDirectory() || ze.getName().equals("META-INF/MANIFEST.MF")) continue;
                    this.elements.add(ze.getName());
                }
            }
        }
        Vector<String> entries = new Vector<String>();
        e = this.elements.elements();
        while (e.hasMoreElements()) {
            String entryName;
            String mangledName = entryName = (String)e.nextElement();
            String prefix = "META-INF/";
            if (entryName.indexOf("sun-web.xml") != -1) {
                prefix = "WEB-INF/";
            }
            if (this.subArchiveUri != null && entryName.startsWith(this.subArchiveUri)) {
                mangledName = mangledName.substring(this.subArchiveUri.length() + 1);
            }
            mangledName = entryName.endsWith(".dbschema") ? mangledName.replaceAll("#", "/") : prefix + mangledName;
            if (this.subArchiveUri == null) {
                if (entryName.indexOf(".jar.") != -1 || entryName.indexOf(".war.") != -1 || entryName.indexOf(".rar.") != -1) continue;
                entries.add(mangledName);
                continue;
            }
            if (!entryName.startsWith(this.subArchiveUri)) continue;
            entries.add(mangledName);
        }
        return entries.elements();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public boolean exists() {
        File f = new File(this.archiveUri);
        return f.exists();
    }

    public String getArchiveUri() {
        return this.archiveUri;
    }

    public AbstractArchive getEmbeddedArchive(String name) throws IOException {
        if (this.jarFile == null) {
            return null;
        }
        DeploymentPlanArchive dpArchive = new DeploymentPlanArchive();
        dpArchive.jarFile = new JarFile(this.archiveUri);
        dpArchive.archiveUri = this.archiveUri + File.separator + name;
        dpArchive.subArchiveUri = name;
        dpArchive.elements = this.elements;
        return dpArchive;
    }

    public InputStream getEntry(String name) throws IOException {
        name = name.endsWith(".dbschema") ? name.replaceAll("/", "#") : name.substring(name.lastIndexOf(47) + 1);
        if (this.subArchiveUri == null) {
            return this.getElement(name);
        }
        String mangledName = this.subArchiveUri + "." + name;
        return this.getElement(mangledName);
    }

    private InputStream getElement(String name) throws IOException {
        if (this.elements.contains(name)) {
            return this.jarFile.getInputStream(this.jarFile.getEntry(name));
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        return new Manifest();
    }

    public URI getURI() {
        File f = new File(this.archiveUri);
        try {
            return new URI("jar://" + f.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public OutputStream putNextEntry(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean renameTo(String name) {
        File f = new File(this.archiveUri);
        boolean result = FileUtils.renameFile(f, new File(name));
        if (result) {
            this.archiveUri = name;
        }
        return result;
    }
}

