/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import java.util.HashSet;
import java.util.Set;

public class ServletFilterMappingDescriptor
extends Descriptor
implements ServletFilterMapping {
    public static final String TARGET_TYPE_URLPATTERN = "URLPattern";
    public static final String TARGET_TYPE_SERVLET = "Servlet";
    public static String INCLUDE = "INCLUDE";
    public static String REQUEST = "REQUEST";
    public static String FORWARD = "FORWARD";
    private static Set allowed_dispatchers;
    private String targetType = "URLPattern";
    private String target = "";
    private Set dispatchers;

    public ServletFilterMappingDescriptor() {
        super("", "");
    }

    public ServletFilterMappingDescriptor(ServletFilterMappingDescriptor other) {
        super(other);
        this.targetType = other.targetType;
        this.target = other.target;
        this.dispatchers = other.dispatchers != null ? new HashSet(other.dispatchers) : null;
    }

    public ServletFilterMappingDescriptor(String dispName, String targetType, String target) {
        super(dispName, "");
        this.setTargetType(targetType);
        this.setTarget(target);
    }

    public void setTargetType(String type) {
        this.targetType = TARGET_TYPE_SERVLET.equals(type) ? TARGET_TYPE_SERVLET : TARGET_TYPE_URLPATTERN;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public boolean isURLPatternTarget() {
        return TARGET_TYPE_URLPATTERN.equals(this.targetType);
    }

    public boolean isServletNameTarget() {
        return TARGET_TYPE_SERVLET.equals(this.targetType);
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public void addDispatcher(String dispatcher) {
        if (this.dispatchers == null) {
            this.dispatchers = new HashSet();
        }
        this.dispatchers.add(dispatcher);
    }

    public void removeDispatcher(String dispatcher) {
        if (this.dispatchers == null) {
            return;
        }
        this.dispatchers.remove(dispatcher);
    }

    public Set getDispatchers() {
        if (this.dispatchers == null) {
            this.dispatchers = new HashSet();
        }
        return this.dispatchers;
    }

    public static Set getAllowedDispatchers() {
        if (allowed_dispatchers == null) {
            allowed_dispatchers = new HashSet();
            allowed_dispatchers.add(INCLUDE);
            allowed_dispatchers.add(REQUEST);
            allowed_dispatchers.add(FORWARD);
        }
        return allowed_dispatchers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServletFilterMapping) {
            ServletFilterMapping o = (ServletFilterMapping)obj;
            if (this.getName().equals(o.getName()) && this.getTargetType().equals(o.getTargetType()) && this.getTarget().equals(o.getTarget())) {
                return true;
            }
        }
        return false;
    }
}

