/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.web.ContextParameter;
import com.sun.enterprise.deployment.web.EnvironmentEntry;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.WebDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class EnvironmentProperty
extends Descriptor
implements InitializationParameter,
ContextParameter,
WebDescriptor,
EnvironmentEntry {
    private String value;
    private String type;
    private Object valueObject;
    private static Class[] allowedTypes = new Class[]{Integer.TYPE, Boolean.TYPE, Double.TYPE, Float.TYPE, Long.TYPE, Short.TYPE, Byte.TYPE, Character.TYPE, String.class, Boolean.class, Integer.class, Double.class, Byte.class, Short.class, Long.class, Float.class, Character.class};
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnvironmentProperty.class);

    public EnvironmentProperty(EnvironmentProperty other) {
        super(other);
        this.value = other.value;
        this.type = other.type;
        this.valueObject = other.valueObject;
    }

    public EnvironmentProperty() {
    }

    public EnvironmentProperty(String name, String value, String description) {
        this(name, value, description, null);
    }

    public EnvironmentProperty(String name, String value, String description, String type) {
        super(name, description);
        this.value = value;
        this.checkType(type);
        this.type = type;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = "";
        }
        return this.value;
    }

    private void checkType(String type) {
        if (type != null) {
            Class<?> typeClass = null;
            try {
                typeClass = Class.forName(type);
            }
            catch (Throwable t) {
                if (this.isBoundsChecking()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment..exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{type}));
                }
                return;
            }
            boolean allowedType = false;
            for (int i = 0; i < allowedTypes.length; ++i) {
                if (!allowedTypes[i].equals(typeClass)) continue;
                allowedType = true;
                break;
            }
            if (this.isBoundsChecking() && !allowedType) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedprprtytype", "{0} is not an allowed property value type", new Object[]{type}));
            }
        }
    }

    public Object getValueObject() {
        if (this.valueObject == null) {
            this.valueObject = "";
        }
        return this.getObjectFromString(this.getValue(), this.getValueType());
    }

    public Class getValueType() {
        if (this.type == null) {
            return String.class;
        }
        try {
            return Class.forName(this.type);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void setType(String type) {
        this.checkType(type);
        this.type = type;
    }

    public String getType() {
        if (this.type == null) {
            if (this.isBoundsChecking()) {
                this.type = String.class.getName();
            }
        }
        return this.type;
    }

    public void setValue(String value) {
        this.value = value;
        super.changed();
    }

    public boolean equals(Object other) {
        return other instanceof EnvironmentProperty && this.getName().equals(((EnvironmentProperty)other).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Env-Prop: ").append(super.getName()).append("@").append(this.getType()).append("@").append(this.getValue()).append("@").append(super.getDescription());
    }

    private Object getObjectFromString(String string, Class type) {
        if (type == null) {
            Object obj;
            if (!this.isBoundsChecking() && (obj = this.getValueObjectUsingAllowedTypes(string)) != null) {
                return obj;
            }
        }
        if (string == null || "".equals(string) && !type.equals(String.class)) {
            return null;
        }
        try {
            if (String.class.equals(type)) {
                return string;
            }
            if (Boolean.class.equals(type)) {
                return new Boolean(string);
            }
            if (Integer.class.equals(type)) {
                return new Integer(string);
            }
            if (Double.class.equals(type)) {
                return new Double(string);
            }
            if (Float.class.equals(type)) {
                return new Float(string);
            }
            if (Short.class.equals(type)) {
                return new Short(string);
            }
            if (Byte.class.equals(type)) {
                return new Byte(string);
            }
            if (Long.class.equals(type)) {
                return new Long(string);
            }
            if (Character.class.equals(type)) {
                if (string.length() != 1) {
                    throw new IllegalArgumentException();
                }
                return new Character(string.charAt(0));
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncouldnotcreateinstancetype", "Could not create instance of {0} from {1}\n reason: {2}" + t, new Object[]{type, string, t}));
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionillegaltypeenvproperty", "Illegal type for environment properties: {0}", new Object[]{type}));
    }

    private Object getValueObjectUsingAllowedTypes(String string) throws IllegalArgumentException {
        if (this.type.equals(Integer.TYPE.getName())) {
            return new Integer(string);
        }
        if (this.type.equals(Long.TYPE.getName())) {
            return new Long(string);
        }
        if (this.type.equals(Short.TYPE.getName())) {
            return new Short(string);
        }
        if (this.type.equals(Boolean.TYPE.getName())) {
            return new Boolean(string);
        }
        if (this.type.equals(Float.TYPE.getName())) {
            return new Float(string);
        }
        if (this.type.equals(Double.TYPE.getName())) {
            return new Double(string);
        }
        if (this.type.equals(Byte.TYPE.getName())) {
            return new Byte(string);
        }
        if (this.type.equals(Character.TYPE.getName())) {
            if (string.length() != 1) {
                throw new IllegalArgumentException();
            }
            return new Character(string.charAt(0));
        }
        return null;
    }
}

