/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class EjbReferenceDescriptor
extends EnvironmentProperty
implements EjbReference,
NamedDescriptor {
    private EjbDescriptor ejbDescriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbReferenceDescriptor.class);
    private BundleDescriptor referringBundle;
    private String refType = null;
    private String refHomeIntf = null;
    private String refIntf = null;
    private boolean isLocal = false;
    private String ejbLink = null;

    public EjbReferenceDescriptor(EjbReferenceDescriptor other) {
        super(other);
        this.isLocal = other.isLocal;
        this.refType = other.refType;
        this.refHomeIntf = other.refHomeIntf;
        this.refIntf = other.refIntf;
        this.ejbLink = other.ejbLink;
        this.referringBundle = other.referringBundle;
        this.ejbDescriptor = other.ejbDescriptor;
        if (this.ejbDescriptor != null) {
            this.ejbDescriptor.addEjbReferencer(this);
        }
    }

    public EjbReferenceDescriptor(String name, String description, EjbDescriptor ejbDescriptor) {
        super(name, "", description);
        this.setEjbDescriptor(ejbDescriptor);
    }

    public EjbReferenceDescriptor(String name, String description, EjbDescriptor ejbDescriptor, boolean isLocal) {
        super(name, "", description);
        this.isLocal = isLocal;
        this.setEjbDescriptor(ejbDescriptor);
    }

    public EjbReferenceDescriptor() {
    }

    public void setReferringBundleDescriptor(BundleDescriptor referringBundle) {
        this.referringBundle = referringBundle;
    }

    public BundleDescriptor getReferringBundleDescriptor() {
        return this.referringBundle;
    }

    public void setEjbDescriptor(EjbDescriptor ejbDescriptor) {
        if (this.ejbDescriptor != null) {
            this.ejbDescriptor.removeEjbReferencer(this);
        }
        this.ejbDescriptor = ejbDescriptor;
        if (ejbDescriptor != null) {
            ejbDescriptor.addEjbReferencer(this);
            if (this.isLocal()) {
                if (ejbDescriptor.getLocalClassName() == null) {
                    throw new RuntimeException(localStrings.getLocalString("entreprise.deployment.invalidLocalInterfaceReference", "Trying to set an ejb-local-ref on an EJB while the EJB does not define local interfaces"));
                }
            } else if (ejbDescriptor.getRemoteClassName() == null) {
                throw new RuntimeException(localStrings.getLocalString("entreprise.deployment.invalidRemoteInterfaceReference", "Trying to set an ejb-ref on an EJB, while the EJB does not define remote interfaces"));
            }
        }
    }

    public void setJndiName(String jndiName) {
        this.setValue(jndiName);
    }

    public boolean isLinked() {
        return this.ejbLink != null;
    }

    public String getLinkName() {
        if (this.ejbDescriptor == null) {
            return this.ejbLink;
        }
        if (this.ejbLink != null && this.ejbLink.length() != 0) {
            return this.ejbLink;
        }
        return this.ejbDescriptor.getName();
    }

    public void setLinkName(String linkName) {
        this.ejbLink = linkName;
    }

    public String getJndiName() {
        return this.getValue();
    }

    public String getValue() {
        if (this.ejbDescriptor == null) {
            return super.getValue();
        }
        if (this.isLocal()) {
            return this.ejbDescriptor.getLocalJndiName();
        }
        return this.ejbDescriptor.getJndiName();
    }

    public EjbDescriptor getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean local) {
        this.isLocal = local;
    }

    public String getType() {
        if (this.ejbDescriptor == null) {
            return this.refType;
        }
        return this.ejbDescriptor.getType();
    }

    public void setType(String type) {
        this.refType = type;
    }

    public String getHomeClassName() {
        if (this.ejbDescriptor == null) {
            return this.refHomeIntf;
        }
        if (this.isLocal) {
            return this.ejbDescriptor.getLocalHomeClassName();
        }
        return this.ejbDescriptor.getHomeClassName();
    }

    public void setHomeClassName(String homeClassName) {
        this.refHomeIntf = homeClassName;
    }

    public String getBeanClassName() {
        if (this.ejbDescriptor == null) {
            return this.refIntf;
        }
        if (this.isLocal) {
            return this.getEjbDescriptor().getLocalClassName();
        }
        return this.getEjbDescriptor().getRemoteClassName();
    }

    public void setBeanClassName(String remoteClassName) {
        this.refIntf = remoteClassName;
    }

    public String getEjbHomeInterface() {
        return this.getHomeClassName();
    }

    public void setEjbHomeInterface(String homeClassName) {
        this.setHomeClassName(homeClassName);
    }

    public String getEjbInterface() {
        return this.getBeanClassName();
    }

    public void setEjbInterface(String remoteClassName) {
        this.setBeanClassName(remoteClassName);
    }

    public void print(StringBuffer toStringBuffer) {
        if (this.ejbDescriptor != null) {
            toStringBuffer.append("Resolved Ejb-Ref ").append(this.getName()).append("@jndi: ").append(this.getJndiName()).append(" - > ").append(this.ejbDescriptor.getName());
        } else {
            toStringBuffer.append("Unresolved Ejb-Ref ").append(this.getName()).append("@jndi: ").append(this.getJndiName()).append("@").append(this.getEjbHomeInterface()).append("@").append(this.getEjbInterface()).append("@").append(this.refType).append("@").append(this.ejbLink);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof EjbReference) {
            EjbReference ejbReference = (EjbReference)object;
            return ejbReference.getName().equals(this.getName());
        }
        return false;
    }
}

