/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.util.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class DirectoryArchive
implements AbstractArchive {
    private File root;
    private TreeSet entries;
    private List directories;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public DirectoryArchive(String path) {
        this.root = new File(path);
        if (!this.root.exists()) {
            this.root.mkdirs();
        }
        this.entries = new TreeSet();
        this.directories = new LinkedList();
    }

    public AbstractArchive copy() {
        DirectoryArchive newArchive = new DirectoryArchive(this.root.toString());
        newArchive.entries.addAll(this.entries);
        return newArchive;
    }

    public void addEntry(String entryName, InputStream source) throws IOException {
        String filename = entryName.replace('/', File.separatorChar);
        File file = new File(this.root, filename);
        File parent = new File(file.getParent());
        if (!parent.exists()) {
            parent.mkdirs();
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        Archivist.copyWithoutClose(source, bos);
        bos.close();
        this.entries.add(entryName);
    }

    public void addEntry(File inputFile) throws IOException {
        String path = inputFile.getAbsolutePath();
        if (path.startsWith(this.root.getAbsolutePath())) {
            String parent = inputFile.getParent();
            this.entries.add(this.getRelativePath(path));
        } else {
            File searchFile = new File(this.root, inputFile.toString());
            if (searchFile.exists()) {
                this.entries.add(inputFile.toString());
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "WARNING , implement file copy for " + path + " in DIRECTORY ARCHIVE");
            }
        }
    }

    public Set getListOfEntries() {
        return this.entries;
    }

    public File getWriteableDirectory() {
        return this.root;
    }

    public File getSourceDirectory() {
        return this.root;
    }

    public void makeJar(File destination) throws IOException {
        ZipOutputStream jarOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
        jarOut.setLevel(0);
        Iterator entriesIterator = this.entries.iterator();
        while (entriesIterator.hasNext()) {
            String entry = (String)entriesIterator.next();
            File entryFile = new File(this.root, entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(entryFile));
            try {
                jarOut.putNextEntry(new ZipEntry(entry.replace(File.separatorChar, '/')));
                Archivist.copy(bis, jarOut);
                jarOut.closeEntry();
            }
            catch (ZipException ze) {}
        }
        jarOut.close();
    }

    private String getRelativePath(String absolutePath) {
        return absolutePath.substring(this.root.getAbsolutePath().length() + File.separator.length());
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }
}

